/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginConfiguration
extends ProductObject
implements IPluginConfiguration {
    private static final long serialVersionUID = -3549668957352554876L;
    private boolean fAutoStart;
    private int fStartLevel;
    private String fId;

    PluginConfiguration(IProductModel model) {
        super(model);
    }

    @Override
    public void parse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this.fId = element.getAttribute("id");
            this.fAutoStart = Boolean.parseBoolean(element.getAttribute("autoStart"));
            this.fStartLevel = Integer.parseInt(element.getAttribute("startLevel"));
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<plugin id=\"" + this.fId + "\"");
        writer.print(" autoStart=\"" + this.fAutoStart + "\"");
        writer.print(" startLevel=\"" + this.fStartLevel + "\"");
        writer.println(" />");
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public int getStartLevel() {
        return this.fStartLevel;
    }

    @Override
    public boolean isAutoStart() {
        return this.fAutoStart;
    }

    @Override
    public void setAutoStart(boolean autostart) {
        boolean oldValue = this.fAutoStart;
        this.fAutoStart = autostart;
        if (this.isEditable() && oldValue != this.fAutoStart) {
            this.firePropertyChanged("autoStart", oldValue, this.fAutoStart);
        }
    }

    @Override
    public void setStartLevel(int startLevel) {
        int oldValue = this.fStartLevel;
        this.fStartLevel = startLevel;
        if (this.isEditable() && oldValue != this.fStartLevel) {
            this.firePropertyChanged("startLevel", oldValue, this.fStartLevel);
        }
    }

    @Override
    public void setId(String id) {
        this.fId = id;
    }
}

