/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.util;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.util.IEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventListenerRegistry<T extends Enum<T>, E> {
    private final Class<T> eventTypeClass;
    private final Map<T, Set<IEventListener<E>>> listeners;

    public EventListenerRegistry(Class<T> eventTypeClass) {
        this.eventTypeClass = eventTypeClass;
        this.listeners = new EnumMap<T, Set<IEventListener<E>>>(this.eventTypeClass);
        Enum[] enumArray = (Enum[])this.eventTypeClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum t = enumArray[n2];
            this.listeners.put(t, new CopyOnWriteArraySet());
            ++n2;
        }
    }

    public void addListener(IEventListener<E> listener, T ... types) {
        if (listener == null || types == null) {
            throw new IllegalArgumentException();
        }
        T[] TArray = types.length > 0 ? types : (Enum[])this.eventTypeClass.getEnumConstants();
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T type = TArray[n2];
            this.listeners.get(type).add(listener);
            ++n2;
        }
    }

    public void removeListener(IEventListener<E> listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        for (Set<IEventListener<E>> listeners : this.listeners.values()) {
            listeners.remove(listener);
        }
    }

    public void notifyListeners(T eventType, E event) {
        for (IEventListener<E> listener : this.listeners.get(eventType)) {
            try {
                listener.handleEvent(event);
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
            }
        }
    }
}

