/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.IDynamicExtensionRegistry;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.discovery.core.model.Directory;
import org.eclipse.mylyn.internal.discovery.core.model.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

class DiscoveryRegistryStrategy
extends RegistryStrategy {
    private final List<JarFile> jars = new ArrayList<JarFile>();
    private final Map<IContributor, File> contributorToJarFile = new HashMap<IContributor, File>();
    private final Map<IContributor, Directory.Entry> contributorToDirectoryEntry = new HashMap<IContributor, Directory.Entry>();
    private final Object token;
    private Map<File, Directory.Entry> bundleFileToDirectoryEntry;

    public DiscoveryRegistryStrategy(File[] storageDirs, boolean[] cacheReadOnly, Object token) {
        super(storageDirs, cacheReadOnly);
        this.token = token;
    }

    public void onStart(IExtensionRegistry registry, boolean loadedFromCache) {
        super.onStart(registry, loadedFromCache);
        if (!loadedFromCache) {
            this.processDiscoveryCoreBundle(registry);
            this.processBundles(registry);
        }
    }

    private void processDiscoveryCoreBundle(IExtensionRegistry registry) {
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.mylyn.discovery.core");
            RegistryContributor contributor = new RegistryContributor(bundle.getSymbolicName(), bundle.getSymbolicName(), null, null);
            try (InputStream inputStream = bundle.getEntry("plugin.xml").openStream();){
                registry.addContribution(inputStream, (IContributor)contributor, false, bundle.getSymbolicName(), null, this.token);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    private void processBundles(IExtensionRegistry registry) {
        if (this.bundleFileToDirectoryEntry == null) {
            throw new IllegalStateException();
        }
        for (Map.Entry<File, Directory.Entry> bundleFile : this.bundleFileToDirectoryEntry.entrySet()) {
            try {
                this.processBundle(registry, bundleFile.getValue(), bundleFile.getKey());
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)Messages.DiscoveryRegistryStrategy_cannot_load_bundle, (Object[])new Object[]{bundleFile.getKey().getName(), bundleFile.getValue().getLocation(), e.getMessage()}), (Throwable)e));
            }
        }
    }

    private void processBundle(IExtensionRegistry registry, Directory.Entry entry, File bundleFile) throws IOException {
        JarFile jarFile = new JarFile(bundleFile);
        this.jars.add(jarFile);
        ZipEntry pluginXmlEntry = jarFile.getEntry("plugin.xml");
        if (pluginXmlEntry == null) {
            throw new IOException(Messages.DiscoveryRegistryStrategy_missing_pluginxml);
        }
        RegistryContributor contributor = new RegistryContributor(bundleFile.getName(), bundleFile.getName(), null, null);
        if (((IDynamicExtensionRegistry)registry).hasContributor((IContributor)contributor)) {
            jarFile.close();
            return;
        }
        this.contributorToJarFile.put((IContributor)contributor, bundleFile);
        this.contributorToDirectoryEntry.put((IContributor)contributor, entry);
        ResourceBundle translationBundle = this.loadTranslationBundle(jarFile);
        try (InputStream inputStream = jarFile.getInputStream(pluginXmlEntry);){
            registry.addContribution(inputStream, (IContributor)contributor, false, bundleFile.getPath(), translationBundle, this.token);
        }
    }

    private ResourceBundle loadTranslationBundle(JarFile jarFile) throws IOException {
        List<String> bundleNames = this.computeBundleNames("plugin");
        for (String bundleName : bundleNames) {
            ZipEntry entry = jarFile.getEntry(bundleName);
            if (entry == null) continue;
            try (InputStream inputStream = jarFile.getInputStream(entry);){
                PropertyResourceBundle resourceBundle;
                PropertyResourceBundle propertyResourceBundle = resourceBundle = new PropertyResourceBundle(inputStream);
                return propertyResourceBundle;
            }
        }
        return null;
    }

    private List<String> computeBundleNames(String baseName) {
        String suffix = ".properties";
        String name = baseName;
        ArrayList<String> bundleNames = new ArrayList<String>();
        Locale locale = Locale.getDefault();
        bundleNames.add(String.valueOf(name) + suffix);
        if (locale.getLanguage() != null && locale.getLanguage().length() > 0) {
            name = String.valueOf(name) + '_' + locale.getLanguage();
            bundleNames.add(0, String.valueOf(name) + suffix);
        }
        if (locale.getCountry() != null && locale.getCountry().length() > 0) {
            name = String.valueOf(name) + '_' + locale.getCountry();
            bundleNames.add(0, String.valueOf(name) + suffix);
        }
        if (locale.getVariant() != null && locale.getVariant().length() > 0) {
            name = String.valueOf(name) + '_' + locale.getVariant();
            bundleNames.add(0, String.valueOf(name) + suffix);
        }
        return bundleNames;
    }

    /*
     * Unable to fully structure code
     */
    public void onStop(IExtensionRegistry registry) {
        try {
            super.onStop(registry);
        }
        finally {
            ** for (jar : this.jars)
        }
lbl-1000:
        // 1 sources

        {
            try {
                jar.close();
            }
            catch (Exception var5_8) {
                // empty catch block
            }
            continue;
        }
lbl12:
        // 1 sources

        this.jars.clear();
    }

    public File getJarFile(IContributor contributor) {
        File file = this.contributorToJarFile.get(contributor);
        if (file == null) {
            throw new IllegalArgumentException(contributor.getName());
        }
        return file;
    }

    public Directory.Entry getDirectoryEntry(IContributor contributor) {
        Directory.Entry entry = this.contributorToDirectoryEntry.get(contributor);
        if (entry == null) {
            throw new IllegalArgumentException(contributor.getName());
        }
        return entry;
    }

    public void setBundles(Map<File, Directory.Entry> bundleFileToDirectoryEntry) {
        this.bundleFileToDirectoryEntry = bundleFileToDirectoryEntry;
    }
}

