/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.erd.ERDActivator;
import org.jkiss.dbeaver.ext.erd.ERDMessages;
import org.jkiss.dbeaver.ext.erd.command.EntityAddCommand;
import org.jkiss.dbeaver.ext.erd.command.EntityDeleteCommand;
import org.jkiss.dbeaver.ext.erd.figures.EntityDiagramFigure;
import org.jkiss.dbeaver.ext.erd.layout.DelegatingLayoutManager;
import org.jkiss.dbeaver.ext.erd.layout.GraphAnimation;
import org.jkiss.dbeaver.ext.erd.layout.GraphLayoutAuto;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;
import org.jkiss.dbeaver.ext.erd.part.NodePart;
import org.jkiss.dbeaver.ext.erd.part.NotePart;
import org.jkiss.dbeaver.ext.erd.part.PropertyAwarePart;
import org.jkiss.dbeaver.ext.erd.policy.DiagramContainerEditPolicy;
import org.jkiss.dbeaver.ui.UIUtils;

public class DiagramPart
extends PropertyAwarePart {
    private final CommandStackEventListener stackListener = new CommandStackEventListener(){

        /*
         * Unable to fully structure code
         */
        public void stackChanged(CommandStackEvent commandStackEvent) {
            block2: {
                block1: {
                    if (!(DiagramPart.access$0(DiagramPart.this).getActiveLayoutManager() instanceof GraphLayoutAuto)) break block1;
                    if (GraphAnimation.captureLayout(DiagramPart.this.getFigure())) ** GOTO lbl5
                    return;
lbl-1000:
                    // 1 sources

                    {
                        DiagramPart.this.getFigure().getUpdateManager().performUpdate();
lbl5:
                        // 2 sources

                        ** while (GraphAnimation.step())
                    }
lbl6:
                    // 1 sources

                    GraphAnimation.end();
                    break block2;
                }
                DiagramPart.this.getFigure().getUpdateManager().performUpdate();
            }
        }
    };
    private DelegatingLayoutManager delegatingLayoutManager;
    private Font normalFont;
    private Font boldFont;
    private Font italicFont;
    private Font boldItalicFont;

    @Override
    public void activate() {
        super.activate();
        this.getViewer().getEditDomain().getCommandStack().addCommandStackEventListener(this.stackListener);
    }

    @Override
    public void deactivate() {
        this.resetFonts();
        this.getViewer().getEditDomain().getCommandStack().removeCommandStackEventListener(this.stackListener);
        super.deactivate();
    }

    public void resetFonts() {
        UIUtils.dispose((Resource)this.boldFont);
        UIUtils.dispose((Resource)this.italicFont);
        UIUtils.dispose((Resource)this.boldItalicFont);
        this.normalFont = null;
        this.boldFont = null;
        this.italicFont = null;
        this.boldItalicFont = null;
    }

    protected IFigure createFigure() {
        EntityDiagramFigure figure = new EntityDiagramFigure(this);
        this.delegatingLayoutManager = new DelegatingLayoutManager(this);
        figure.setLayoutManager(this.delegatingLayoutManager);
        Control control = this.getViewer().getControl();
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if ((control.getStyle() & 0x8000000) == 0) {
            cLayer.setAntialias(1);
        }
        FanRouter router = new FanRouter();
        router.setSeparation(15);
        router.setNextRouter((ConnectionRouter)new ShortestPathConnectionRouter((IFigure)figure));
        cLayer.setConnectionRouter((ConnectionRouter)router);
        return figure;
    }

    @Override
    public EntityDiagram getDiagram() {
        return (EntityDiagram)this.getModel();
    }

    public Font getNormalFont() {
        if (this.normalFont == null) {
            this.normalFont = this.getViewer().getControl().getFont();
        }
        return this.normalFont;
    }

    public Font getBoldFont() {
        if (this.boldFont == null) {
            this.boldFont = UIUtils.makeBoldFont((Font)this.getNormalFont());
        }
        return this.boldFont;
    }

    public Font getItalicFont() {
        if (this.italicFont == null) {
            this.italicFont = UIUtils.modifyFont((Font)this.getNormalFont(), (int)2);
        }
        return this.italicFont;
    }

    public Font getBoldItalicFont() {
        if (this.boldItalicFont == null) {
            this.boldItalicFont = UIUtils.modifyFont((Font)this.getNormalFont(), (int)3);
        }
        return this.boldItalicFont;
    }

    public void rearrangeDiagram() {
        this.delegatingLayoutManager.rearrange(this.getFigure());
        this.getFigure().repaint();
    }

    protected List<?> getModelChildren() {
        return this.getDiagram().getContents();
    }

    public boolean isSelectable() {
        return false;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new DiagramContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", null);
    }

    public void setTableModelBounds() {
        List entityParts = this.getChildren();
        for (Object child : entityParts) {
            NodePart entityPart;
            IFigure entityFigure;
            if (!(child instanceof NodePart) || (entityFigure = (entityPart = (NodePart)child).getFigure()) == null) continue;
            Rectangle bounds = entityFigure.getBounds().getCopy();
            entityPart.setBounds(bounds);
        }
    }

    public boolean setTableFigureBounds(boolean updateConstraint) {
        List nodeParts = this.getChildren();
        for (Object child : nodeParts) {
            if (!(child instanceof NodePart)) continue;
            NodePart entityPart = (NodePart)child;
            Rectangle bounds = entityPart.getBounds();
            if (bounds == null) {
                return false;
            }
            IFigure entityFigure = entityPart.getFigure();
            if (entityFigure == null) {
                return false;
            }
            if (!updateConstraint) continue;
            this.delegatingLayoutManager.setXYLayoutConstraint(entityFigure, new Rectangle(bounds.x, bounds.y, -1, -1));
        }
        return true;
    }

    public void changeLayout() {
        this.getFigure().setLayoutManager((LayoutManager)this.delegatingLayoutManager);
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        super.setLayoutConstraint(child, childFigure, constraint);
    }

    @Override
    protected void handleChildChange(PropertyChangeEvent evt) {
        super.handleChildChange(evt);
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            IPreferenceStore store = ERDActivator.getDefault().getPreferenceStore();
            if (store.getBoolean("erd.grid.enabled") && store.getBoolean("erd.grid.snap")) {
                return new SnapToGrid((GraphicalEditPart)this);
            }
            return null;
        }
        return super.getAdapter(key);
    }

    @Nullable
    public NodePart getChildByObject(Object object) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof NodePart) || ((NodePart)child).getElement().getObject() != object) continue;
            return (NodePart)child;
        }
        return null;
    }

    @Nullable
    public EntityPart getEntityPart(ERDEntity erdEntity) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof EntityPart) || ((EntityPart)child).getEntity() != erdEntity) continue;
            return (EntityPart)child;
        }
        return null;
    }

    public List<EntityPart> getEntityParts() {
        ArrayList<EntityPart> result = new ArrayList<EntityPart>();
        for (Object child : this.getChildren()) {
            if (!(child instanceof EntityPart)) continue;
            result.add((EntityPart)child);
        }
        return result;
    }

    @Nullable
    public NotePart getNotePart(ERDNote erdNote) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof NotePart) || ((NotePart)child).getNote() != erdNote) continue;
            return (NotePart)child;
        }
        return null;
    }

    @NotNull
    public Command createEntityAddCommand(List<ERDEntity> entities, Point location) {
        return new EntityAddCommand(this, entities, location);
    }

    public Command createEntityDeleteCommand(EntityPart entityPart) {
        return new EntityDeleteCommand(entityPart);
    }

    public String toString() {
        return String.valueOf(ERDMessages.entity_diagram_) + " " + this.getDiagram().getName();
    }

    static /* synthetic */ DelegatingLayoutManager access$0(DiagramPart diagramPart) {
        return diagramPart.delegatingLayoutManager;
    }
}

