/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.cnfexpression;

import java.util.ArrayList;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.util.cnfexpression.MultiAndExpression;
import net.sf.jsqlparser.util.cnfexpression.MultiOrExpression;
import net.sf.jsqlparser.util.cnfexpression.MultipleExpression;

class CloneHelper {
    CloneHelper() {
    }

    public Expression modify(Expression express) {
        BinaryExpression binary;
        if (express instanceof NotExpression) {
            return new NotExpression(this.modify(((NotExpression)express).getExpression()));
        }
        if (express instanceof Parenthesis) {
            Parenthesis parenthesis = (Parenthesis)express;
            Expression result = this.modify(parenthesis.getExpression());
            if (parenthesis.isNot()) {
                return new NotExpression(result);
            }
            return result;
        }
        if (express instanceof AndExpression) {
            AndExpression and = (AndExpression)express;
            ArrayList<Expression> list = new ArrayList<Expression>();
            list.add(this.modify(and.getLeftExpression()));
            list.add(this.modify(and.getRightExpression()));
            MultiAndExpression result = new MultiAndExpression(list);
            if (and.isNot()) {
                return new NotExpression(result);
            }
            return result;
        }
        if (express instanceof OrExpression) {
            OrExpression or = (OrExpression)express;
            ArrayList<Expression> list = new ArrayList<Expression>();
            list.add(this.modify(or.getLeftExpression()));
            list.add(this.modify(or.getRightExpression()));
            MultiOrExpression result = new MultiOrExpression(list);
            if (or.isNot()) {
                return new NotExpression(result);
            }
            return result;
        }
        if (express instanceof BinaryExpression && (binary = (BinaryExpression)express).isNot()) {
            binary.removeNot();
            return new NotExpression(this.modify(binary));
        }
        return express;
    }

    public Expression shallowCopy(Expression express) {
        if (express instanceof MultipleExpression) {
            MultipleExpression multi = (MultipleExpression)express;
            ArrayList<Expression> list = new ArrayList<Expression>();
            for (int i = 0; i < multi.size(); ++i) {
                list.add(this.shallowCopy(multi.getChild(i)));
            }
            if (express instanceof MultiAndExpression) {
                return new MultiAndExpression(list);
            }
            return new MultiOrExpression(list);
        }
        return express;
    }

    public Expression changeBack(Boolean isMultiOr, Expression exp) {
        if (!(exp instanceof MultipleExpression)) {
            return exp;
        }
        MultipleExpression changed = (MultipleExpression)exp;
        Expression result = changed.getChild(0);
        for (int i = 1; i < changed.size(); ++i) {
            Expression left = result;
            Expression right = changed.getChild(i);
            result = isMultiOr != false ? new OrExpression(left, right) : new AndExpression(left, right);
        }
        if (isMultiOr.booleanValue()) {
            return new Parenthesis(result);
        }
        return result;
    }
}

