/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.utils.CommonUtils;

public class DatabaseConsumerSettings
implements IDataTransferSettings {
    private static final Log log = Log.getLog(DatabaseConsumerSettings.class);
    private String containerNodePath;
    private DBNDatabaseNode containerNode;
    private Map<DBSDataContainer, DatabaseMappingContainer> dataMappings = new LinkedHashMap<DBSDataContainer, DatabaseMappingContainer>();
    private boolean openNewConnections = true;
    private boolean useTransactions = true;
    private int commitAfterRows = 10000;
    private boolean transferAutoGeneratedColumns = true;
    private boolean truncateBeforeLoad = false;
    private boolean openTableOnFinish = true;
    private transient IDialogSettings dialogSettings;

    @Nullable
    public DBSObjectContainer getContainer() {
        if (this.containerNode == null) {
            return null;
        }
        return (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)this.containerNode.getObject());
    }

    public DBNDatabaseNode getContainerNode() {
        return this.containerNode;
    }

    public void setContainerNode(DBNDatabaseNode containerNode) {
        this.containerNode = containerNode;
    }

    public Map<DBSDataContainer, DatabaseMappingContainer> getDataMappings() {
        return this.dataMappings;
    }

    public DatabaseMappingContainer getDataMapping(DBSDataContainer dataContainer) {
        return this.dataMappings.get(dataContainer);
    }

    public boolean isCompleted(Collection<DataTransferPipe> pipes) {
        for (DataTransferPipe pipe : pipes) {
            DBSDataContainer sourceObject;
            DatabaseMappingContainer containerMapping;
            if (pipe.getProducer() == null || (containerMapping = this.dataMappings.get(sourceObject = (DBSDataContainer)pipe.getProducer().getDatabaseObject())) != null && containerMapping.getMappingType() != DatabaseMappingType.unspecified && containerMapping.isCompleted()) continue;
            return false;
        }
        return true;
    }

    public boolean isTransferAutoGeneratedColumns() {
        return this.transferAutoGeneratedColumns;
    }

    public void setTransferAutoGeneratedColumns(boolean transferAutoGeneratedColumns) {
        this.transferAutoGeneratedColumns = transferAutoGeneratedColumns;
    }

    public boolean isTruncateBeforeLoad() {
        return this.truncateBeforeLoad;
    }

    public void setTruncateBeforeLoad(boolean truncateBeforeLoad) {
        this.truncateBeforeLoad = truncateBeforeLoad;
    }

    public boolean isOpenTableOnFinish() {
        return this.openTableOnFinish;
    }

    public void setOpenTableOnFinish(boolean openTableOnFinish) {
        this.openTableOnFinish = openTableOnFinish;
    }

    public boolean isOpenNewConnections() {
        return this.openNewConnections;
    }

    public void setOpenNewConnections(boolean openNewConnections) {
        this.openNewConnections = openNewConnections;
    }

    public boolean isUseTransactions() {
        return this.useTransactions;
    }

    public void setUseTransactions(boolean useTransactions) {
        this.useTransactions = useTransactions;
    }

    public int getCommitAfterRows() {
        return this.commitAfterRows;
    }

    public void setCommitAfterRows(int commitAfterRows) {
        this.commitAfterRows = commitAfterRows;
    }

    @Nullable
    public DBPDataSource getTargetDataSource(DatabaseMappingObject attrMapping) {
        DBSObjectContainer container = this.getContainer();
        if (container != null) {
            return container.getDataSource();
        }
        if (attrMapping.getTarget() != null) {
            return attrMapping.getTarget().getDataSource();
        }
        return null;
    }

    @Override
    public void loadSettings(IRunnableContext runnableContext, DataTransferSettings dataTransferSettings, IDialogSettings dialogSettings) {
        DBSDataManipulator targetObject;
        IDataTransferConsumer consumer;
        List<DataTransferPipe> dataPipes;
        this.dialogSettings = dialogSettings;
        this.containerNodePath = dialogSettings.get("container");
        if (dialogSettings.get("openNewConnections") != null) {
            this.openNewConnections = dialogSettings.getBoolean("openNewConnections");
        }
        if (dialogSettings.get("useTransactions") != null) {
            this.useTransactions = dialogSettings.getBoolean("useTransactions");
        }
        if (dialogSettings.get("commitAfterRows") != null) {
            this.commitAfterRows = dialogSettings.getInt("commitAfterRows");
        }
        if (dialogSettings.get("transferAutoGeneratedColumns") != null) {
            this.transferAutoGeneratedColumns = dialogSettings.getBoolean("transferAutoGeneratedColumns");
        }
        if (dialogSettings.get("truncateBeforeLoad") != null) {
            this.truncateBeforeLoad = dialogSettings.getBoolean("truncateBeforeLoad");
        }
        if (dialogSettings.get("openTableOnFinish") != null) {
            this.openTableOnFinish = dialogSettings.getBoolean("openTableOnFinish");
        }
        if (!(dataPipes = dataTransferSettings.getDataPipes()).isEmpty() && (consumer = dataPipes.get(0).getConsumer()) instanceof DatabaseTransferConsumer && (targetObject = ((DatabaseTransferConsumer)consumer).getTargetObject()) != null) {
            this.containerNode = DBWorkbench.getPlatform().getNavigatorModel().findNode(targetObject.getParentObject());
        }
        this.checkContainerConnection(runnableContext);
        IDialogSettings mappings = dialogSettings.getSection("mappings");
        if (mappings != null) {
            for (DatabaseMappingContainer dmc : this.dataMappings.values()) {
                IDialogSettings dmcSettings;
                DBSDataContainer sourceDatacontainer = dmc.getSource();
                if (sourceDatacontainer == null || (dmcSettings = mappings.getSection(DBUtils.getObjectFullId((DBSObject)sourceDatacontainer))) == null) continue;
                dmc.loadSettings(runnableContext, dmcSettings);
            }
        }
    }

    @Override
    public void saveSettings(IDialogSettings dialogSettings) {
        if (this.containerNode != null) {
            dialogSettings.put("container", this.containerNode.getNodeItemPath());
        }
        dialogSettings.put("openNewConnections", this.openNewConnections);
        dialogSettings.put("useTransactions", this.useTransactions);
        dialogSettings.put("commitAfterRows", this.commitAfterRows);
        dialogSettings.put("transferAutoGeneratedColumns", this.transferAutoGeneratedColumns);
        dialogSettings.put("truncateBeforeLoad", this.truncateBeforeLoad);
        dialogSettings.put("openTableOnFinish", this.openTableOnFinish);
        IDialogSettings mappings = DialogSettings.getOrCreateSection((IDialogSettings)dialogSettings, (String)"mappings");
        for (DatabaseMappingContainer dmc : this.dataMappings.values()) {
            DBSDataContainer sourceDatacontainer = dmc.getSource();
            if (sourceDatacontainer == null) continue;
            IDialogSettings dmcSettings = mappings.addNewSection(DBUtils.getObjectFullId((DBSObject)sourceDatacontainer));
            dmc.saveSettings(dmcSettings);
        }
    }

    @Override
    public String getSettingsSummary() {
        StringBuilder summary = new StringBuilder();
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_new_connection, this.openNewConnections);
        DTUtils.addSummary(summary, "Use transactions", this.useTransactions);
        if (this.useTransactions) {
            DTUtils.addSummary(summary, "Commit after", this.commitAfterRows);
        }
        DTUtils.addSummary(summary, "Transfer auto-generated columns", this.transferAutoGeneratedColumns);
        DTUtils.addSummary(summary, "Truncate before load", this.truncateBeforeLoad);
        return summary.toString();
    }

    private void checkContainerConnection(IRunnableContext runnableContext) {
        if (this.containerNode instanceof DBNDataSource && this.containerNode.getDataSource() == null) {
            try {
                runnableContext.run(true, true, monitor -> {
                    boolean bl = this.containerNode.initializeNode((DBRProgressMonitor)new DefaultProgressMonitor(monitor), null);
                });
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Init connection", "Error connecting to datasource", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void loadNode(IRunnableContext runnableContext, @Nullable DBSObjectContainer producerContainer) {
        if (!(this.containerNode != null || producerContainer == null && CommonUtils.isEmpty((String)this.containerNodePath) || producerContainer == null && CommonUtils.isEmpty((String)this.containerNodePath))) {
            try {
                runnableContext.run(true, true, monitor -> {
                    try {
                        Object node = producerContainer != null ? DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)producerContainer) : DBWorkbench.getPlatform().getNavigatorModel().getNodeByPath((DBRProgressMonitor)new DefaultProgressMonitor(monitor), this.containerNodePath);
                        if (node instanceof DBNDatabaseNode) {
                            this.containerNode = node;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                this.checkContainerConnection(runnableContext);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Error getting container node", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addDataMappings(IRunnableContext context, DBSDataContainer dataContainer, DatabaseMappingContainer mappingContainer) {
        IDialogSettings dmcSettings;
        IDialogSettings mappings;
        this.dataMappings.put(dataContainer, mappingContainer);
        if (this.dialogSettings != null && (mappings = this.dialogSettings.getSection("mappings")) != null && (dmcSettings = mappings.getSection(DBUtils.getObjectFullId((DBSObject)dataContainer))) != null) {
            mappingContainer.loadSettings(context, dmcSettings);
        }
    }
}

