/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Modifier;

@BugPattern(name="InjectOnConstructorOfAbstractClass", summary="Constructors on abstract classes are never directly @Injected, only the constructors of their subclasses can be @Inject'ed.", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class InjectOnConstructorOfAbstractClass
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final MultiMatcher<MethodTree, AnnotationTree> INJECT_FINDER = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"javax.inject.Inject"), Matchers.isType((String)"com.google.inject.Inject")}));
    private static final Matcher<MethodTree> TO_MATCH = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.enclosingClass((Matcher)Matchers.hasModifier((Modifier)Modifier.ABSTRACT))});

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        MultiMatcher.MultiMatchResult injectAnnotations;
        if (TO_MATCH.matches((Tree)methodTree, state) && (injectAnnotations = INJECT_FINDER.multiMatchResult((Tree)methodTree, state)).matches()) {
            AnnotationTree injectAnnotation = (AnnotationTree)injectAnnotations.matchingNodes().get(0);
            return this.describeMatch(injectAnnotation, (Fix)SuggestedFix.delete((Tree)injectAnnotation));
        }
        return Description.NO_MATCH;
    }
}

