/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;

@BugPattern(name="DefaultCharset", category=BugPattern.Category.JDK, summary="Implicit use of the platform default charset, which can result in differing behaviour between JVM executions or incorrect behavior if the encoding of the data source doesn't match expectations.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class DefaultCharset
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> FILE_WRITER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(FileWriter.class.getName()).withParameters(new String[]{"java.io.File"}), MethodMatchers.constructor().forClass(FileWriter.class.getName()).withParameters(new String[]{"java.io.File", "boolean"}), MethodMatchers.constructor().forClass(FileWriter.class.getName()).withParameters(new String[]{"java.lang.String"}), MethodMatchers.constructor().forClass(FileWriter.class.getName()).withParameters(new String[]{"java.lang.String", "boolean"})});
    private static final Matcher<Tree> BUFFERED_WRITER = Matchers.toType(ExpressionTree.class, (Matcher)MethodMatchers.constructor().forClass(BufferedWriter.class.getName()));
    private static final Matcher<ExpressionTree> FILE_READER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(FileReader.class.getName()).withParameters(new String[]{"java.io.File"}), MethodMatchers.constructor().forClass(FileReader.class.getName()).withParameters(new String[]{"java.lang.String"})});
    private static final Matcher<Tree> BUFFERED_READER = Matchers.toType(ExpressionTree.class, (Matcher)MethodMatchers.constructor().forClass(BufferedReader.class.getName()));
    private static final Matcher<ExpressionTree> CTOR = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(String.class.getName()).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.arrayOf((Supplier)Suppliers.BYTE_TYPE))), MethodMatchers.constructor().forClass(String.class.getName()).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.arrayOf((Supplier)Suppliers.BYTE_TYPE), (Object)Suppliers.INT_TYPE, (Object)Suppliers.INT_TYPE)), MethodMatchers.constructor().forClass(OutputStreamWriter.class.getName()).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.typeFromClass(OutputStream.class))), MethodMatchers.constructor().forClass(InputStreamReader.class.getName()).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.typeFromClass(InputStream.class)))});
    private static final Matcher<ExpressionTree> BYTESTRING_COPY_FROM = MethodMatchers.staticMethod().onClass("com.google.protobuf.ByteString").named("copyFrom");
    private static final Matcher<ExpressionTree> STRING_GET_BYTES = MethodMatchers.instanceMethod().onExactClass(String.class.getName()).withSignature("getBytes()");
    private static final Matcher<ExpressionTree> FILE_NEW_WRITER = MethodMatchers.staticMethod().onClass(Files.class.getName()).named("newWriter").withParameters(new String[]{"java.lang.String"});
    private static final Matcher<ExpressionTree> PRINT_WRITER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(PrintWriter.class.getName()).withParameters(new String[]{File.class.getName()}), MethodMatchers.constructor().forClass(PrintWriter.class.getName()).withParameters(new String[]{String.class.getName()})});
    private static final Matcher<ExpressionTree> PRINT_WRITER_OUTPUTSTREAM = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(PrintWriter.class.getName()).withParameters(new String[]{OutputStream.class.getName()}), MethodMatchers.constructor().forClass(PrintWriter.class.getName()).withParameters(new String[]{OutputStream.class.getName(), "boolean"})});
    private static final Matcher<ExpressionTree> SCANNER_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(Scanner.class.getName()).withParameters(new String[]{InputStream.class.getName()}), MethodMatchers.constructor().forClass(Scanner.class.getName()).withParameters(new String[]{File.class.getName()}), MethodMatchers.constructor().forClass(Scanner.class.getName()).withParameters(new String[]{Path.class.getName()}), MethodMatchers.constructor().forClass(Scanner.class.getName()).withParameters(new String[]{ReadableByteChannel.class.getName()})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        if (STRING_GET_BYTES.matches((Tree)tree, state)) {
            Description.Builder description = this.buildDescription(tree);
            Tree parent = state.getPath().getParentPath().getLeaf();
            if (parent instanceof ExpressionTree && BYTESTRING_COPY_FROM.matches((Tree)((ExpressionTree)parent), state)) {
                DefaultCharset.byteStringFixes(description, tree, (ExpressionTree)parent, state);
            } else {
                this.appendCharsets(description, tree, tree.getMethodSelect(), tree.getArguments(), state);
            }
            return description.build();
        }
        if (FILE_NEW_WRITER.matches((Tree)tree, state)) {
            Description.Builder description = this.buildDescription(tree);
            this.appendCharsets(description, tree, tree.getMethodSelect(), tree.getArguments(), state);
            return description.build();
        }
        return Description.NO_MATCH;
    }

    private static void byteStringFixes(Description.Builder description, MethodInvocationTree tree, ExpressionTree parent, VisitorState state) {
        description.addFix((Fix)DefaultCharset.byteStringFix(tree, parent, state, ".copyFromUtf8(", "").build());
        SuggestedFix.Builder builder = DefaultCharset.byteStringFix(tree, parent, state, ".copyFrom(", ", " + CharsetFix.DEFAULT_CHARSET_FIX.replacement());
        CharsetFix.DEFAULT_CHARSET_FIX.addImport(builder, state);
        description.addFix((Fix)builder.build());
    }

    private static SuggestedFix.Builder byteStringFix(MethodInvocationTree tree, ExpressionTree parent, VisitorState state, String prefix, String suffix) {
        return SuggestedFix.builder().replace(state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)parent)), ((JCTree)((Object)tree)).getStartPosition(), prefix).replace(state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), state.getEndPosition((Tree)tree), suffix);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        if (CTOR.matches((Tree)tree, state)) {
            Description.Builder description = this.buildDescription(tree);
            this.appendCharsets(description, tree, tree.getIdentifier(), tree.getArguments(), state);
            return description.build();
        }
        if (FILE_READER.matches((Tree)tree, state)) {
            return this.handleFileReader(tree, state);
        }
        if (FILE_WRITER.matches((Tree)tree, state)) {
            return this.handleFileWriter(tree, state);
        }
        if (PRINT_WRITER.matches((Tree)tree, state)) {
            return this.handlePrintWriter(tree, state);
        }
        if (PRINT_WRITER_OUTPUTSTREAM.matches((Tree)tree, state)) {
            return this.handlePrintWriterOutputStream(tree, state);
        }
        if (SCANNER_MATCHER.matches((Tree)tree, state)) {
            return this.handleScanner(tree, state);
        }
        return Description.NO_MATCH;
    }

    private Description handleScanner(NewClassTree tree, VisitorState state) {
        Description.Builder description = this.buildDescription(tree);
        for (CharsetFix charsetFix : CharsetFix.values()) {
            SuggestedFix.Builder fix = SuggestedFix.builder().postfixWith((Tree)Iterables.getOnlyElement(tree.getArguments()), String.format(", %s.name()", charsetFix.replacement()));
            charsetFix.addImport(fix, state);
            description.addFix((Fix)fix.build());
        }
        return description.build();
    }

    boolean shouldUseGuava(VisitorState state) {
        for (ImportTree importTree : state.getPath().getCompilationUnit().getImports()) {
            Symbol sym = ASTHelpers.getSymbol((Tree)importTree.getQualifiedIdentifier());
            if (sym == null || !sym.getQualifiedName().contentEquals("com.google.common.io.Files")) continue;
            return true;
        }
        return false;
    }

    private Description handleFileReader(NewClassTree tree, VisitorState state) {
        Tree arg = (Tree)Iterables.getOnlyElement(tree.getArguments());
        Tree parent = state.getPath().getParentPath().getLeaf();
        Tree toReplace = BUFFERED_READER.matches(parent, state) ? parent : tree;
        Description.Builder description = this.buildDescription(tree);
        this.fileReaderFix(description, state, arg, toReplace);
        return description.build();
    }

    private void fileReaderFix(Description.Builder description, VisitorState state, Tree arg, Tree toReplace) {
        for (CharsetFix charset : CharsetFix.values()) {
            if (this.shouldUseGuava(state)) {
                description.addFix(this.guavaFileReaderFix(state, arg, toReplace, charset));
                continue;
            }
            description.addFix(this.nioFileReaderFix(state, arg, toReplace, charset));
        }
    }

    private Fix nioFileReaderFix(VisitorState state, Tree arg, Tree toReplace, CharsetFix charset) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace(toReplace, String.format("Files.newBufferedReader(%s, %s)", this.toPath(state, arg, fix), charset.replacement()));
        fix.addImport("java.nio.file.Files");
        charset.addImport(fix, state);
        this.variableTypeFix(fix, state, FileReader.class, Reader.class);
        return fix.build();
    }

    private Fix guavaFileReaderFix(VisitorState state, Tree fileArg, Tree toReplace, CharsetFix charset) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace(toReplace, String.format("Files.newReader(%s, %s)", this.toFile(state, fileArg, fix), charset.replacement()));
        fix.addImport("com.google.common.io.Files");
        charset.addImport(fix, state);
        this.variableTypeFix(fix, state, FileReader.class, Reader.class);
        return fix.build();
    }

    private void variableTypeFix(final SuggestedFix.Builder fix, VisitorState state, Class<?> original, final Class<?> replacement) {
        Symbol sym;
        Tree parent = state.getPath().getParentPath().getLeaf();
        switch (parent.getKind()) {
            case VARIABLE: {
                sym = ASTHelpers.getSymbol((VariableTree)((VariableTree)parent));
                break;
            }
            case ASSIGNMENT: {
                sym = ASTHelpers.getSymbol((Tree)((AssignmentTree)parent).getVariable());
                break;
            }
            default: {
                return;
            }
        }
        if (!ASTHelpers.isSameType((Type)sym.type, (Type)state.getTypeFromString(original.getCanonicalName()), (VisitorState)state)) {
            return;
        }
        state.getPath().getCompilationUnit().accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree node, Void aVoid) {
                if (sym.equals(ASTHelpers.getSymbol((VariableTree)node))) {
                    fix.replace(node.getType(), replacement.getSimpleName()).addImport(replacement.getCanonicalName());
                }
                return null;
            }
        }, null);
    }

    private Description handleFileWriter(NewClassTree tree, VisitorState state) {
        Iterator<? extends ExpressionTree> it = tree.getArguments().iterator();
        Tree fileArg = it.next();
        Tree appendMode = it.hasNext() ? (Tree)it.next() : null;
        Tree parent = state.getPath().getParentPath().getLeaf();
        Tree toReplace = BUFFERED_WRITER.matches(parent, state) ? parent : tree;
        Description.Builder description = this.buildDescription(tree);
        boolean useGuava = this.shouldUseGuava(state);
        for (CharsetFix charset : CharsetFix.values()) {
            if (appendMode == null && useGuava) {
                description.addFix(this.guavaFileWriterFix(state, fileArg, toReplace, charset));
                continue;
            }
            description.addFix(this.nioFileWriterFix(state, appendMode, fileArg, toReplace, charset, useGuava));
        }
        return description.build();
    }

    private Fix guavaFileWriterFix(VisitorState state, Tree fileArg, Tree toReplace, CharsetFix charset) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace(toReplace, String.format("Files.newWriter(%s, %s)", this.toFile(state, fileArg, fix), charset.replacement()));
        fix.addImport("com.google.common.io.Files");
        charset.addImport(fix, state);
        this.variableTypeFix(fix, state, FileWriter.class, Writer.class);
        return fix.build();
    }

    private Fix nioFileWriterFix(VisitorState state, Tree appendTree, Tree fileArg, Tree toReplace, CharsetFix charset, boolean qualify) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        StringBuilder sb = new StringBuilder();
        if (qualify) {
            sb.append("java.nio.file.Files");
        } else {
            sb.append("Files");
            fix.addImport("java.nio.file.Files");
        }
        sb.append(".newBufferedWriter(");
        sb.append(this.toPath(state, fileArg, fix));
        sb.append(", ").append(charset.replacement());
        charset.addImport(fix, state);
        if (appendTree != null) {
            sb.append(this.toAppendMode(fix, appendTree, state));
        }
        sb.append(")");
        fix.replace(toReplace, sb.toString());
        this.variableTypeFix(fix, state, FileWriter.class, Writer.class);
        return fix.build();
    }

    private String toAppendMode(SuggestedFix.Builder fix, Tree appendArg, VisitorState state) {
        Boolean value = (Boolean)ASTHelpers.constValue((Tree)appendArg, Boolean.class);
        if (value != null) {
            if (value.booleanValue()) {
                fix.addStaticImport("java.nio.file.StandardOpenOption.APPEND");
                fix.addStaticImport("java.nio.file.StandardOpenOption.CREATE");
                return ", CREATE, APPEND";
            }
            return "";
        }
        fix.addImport("java.nio.file.StandardOpenOption");
        fix.addStaticImport("java.nio.file.StandardOpenOption.APPEND");
        fix.addStaticImport("java.nio.file.StandardOpenOption.CREATE");
        return String.format(", %s ? new StandardOpenOption[] {CREATE, APPEND} : new StandardOpenOption[] {CREATE}", state.getSourceForNode(appendArg));
    }

    private Object toFile(VisitorState state, Tree fileArg, SuggestedFix.Builder fix) {
        Type type = ASTHelpers.getType((Tree)fileArg);
        if (ASTHelpers.isSubtype((Type)type, (Type)state.getSymtab().stringType, (VisitorState)state)) {
            fix.addImport("java.io.File");
            return String.format("new File(%s)", state.getSourceForNode(fileArg));
        }
        if (ASTHelpers.isSubtype((Type)type, (Type)state.getTypeFromString("java.io.File"), (VisitorState)state)) {
            return state.getSourceForNode(fileArg);
        }
        throw new AssertionError((Object)("unexpected type: " + type));
    }

    private String toPath(VisitorState state, Tree fileArg, SuggestedFix.Builder fix) {
        Type type = ASTHelpers.getType((Tree)fileArg);
        if (ASTHelpers.isSubtype((Type)type, (Type)state.getSymtab().stringType, (VisitorState)state)) {
            fix.addImport("java.nio.file.Paths");
            return String.format("Paths.get(%s)", state.getSourceForNode(fileArg));
        }
        if (ASTHelpers.isSubtype((Type)type, (Type)state.getTypeFromString("java.io.File"), (VisitorState)state)) {
            return String.format("%s.toPath()", state.getSourceForNode(fileArg));
        }
        throw new AssertionError((Object)("unexpected type: " + type));
    }

    private void appendCharsets(Description.Builder description, Tree tree, Tree select, List<? extends ExpressionTree> arguments, VisitorState state) {
        description.addFix(this.appendCharset(tree, select, arguments, state, CharsetFix.UTF_8_FIX));
        description.addFix(this.appendCharset(tree, select, arguments, state, CharsetFix.DEFAULT_CHARSET_FIX));
    }

    private Fix appendCharset(Tree tree, Tree select, List<? extends ExpressionTree> arguments, VisitorState state, CharsetFix charset) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (arguments.isEmpty()) {
            fix.replace(state.getEndPosition(select), state.getEndPosition(tree), String.format("(%s)", charset.replacement()));
        } else {
            fix.postfixWith((Tree)Iterables.getLast(arguments), ", " + charset.replacement());
        }
        charset.addImport(fix, state);
        return fix.build();
    }

    private Description handlePrintWriter(NewClassTree tree, VisitorState state) {
        Description.Builder description = this.buildDescription(tree);
        for (CharsetFix charsetFix : CharsetFix.values()) {
            SuggestedFix.Builder fix = SuggestedFix.builder().postfixWith((Tree)Iterables.getOnlyElement(tree.getArguments()), String.format(", %s.name()", charsetFix.replacement()));
            charsetFix.addImport(fix, state);
            description.addFix((Fix)fix.build());
        }
        return description.build();
    }

    private Description handlePrintWriterOutputStream(NewClassTree tree, VisitorState state) {
        Tree outputStream = tree.getArguments().get(0);
        Description.Builder description = this.buildDescription(tree);
        for (CharsetFix charsetFix : CharsetFix.values()) {
            SuggestedFix.Builder fix = SuggestedFix.builder().prefixWith(outputStream, "new BufferedWriter(new OutputStreamWriter(").postfixWith(outputStream, String.format(", %s))", charsetFix.replacement()));
            charsetFix.addImport(fix, state);
            fix.addImport("java.io.BufferedWriter");
            fix.addImport("java.io.OutputStreamWriter");
            description.addFix((Fix)fix.build());
        }
        return description.build();
    }

    static enum CharsetFix {
        UTF_8_FIX("UTF_8"){

            @Override
            void addImport(SuggestedFix.Builder fix, VisitorState state) {
                fix.addStaticImport("java.nio.charset.StandardCharsets.UTF_8");
            }
        }
        ,
        DEFAULT_CHARSET_FIX("Charset.defaultCharset()"){

            @Override
            void addImport(SuggestedFix.Builder fix, VisitorState state) {
                fix.addImport("java.nio.charset.Charset");
            }
        };

        final String replacement;

        private CharsetFix(String replacement) {
            this.replacement = replacement;
        }

        String replacement() {
            return this.replacement;
        }

        abstract void addImport(SuggestedFix.Builder var1, VisitorState var2);
    }
}

