Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var CollapsibleSectionPanel = (function () {
  function CollapsibleSectionPanel() {
    _classCallCheck(this, CollapsibleSectionPanel);
  }

  _createClass(CollapsibleSectionPanel, [{
    key: 'notHiddenCardsLength',
    value: function notHiddenCardsLength(sectionElement) {
      return sectionElement.querySelectorAll('.package-card:not(.hidden)').length;
    }
  }, {
    key: 'updateSectionCount',
    value: function updateSectionCount(headerElement, countElement, packageCount, totalCount) {
      if (totalCount != null) {
        countElement.textContent = packageCount + '/' + totalCount;
      } else {
        countElement.textContent = packageCount;
      }

      if (packageCount > 0) {
        headerElement.classList.add('has-items');
      }
    }
  }, {
    key: 'updateSectionCounts',
    value: function updateSectionCounts() {
      this.resetSectionHasItems();

      var filterText = this.refs.filterEditor.getText();
      if (filterText === '') {
        this.updateUnfilteredSectionCounts();
      } else {
        this.updateFilteredSectionCounts();
      }
    }
  }, {
    key: 'handleEvents',
    value: function handleEvents() {
      var _this = this;

      var handler = function handler(e) {
        var target = e.target.closest('.sub-section .has-items');
        if (target) {
          target.parentNode.classList.toggle('collapsed');
        }
      };
      this.element.addEventListener('click', handler);
      return new _atom.Disposable(function () {
        return _this.element.removeEventListener('click', handler);
      });
    }
  }, {
    key: 'resetCollapsibleSections',
    value: function resetCollapsibleSections(headerSections) {
      for (var headerSection of headerSections) {
        this.resetCollapsibleSection(headerSection);
      }
    }
  }, {
    key: 'resetCollapsibleSection',
    value: function resetCollapsibleSection(headerSection) {
      headerSection.classList.remove('has-items');
    }
  }]);

  return CollapsibleSectionPanel;
})();

exports['default'] = CollapsibleSectionPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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