"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _propTypes2 = require("../prop-types");

var _operationStateObserver = _interopRequireWildcard(require("../models/operation-state-observer"));

var _githubTabController = _interopRequireDefault(require("../controllers/github-tab-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _remoteSet = _interopRequireDefault(require("../models/remote-set"));

var _branchSet = _interopRequireDefault(require("../models/branch-set"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {});

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri["default"])({
        workingDirectory: repository.getWorkingDirectoryPath(),
        allRemotes: repository.getRemotes(),
        branches: repository.getBranches(),
        selectedRemoteName: repository.getConfig('atomGithub.currentRemote'),
        aheadCount: async query => {
          const branches = await query.branches;
          const currentBranch = branches.getHeadBranch();
          return repository.getAheadCount(currentBranch.getName());
        },
        pushInProgress: repository.getOperationStates().isPushInProgress()
      });
    });

    _defineProperty(this, "renderRepositoryData", data => {
      if (!data || this.props.repository.isLoading()) {
        return _react["default"].createElement(_githubTabController["default"], _extends({}, this.props, {
          remoteOperationObserver: this.state.remoteOperationObserver,
          allRemotes: new _remoteSet["default"](),
          branches: new _branchSet["default"](),
          aheadCount: 0,
          pushInProgress: false,
          isLoading: true
        }));
      }

      if (!this.props.repository.isPresent()) {
        // TODO include a better message here.
        return null;
      }

      return _react["default"].createElement(_githubTabController["default"], _extends({}, data, this.props, {
        remoteOperationObserver: this.state.remoteOperationObserver,
        isLoading: false
      }));
    });
  }

  static getDerivedStateFromProps(props, state) {
    if (props.repository !== state.lastRepository) {
      return {
        lastRepository: props.repository,
        remoteOperationObserver: new _operationStateObserver["default"](props.repository, _operationStateObserver.PUSH, _operationStateObserver.PULL, _operationStateObserver.FETCH)
      };
    }

    return null;
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.repository,
      fetchData: this.fetchRepositoryData
    }, this.renderRepositoryData);
  }

}

exports["default"] = GitHubTabContainer;

_defineProperty(GitHubTabContainer, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].object,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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