"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const VERBATIM_OPTION_PROPS = ['title', 'html', 'placement', 'trigger', 'keyBindingCommand', 'keyBindingTarget'];
const OPTION_PROPS = [...VERBATIM_OPTION_PROPS, 'tooltips', 'className', 'showDelay', 'hideDelay'];

class Tooltip extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    this.refSub = new _eventKit.Disposable();
    this.tipSub = new _eventKit.Disposable();
    this.domNode = null;

    if (this.props.children !== undefined) {
      this.domNode = document.createElement('div');
      this.domNode.className = 'react-atom-tooltip';
    }

    this.lastTooltipProps = {};
  }

  componentDidMount() {
    this.setupTooltip();
  }

  render() {
    if (this.props.children !== undefined) {
      return _reactDom["default"].createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  componentDidUpdate() {
    if (this.shouldRecreateTooltip()) {
      this.refSub.dispose();
      this.tipSub.dispose();
      this.setupTooltip();
    }
  }

  componentWillUnmount() {
    this.refSub.dispose();
    this.tipSub.dispose();
  }

  getTooltipProps() {
    const p = {};

    for (const key of OPTION_PROPS) {
      p[key] = this.props[key];
    }

    return p;
  }

  shouldRecreateTooltip() {
    return OPTION_PROPS.some(key => this.lastTooltipProps[key] !== this.props[key]);
  }

  setupTooltip() {
    this.lastTooltipProps = this.getTooltipProps();
    const options = {};
    VERBATIM_OPTION_PROPS.forEach(key => {
      if (this.props[key] !== undefined) {
        options[key] = this.props[key];
      }
    });

    if (this.props.className !== undefined) {
      options["class"] = this.props.className;
    }

    if (this.props.showDelay !== undefined || this.props.hideDelay !== undefined) {
      const delayDefaults = (this.props.trigger === 'hover' || this.props.trigger === undefined) && {
        show: 1000,
        hide: 100
      } || {
        show: 0,
        hide: 0
      };
      options.delay = {
        show: this.props.showDelay !== undefined ? this.props.showDelay : delayDefaults.show,
        hide: this.props.hideDelay !== undefined ? this.props.hideDelay : delayDefaults.hide
      };
    }

    if (this.props.children !== undefined) {
      options.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    this.refSub = this.props.target.observe(t => {
      this.tipSub.dispose();
      this.tipSub = this.props.manager.add(t, options);
      const h = this.props.tooltipHolder;

      if (h) {
        h.setter(this.tipSub);
      }
    });
  }

}

exports["default"] = Tooltip;

_defineProperty(Tooltip, "propTypes", {
  manager: _propTypes["default"].object.isRequired,
  target: _propTypes2.RefHolderPropType.isRequired,
  title: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].func]),
  html: _propTypes["default"].bool,
  className: _propTypes["default"].string,
  placement: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].func]),
  trigger: _propTypes["default"].oneOf(['hover', 'click', 'focus', 'manual']),
  showDelay: _propTypes["default"].number,
  hideDelay: _propTypes["default"].number,
  keyBindingCommand: _propTypes["default"].string,
  keyBindingTarget: _propTypes["default"].element,
  children: _propTypes["default"].element,
  itemHolder: _propTypes2.RefHolderPropType,
  tooltipHolder: _propTypes2.RefHolderPropType
});

_defineProperty(Tooltip, "defaultProps", {
  getItemComponent: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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