"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * `Panel` renders a React component into an Atom panel. Specify the location via the `location` prop, and any
 * additional options to the `addXPanel` method in the `options` prop.
 *
 * You can get the underlying Atom panel via `getPanel()`, but you should consider controlling the panel via React and
 * the Panel component instead.
 */
class Panel extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.subscriptions = new _eventKit.CompositeDisposable();
    this.panel = null;
    this.didCloseItem = false;
    this.domNode = document.createElement('div');
    this.domNode.className = 'react-atom-panel';
  }

  componentDidMount() {
    this.setupPanel();
  }

  shouldComponentUpdate(newProps) {
    return this.props.visible !== newProps.visible;
  }

  componentDidUpdate() {
    if (this.didCloseItem) {
      // eslint-disable-next-line no-console
      console.error('Unexpected update in `Panel`: the contained panel has been destroyed');
    }

    if (this.panel) {
      this.panel[this.props.visible ? 'show' : 'hide']();
    }
  }

  render() {
    return _reactDom["default"].createPortal(this.props.children, this.domNode);
  }

  setupPanel() {
    if (this.panel) {
      return;
    } // "left" => "Left"


    const location = this.props.location.substr(0, 1).toUpperCase() + this.props.location.substr(1);
    const methodName = `add${location}Panel`;
    const item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);

    const options = _objectSpread({}, this.props.options, {
      visible: this.props.visible,
      item
    });

    this.panel = this.props.workspace[methodName](options);
    this.subscriptions.add(this.panel.onDidDestroy(() => {
      this.didCloseItem = true;
      this.props.onDidClosePanel(this.panel);
    }));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();

    if (this.panel) {
      this.panel.destroy();
    }
  }

  getPanel() {
    return this.panel;
  }

}

exports["default"] = Panel;

_defineProperty(Panel, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  location: _propTypes["default"].oneOf(['top', 'bottom', 'left', 'right', 'header', 'footer', 'modal']).isRequired,
  children: _propTypes["default"].element.isRequired,
  options: _propTypes["default"].object,
  onDidClosePanel: _propTypes["default"].func,
  visible: _propTypes["default"].bool,
  itemHolder: _propTypes2.RefHolderPropType
});

_defineProperty(Panel, "defaultProps", {
  options: {},
  onDidClosePanel: panel => {},
  visible: true
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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