"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = require("./atom-text-editor");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const gutterProps = {
  name: _propTypes["default"].string.isRequired,
  priority: _propTypes["default"].number.isRequired,
  visible: _propTypes["default"].bool,
  type: _propTypes["default"].oneOf(['line-number', 'decorated']),
  labelFn: _propTypes["default"].func,
  onMouseDown: _propTypes["default"].func,
  onMouseMove: _propTypes["default"].func
};

class BareGutter extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'observeEditor', 'forceUpdate');
    this.state = {
      gutter: null
    };
    this.sub = new _eventKit.Disposable();
  }

  componentDidMount() {
    this.sub = this.props.editorHolder.observe(this.observeEditor);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.sub.dispose();
      this.sub = this.props.editorHolder.observe(this.observeEditor);
    }
  }

  componentWillUnmount() {
    if (this.state.gutter !== null) {
      try {
        this.state.gutter.destroy();
      } catch (e) {// Gutter already destroyed. Disregard.
      }
    }

    this.sub.dispose();
  }

  render() {
    return null;
  }

  observeEditor(editor) {
    this.setState((prevState, props) => {
      if (prevState.gutter !== null) {
        prevState.gutter.destroy();
      }

      const options = (0, _helpers.extractProps)(props, gutterProps);
      options["class"] = props.className;
      return {
        gutter: editor.addGutter(options)
      };
    });
  }

}

_defineProperty(BareGutter, "propTypes", _objectSpread({
  editorHolder: _propTypes2.RefHolderPropType.isRequired,
  className: _propTypes["default"].string
}, gutterProps));

_defineProperty(BareGutter, "defaultProps", {
  visible: true,
  type: 'decorated',
  labelFn: () => {}
});

class Gutter extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.state = {
      editorHolder: _refHolder["default"].on(this.props.editor)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    return editorChanged ? _refHolder["default"].on(props.editor) : null;
  }

  render() {
    if (!this.state.editorHolder.isEmpty()) {
      return _react["default"].createElement(BareGutter, _extends({}, this.props, {
        editorHolder: this.state.editorHolder
      }));
    }

    return _react["default"].createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react["default"].createElement(BareGutter, _extends({}, this.props, {
      editorHolder: editorHolder
    })));
  }

}

exports["default"] = Gutter;

_defineProperty(Gutter, "propTypes", {
  editor: _propTypes["default"].object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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