/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.turbine.bytecode.Attribute;
import com.google.turbine.bytecode.AttributeWriter;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ConstantPool;
import com.google.turbine.bytecode.LowerAttributes;
import com.google.turbine.model.Const;
import java.util.List;

public class ClassWriter {
    private static final int MAGIC = -889275714;
    private static final int MINOR_VERSION = 0;
    private static final int MAJOR_VERSION = 52;
    private static final int MODULE_MAJOR_VERSION = 53;

    public static byte[] writeClass(ClassFile classfile) {
        ConstantPool pool = new ConstantPool();
        ByteArrayDataOutput output = ByteStreams.newDataOutput();
        output.writeShort(classfile.access());
        output.writeShort(pool.classInfo(classfile.name()));
        output.writeShort(classfile.superName() != null ? pool.classInfo(classfile.superName()) : 0);
        output.writeShort(classfile.interfaces().size());
        for (String i : classfile.interfaces()) {
            output.writeShort(pool.classInfo(i));
        }
        output.writeShort(classfile.fields().size());
        for (ClassFile.FieldInfo f : classfile.fields()) {
            ClassWriter.writeField(pool, output, f);
        }
        output.writeShort(classfile.methods().size());
        for (ClassFile.MethodInfo m : classfile.methods()) {
            ClassWriter.writeMethod(pool, output, m);
        }
        ClassWriter.writeAttributes(pool, output, LowerAttributes.classAttributes(classfile));
        return ClassWriter.finishClass(pool, output, classfile);
    }

    private static void writeMethod(ConstantPool pool, ByteArrayDataOutput output, ClassFile.MethodInfo method) {
        output.writeShort(method.access());
        output.writeShort(pool.utf8(method.name()));
        output.writeShort(pool.utf8(method.descriptor()));
        ClassWriter.writeAttributes(pool, output, LowerAttributes.methodAttributes(method));
    }

    private static void writeField(ConstantPool pool, ByteArrayDataOutput output, ClassFile.FieldInfo field) {
        output.writeShort(field.access());
        output.writeShort(pool.utf8(field.name()));
        output.writeShort(pool.utf8(field.descriptor()));
        ClassWriter.writeAttributes(pool, output, LowerAttributes.fieldAttributes(field));
    }

    private static void writeAttributes(ConstantPool pool, ByteArrayDataOutput body, List<Attribute> attributes) {
        body.writeShort(attributes.size());
        for (Attribute attribute : attributes) {
            new AttributeWriter(pool, body).write(attribute);
        }
    }

    static void writeConstantPool(ConstantPool constantPool, ByteArrayDataOutput output) {
        output.writeShort(constantPool.nextEntry);
        for (ConstantPool.Entry e : constantPool.constants()) {
            output.writeByte((int)e.kind().tag());
            Const.Value value = e.value();
            switch (e.kind()) {
                case CLASS_INFO: 
                case STRING: 
                case MODULE: 
                case PACKAGE: {
                    output.writeShort(((Const.IntValue)value).value());
                    break;
                }
                case INTEGER: {
                    output.writeInt(((Const.IntValue)value).value());
                    break;
                }
                case DOUBLE: {
                    output.writeDouble(((Const.DoubleValue)value).value());
                    break;
                }
                case FLOAT: {
                    output.writeFloat(((Const.FloatValue)value).value());
                    break;
                }
                case LONG: {
                    output.writeLong(((Const.LongValue)value).value());
                    break;
                }
                case UTF8: {
                    output.writeUTF(((Const.StringValue)value).value());
                }
            }
        }
    }

    private static byte[] finishClass(ConstantPool pool, ByteArrayDataOutput body, ClassFile classfile) {
        ByteArrayDataOutput result = ByteStreams.newDataOutput();
        result.writeInt(-889275714);
        result.writeShort(0);
        result.writeShort(classfile.module() != null ? 53 : 52);
        ClassWriter.writeConstantPool(pool, result);
        result.write(body.toByteArray());
        return result.toByteArray();
    }
}

