/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;
import org.netbeans.core.windows.options.WinSysPrefs;
import org.netbeans.core.windows.view.dnd.DragWindow;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;

public class DragAndDropFeedbackVisualizer {
    private static final Preferences prefs = WinSysPrefs.HANDLER;
    private DragWindow dragWindow = null;
    private Tabbed source;
    private Point originalLocationOnScreen;
    private Point dragOffset;
    private int tabIndex;
    private static final int SLIDE_INTERVAL = 33;

    public DragAndDropFeedbackVisualizer(Tabbed tabbed, int n) {
        this.source = tabbed;
        this.tabIndex = n;
    }

    private DragWindow createDragWindow(int n) {
        Rectangle rectangle = this.source.getTabBounds(n);
        Dimension dimension = this.source.getTopComponentAt(n).getSize();
        --dimension.width;
        --dimension.height;
        dimension.width = Math.max(dimension.width, 1);
        dimension.height = Math.max(dimension.height, 1);
        Dimension dimension2 = new Dimension(dimension);
        if (prefs.getBoolean("dnd.smallwindows", true)) {
            int n2 = prefs.getInt("dnd.smallwindows.width", 250);
            int n3 = prefs.getInt("dnd.smallwindows.height", 250);
            dimension2.width = Math.min(n2, dimension2.width);
            dimension2.height = Math.min(n3, dimension2.height);
            rectangle.width = Math.min(n3, rectangle.width);
        }
        if (rectangle.width <= 0 || rectangle.height <= 0 || dimension2.width <= 0 || dimension2.height <= 0) {
            return null;
        }
        DragWindow dragWindow = new DragWindow(this.source, rectangle, new Dimension(dimension2), (Component)this.source.getTopComponentAt(n));
        dimension2.width += 2;
        dimension2.height += 2;
        Dimension dimension3 = new Dimension(dimension2);
        dimension3.height += rectangle.height;
        dragWindow.setSize(dimension3);
        NativeWindowSystem nativeWindowSystem = NativeWindowSystem.getDefault();
        if (nativeWindowSystem.isUndecoratedWindowAlphaSupported() && prefs.getBoolean("transparency.dragimage", true)) {
            Area area;
            nativeWindowSystem.setWindowAlpha(dragWindow, prefs.getFloat("transparency.dragimage.alpha", 0.7f));
            if (prefs.getBoolean("dnd.smallwindows", true)) {
                area = new Area(new Rectangle(0, 0, rectangle.width, rectangle.height));
                area.add(new Area(new Rectangle(0, rectangle.height, dimension2.width, dimension2.height)));
            } else {
                area = new Area(rectangle);
                area.add(new Area(new Rectangle(0, rectangle.height, dimension2.width, dimension2.height)));
            }
            nativeWindowSystem.setWindowMask((Window)dragWindow, area);
        }
        return dragWindow;
    }

    public void start(DragGestureEvent dragGestureEvent) {
        DragWindow dragWindow;
        this.originalLocationOnScreen = this.source.getComponent().getLocationOnScreen();
        Rectangle rectangle = this.source.getTabBounds(this.tabIndex);
        if (prefs.getBoolean("dnd.smallwindows", true)) {
            this.originalLocationOnScreen.x += rectangle.x;
        }
        if (null != (dragWindow = this.createDragWindow(this.tabIndex))) {
            this.dragOffset = new Point(0, 0);
            Point point = new Point(dragGestureEvent.getDragOrigin());
            SwingUtilities.convertPointToScreen(point, dragGestureEvent.getComponent());
            dragWindow.setLocation(point.x - this.dragOffset.x, point.y - this.dragOffset.y);
            try {
                dragWindow.setVisible(true);
                this.dragWindow = dragWindow;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Logger.getLogger(DragAndDropFeedbackVisualizer.class.getName()).log(Level.INFO, null, unsatisfiedLinkError);
            }
            catch (Throwable throwable) {
                Logger.getLogger(DragAndDropFeedbackVisualizer.class.getName()).log(Level.FINE, null, throwable);
            }
        }
    }

    public void update(DragSourceDragEvent dragSourceDragEvent) {
        if (null != this.dragWindow) {
            this.dragWindow.setLocation(dragSourceDragEvent.getLocation().x - this.dragOffset.x, dragSourceDragEvent.getLocation().y - this.dragOffset.y);
        }
    }

    public void dispose(boolean bl) {
        if (null == this.dragWindow) {
            return;
        }
        if (!bl) {
            this.returnDragWindowToOrigin();
        } else {
            this.dragWindow.dispose();
        }
        this.dragWindow = null;
    }

    public void setDropFeedback(boolean bl, boolean bl2) {
        if (null != this.dragWindow) {
            this.dragWindow.setDropFeedback(bl);
        }
    }

    private void returnDragWindowToOrigin() {
        final Timer timer = new Timer(33, null);
        final DragWindow dragWindow = this.dragWindow;
        this.dragWindow.abort();
        timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Point point = dragWindow.getLocationOnScreen();
                Point point2 = new Point(DragAndDropFeedbackVisualizer.this.originalLocationOnScreen);
                int n = (point2.x - point.x) / 2;
                int n2 = (point2.y - point.y) / 2;
                if (n != 0 || n2 != 0) {
                    point.translate(n, n2);
                    dragWindow.setLocation(point);
                } else {
                    timer.stop();
                    dragWindow.dispose();
                }
            }
        });
        timer.setInitialDelay(0);
        timer.start();
    }
}

