/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AMDGPU target                          *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 46;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr&) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static AMDGPUInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_isGFX6Bit = 12,
  Feature_isGFX6GFX7Bit = 19,
  Feature_isGFX6GFX7GFX10Bit = 2,
  Feature_isGFX7OnlyBit = 45,
  Feature_isGFX7GFX8GFX9Bit = 7,
  Feature_isGFX6GFX7GFX8GFX9Bit = 36,
  Feature_isGFX7PlusBit = 13,
  Feature_isGFX8PlusBit = 1,
  Feature_isGFX8OnlyBit = 4,
  Feature_isGFX9PlusBit = 5,
  Feature_isGFX8GFX9Bit = 34,
  Feature_isGFX10PlusBit = 9,
  Feature_HasFlatAddressSpaceBit = 10,
  Feature_HasFlatGlobalInstsBit = 11,
  Feature_HasUnpackedD16VMemBit = 17,
  Feature_HasPackedD16VMemBit = 18,
  Feature_D16PreservesUnusedBitsBit = 20,
  Feature_LDSRequiresM0InitBit = 32,
  Feature_NotLDSRequiresM0InitBit = 33,
  Feature_HasAddNoCarryInstsBit = 35,
  Feature_Has16BitInstsBit = 3,
  Feature_HasVOP3PInstsBit = 24,
  Feature_HasMadMixInstsBit = 41,
  Feature_HasScalarStoresBit = 8,
  Feature_has16BankLDSBit = 15,
  Feature_has32BankLDSBit = 14,
  Feature_HasFmaMixInstsBit = 42,
  Feature_HasDLInstsBit = 31,
  Feature_HasDot1InstsBit = 44,
  Feature_HasDot2InstsBit = 43,
  Feature_HasDot3InstsBit = 40,
  Feature_HasDot4InstsBit = 39,
  Feature_HasDot5InstsBit = 37,
  Feature_HasDot6InstsBit = 38,
  Feature_HasMAIInstsBit = 6,
  Feature_EnableLateCFGStructurizeBit = 16,
  Feature_TruePredicateBit = 0,
  Feature_FP16DenormalsBit = 26,
  Feature_FP32DenormalsBit = 28,
  Feature_FP64DenormalsBit = 30,
  Feature_NoFP16DenormalsBit = 25,
  Feature_NoFP32DenormalsBit = 27,
  Feature_NoFP64DenormalsBit = 29,
  Feature_UnsafeFPMathBit = 23,
  Feature_isWave32Bit = 22,
  Feature_isWave64Bit = 21,
};

PredicateBitset AMDGPUInstructionSelector::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS)
    Features[Feature_isGFX6Bit] = 1;
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features[Feature_isGFX6GFX7Bit] = 1;
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features[Feature_isGFX6GFX7GFX10Bit] = 1;
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features[Feature_isGFX7OnlyBit] = 1;
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features[Feature_isGFX7GFX8GFX9Bit] = 1;
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features[Feature_isGFX6GFX7GFX8GFX9Bit] = 1;
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::SEA_ISLANDS)
    Features[Feature_isGFX7PlusBit] = 1;
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features[Feature_isGFX8PlusBit] = 1;
  if (Subtarget->getGeneration() ==AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features[Feature_isGFX8OnlyBit] = 1;
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX9)
    Features[Feature_isGFX9PlusBit] = 1;
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features[Feature_isGFX8GFX9Bit] = 1;
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features[Feature_isGFX10PlusBit] = 1;
  if (Subtarget->hasFlatAddressSpace())
    Features[Feature_HasFlatAddressSpaceBit] = 1;
  if (Subtarget->hasFlatGlobalInsts())
    Features[Feature_HasFlatGlobalInstsBit] = 1;
  if (Subtarget->hasUnpackedD16VMem())
    Features[Feature_HasUnpackedD16VMemBit] = 1;
  if (!Subtarget->hasUnpackedD16VMem())
    Features[Feature_HasPackedD16VMemBit] = 1;
  if (Subtarget->d16PreservesUnusedBits())
    Features[Feature_D16PreservesUnusedBitsBit] = 1;
  if (Subtarget->ldsRequiresM0Init())
    Features[Feature_LDSRequiresM0InitBit] = 1;
  if (!Subtarget->ldsRequiresM0Init())
    Features[Feature_NotLDSRequiresM0InitBit] = 1;
  if (Subtarget->hasAddNoCarry())
    Features[Feature_HasAddNoCarryInstsBit] = 1;
  if (Subtarget->has16BitInsts())
    Features[Feature_Has16BitInstsBit] = 1;
  if (Subtarget->hasVOP3PInsts())
    Features[Feature_HasVOP3PInstsBit] = 1;
  if (Subtarget->hasMadMixInsts())
    Features[Feature_HasMadMixInstsBit] = 1;
  if (Subtarget->hasScalarStores())
    Features[Feature_HasScalarStoresBit] = 1;
  if (Subtarget->getLDSBankCount() == 16)
    Features[Feature_has16BankLDSBit] = 1;
  if (Subtarget->getLDSBankCount() == 32)
    Features[Feature_has32BankLDSBit] = 1;
  if (Subtarget->hasFmaMixInsts())
    Features[Feature_HasFmaMixInstsBit] = 1;
  if (Subtarget->hasDLInsts())
    Features[Feature_HasDLInstsBit] = 1;
  if (Subtarget->hasDot1Insts())
    Features[Feature_HasDot1InstsBit] = 1;
  if (Subtarget->hasDot2Insts())
    Features[Feature_HasDot2InstsBit] = 1;
  if (Subtarget->hasDot3Insts())
    Features[Feature_HasDot3InstsBit] = 1;
  if (Subtarget->hasDot4Insts())
    Features[Feature_HasDot4InstsBit] = 1;
  if (Subtarget->hasDot5Insts())
    Features[Feature_HasDot5InstsBit] = 1;
  if (Subtarget->hasDot6Insts())
    Features[Feature_HasDot6InstsBit] = 1;
  if (Subtarget->hasMAIInsts())
    Features[Feature_HasMAIInstsBit] = 1;
  if (EnableLateStructurizeCFG)
    Features[Feature_EnableLateCFGStructurizeBit] = 1;
  if (true)
    Features[Feature_TruePredicateBit] = 1;
  if (Subtarget->hasFP16Denormals())
    Features[Feature_FP16DenormalsBit] = 1;
  if (Subtarget->hasFP32Denormals())
    Features[Feature_FP32DenormalsBit] = 1;
  if (Subtarget->hasFP64Denormals())
    Features[Feature_FP64DenormalsBit] = 1;
  if (!Subtarget->hasFP16Denormals())
    Features[Feature_NoFP16DenormalsBit] = 1;
  if (!Subtarget->hasFP32Denormals())
    Features[Feature_NoFP32DenormalsBit] = 1;
  if (!Subtarget->hasFP64Denormals())
    Features[Feature_NoFP64DenormalsBit] = 1;
  if (TM.Options.UnsafeFPMath)
    Features[Feature_UnsafeFPMathBit] = 1;
  if (Subtarget->getWavefrontSize() == 32)
    Features[Feature_isWave32Bit] = 1;
  if (Subtarget->getWavefrontSize() == 64)
    Features[Feature_isWave64Bit] = 1;
  return Features;
}

PredicateBitset AMDGPUInstructionSelector::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v3s32,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v5s32,
  GILLT_v8s32,
  GILLT_v16s32,
  GILLT_v32s32,
};
const static size_t NumTypeObjects = 14;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(2, 16),
  LLT::vector(2, 32),
  LLT::vector(2, 64),
  LLT::vector(3, 32),
  LLT::vector(4, 16),
  LLT::vector(4, 32),
  LLT::vector(5, 32),
  LLT::vector(8, 32),
  LLT::vector(16, 32),
  LLT::vector(32, 32),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasMAIInsts,
  GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
  GIFBS_TruePredicate_TruePredicate_TruePredicate,
  GIFBS_TruePredicate_TruePredicate_isGFX10Plus,
  GIFBS_TruePredicate_TruePredicate_isGFX6,
  GIFBS_TruePredicate_TruePredicate_isGFX7GFX8GFX9,
  GIFBS_TruePredicate_TruePredicate_isGFX7Plus,
  GIFBS_TruePredicate_TruePredicate_isGFX8Plus,
  GIFBS_HasScalarStores_TruePredicate_TruePredicate_isGFX8Plus,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasMAIInstsBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_TruePredicateBit, Feature_TruePredicateBit, Feature_TruePredicateBit, },
  {Feature_TruePredicateBit, Feature_TruePredicateBit, Feature_isGFX10PlusBit, },
  {Feature_TruePredicateBit, Feature_TruePredicateBit, Feature_isGFX6Bit, },
  {Feature_TruePredicateBit, Feature_TruePredicateBit, Feature_isGFX7GFX8GFX9Bit, },
  {Feature_TruePredicateBit, Feature_TruePredicateBit, Feature_isGFX7PlusBit, },
  {Feature_TruePredicateBit, Feature_TruePredicateBit, Feature_isGFX8PlusBit, },
  {Feature_HasScalarStoresBit, Feature_TruePredicateBit, Feature_TruePredicateBit, Feature_isGFX8PlusBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_NegSubInlineConst16 = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_NegSubInlineConst32,
  GIPFP_I64_Predicate_SIMM16bit,
  GIPFP_I64_Predicate_UIMM16bit,
};
bool AMDGPUInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_NegSubInlineConst16: {
    
  return Imm < -16 && Imm >= -64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_NegSubInlineConst32: {
    
  return Imm < -16 && Imm >= -64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_SIMM16bit: {
    return isInt<16>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_UIMM16bit: {
    return isUInt<16>(Imm); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_MI_Predicate_smrd_load = GIPFP_MI_Invalid + 1,
};
bool AMDGPUInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  switch (PredicateID) {
  case GIPFP_MI_Predicate_smrd_load: {
    
    if (!MI.hasOneMemOperand())
      return false;
    if (!isInstrUniform(MI))
      return false;

    // FIXME: We should probably be caching this.
    SmallVector<GEPInfo, 4> AddrInfo;
    getAddrModeInfo(MI, MRI, AddrInfo);

    if (hasVgprParts(AddrInfo))
      return false;
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}

AMDGPUInstructionSelector::ComplexMatcherMemFn
AMDGPUInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
};
AMDGPUInstructionSelector::CustomRendererFn
AMDGPUInstructionSelector::CustomRenderers[] = {
  nullptr, // GICP_Invalid
};

bool AMDGPUInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  // FIXME: This should be computed on a per-function basis rather than per-insn.
  AvailableFunctionFeatures = computeAvailableFunctionFeatures(&STI, &MF);
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *AMDGPUInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/35, 153, /*)*//*default:*//*Label 24*/ 9094,
    /*TargetOpcode::G_ADD*//*Label 0*/ 123,
    /*TargetOpcode::G_SUB*//*Label 1*/ 320,
    /*TargetOpcode::G_MUL*//*Label 2*/ 351, 0, 0, 0, 0,
    /*TargetOpcode::G_AND*//*Label 3*/ 398,
    /*TargetOpcode::G_OR*//*Label 4*/ 427,
    /*TargetOpcode::G_XOR*//*Label 5*/ 2075, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 6*/ 2177, 0, 0,
    /*TargetOpcode::G_LOAD*//*Label 7*/ 4570, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 8*/ 4868, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 9*/ 4913,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 10*/ 7860, 0, 0,
    /*TargetOpcode::G_CONSTANT*//*Label 11*/ 8323, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SHL*//*Label 12*/ 8380,
    /*TargetOpcode::G_LSHR*//*Label 13*/ 8517,
    /*TargetOpcode::G_ASHR*//*Label 14*/ 8654, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 15*/ 8791,
    /*TargetOpcode::G_SMULH*//*Label 16*/ 8820, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FPOW*//*Label 17*/ 8849, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 18*/ 8922,
    /*TargetOpcode::G_SMAX*//*Label 19*/ 8951,
    /*TargetOpcode::G_UMIN*//*Label 20*/ 8980,
    /*TargetOpcode::G_UMAX*//*Label 21*/ 9009,
    /*TargetOpcode::G_BR*//*Label 22*/ 9038, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CTPOP*//*Label 23*/ 9067,
    // Label 0: @123
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 4, /*)*//*default:*//*Label 27*/ 319,
    /*GILLT_s16*//*Label 25*/ 132, 0,
    /*GILLT_s64*//*Label 26*/ 292,
    // Label 25: @132
    GIM_Try, /*On fail goto*//*Label 28*/ 291,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_Try, /*On fail goto*//*Label 29*/ 194, // Rule ID 2308 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_U16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2308,
        GIR_Done,
      // Label 29: @194
      GIM_Try, /*On fail goto*//*Label 30*/ 242, // Rule ID 2309 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_I16:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_I16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2309,
        GIR_Done,
      // Label 30: @242
      GIM_Try, /*On fail goto*//*Label 31*/ 290, // Rule ID 3253 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_U16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3253,
        GIR_Done,
      // Label 31: @290
      GIM_Reject,
    // Label 28: @291
    GIM_Reject,
    // Label 26: @292
    GIM_Try, /*On fail goto*//*Label 32*/ 318, // Rule ID 705 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)  =>  (S_ADD_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_ADD_U64_PSEUDO,
      GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 705,
      GIR_Done,
    // Label 32: @318
    GIM_Reject,
    // Label 27: @319
    GIM_Reject,
    // Label 1: @320
    GIM_Try, /*On fail goto*//*Label 33*/ 350, // Rule ID 706 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)  =>  (S_SUB_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_SUB_U64_PSEUDO,
      GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 706,
      GIR_Done,
    // Label 33: @350
    GIM_Reject,
    // Label 2: @351
    GIM_Try, /*On fail goto*//*Label 34*/ 397,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 35*/ 380, // Rule ID 42 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (S_MUL_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_MUL_I32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 42,
        GIR_Done,
      // Label 35: @380
      GIM_Try, /*On fail goto*//*Label 36*/ 396, // Rule ID 487 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MUL_LO_U32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MUL_LO_U32,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 487,
        GIR_Done,
      // Label 36: @396
      GIM_Reject,
    // Label 34: @397
    GIM_Reject,
    // Label 3: @398
    GIM_Try, /*On fail goto*//*Label 37*/ 426, // Rule ID 452 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_AND_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 452,
      GIR_Done,
    // Label 37: @426
    GIM_Reject,
    // Label 4: @427
    GIM_Try, /*On fail goto*//*Label 38*/ 2074,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_Try, /*On fail goto*//*Label 39*/ 546, // Rule ID 3200 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3200,
        GIR_Done,
      // Label 39: @546
      GIM_Try, /*On fail goto*//*Label 40*/ 647, // Rule ID 3201 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3201,
        GIR_Done,
      // Label 40: @647
      GIM_Try, /*On fail goto*//*Label 41*/ 748, // Rule ID 3202 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3202,
        GIR_Done,
      // Label 41: @748
      GIM_Try, /*On fail goto*//*Label 42*/ 849, // Rule ID 3203 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3203,
        GIR_Done,
      // Label 42: @849
      GIM_Try, /*On fail goto*//*Label 43*/ 950, // Rule ID 3196 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3196,
        GIR_Done,
      // Label 43: @950
      GIM_Try, /*On fail goto*//*Label 44*/ 1051, // Rule ID 3197 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3197,
        GIR_Done,
      // Label 44: @1051
      GIM_Try, /*On fail goto*//*Label 45*/ 1152, // Rule ID 3198 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3198,
        GIR_Done,
      // Label 45: @1152
      GIM_Try, /*On fail goto*//*Label 46*/ 1253, // Rule ID 3199 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3199,
        GIR_Done,
      // Label 46: @1253
      GIM_Try, /*On fail goto*//*Label 47*/ 1354, // Rule ID 3190 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3190,
        GIR_Done,
      // Label 47: @1354
      GIM_Try, /*On fail goto*//*Label 48*/ 1455, // Rule ID 3191 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3191,
        GIR_Done,
      // Label 48: @1455
      GIM_Try, /*On fail goto*//*Label 49*/ 1556, // Rule ID 3194 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3194,
        GIR_Done,
      // Label 49: @1556
      GIM_Try, /*On fail goto*//*Label 50*/ 1657, // Rule ID 3195 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3195,
        GIR_Done,
      // Label 50: @1657
      GIM_Try, /*On fail goto*//*Label 51*/ 1758, // Rule ID 2009 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2009,
        GIR_Done,
      // Label 51: @1758
      GIM_Try, /*On fail goto*//*Label 52*/ 1859, // Rule ID 3189 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3189,
        GIR_Done,
      // Label 52: @1859
      GIM_Try, /*On fail goto*//*Label 53*/ 1960, // Rule ID 3192 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3192,
        GIR_Done,
      // Label 53: @1960
      GIM_Try, /*On fail goto*//*Label 54*/ 2061, // Rule ID 3193 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3193,
        GIR_Done,
      // Label 54: @2061
      GIM_Try, /*On fail goto*//*Label 55*/ 2073, // Rule ID 454 //
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_OR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 454,
        GIR_Done,
      // Label 55: @2073
      GIM_Reject,
    // Label 38: @2074
    GIM_Reject,
    // Label 5: @2075
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 4, /*)*//*default:*//*Label 58*/ 2176,
    /*GILLT_s32*//*Label 56*/ 2083,
    /*GILLT_s64*//*Label 57*/ 2139,
    // Label 56: @2083
    GIM_Try, /*On fail goto*//*Label 59*/ 2138,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 60*/ 2121, // Rule ID 0 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] })  =>  (S_NOT_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOT_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 0,
        GIR_Done,
      // Label 60: @2121
      GIM_Try, /*On fail goto*//*Label 61*/ 2137, // Rule ID 456 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_XOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 456,
        GIR_Done,
      // Label 61: @2137
      GIM_Reject,
    // Label 59: @2138
    GIM_Reject,
    // Label 57: @2139
    GIM_Try, /*On fail goto*//*Label 62*/ 2175, // Rule ID 1 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
      // (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, -1:{ *:[i64] })  =>  (S_NOT_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOT_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1,
      GIR_Done,
    // Label 62: @2175
    GIM_Reject,
    // Label 58: @2176
    GIM_Reject,
    // Label 6: @2177
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 14, /*)*//*default:*//*Label 76*/ 4569,
    /*GILLT_s16*//*Label 63*/ 2196,
    /*GILLT_s32*//*Label 64*/ 2324,
    /*GILLT_s64*//*Label 65*/ 2597,
    /*GILLT_v2s16*//*Label 66*/ 2938,
    /*GILLT_v2s32*//*Label 67*/ 3143,
    /*GILLT_v2s64*//*Label 68*/ 3518,
    /*GILLT_v3s32*//*Label 69*/ 3689,
    /*GILLT_v4s16*//*Label 70*/ 3749,
    /*GILLT_v4s32*//*Label 71*/ 4090,
    /*GILLT_v5s32*//*Label 72*/ 4261,
    /*GILLT_v8s32*//*Label 73*/ 4321,
    /*GILLT_v16s32*//*Label 74*/ 4449,
    /*GILLT_v32s32*//*Label 75*/ 4509,
    // Label 63: @2196
    GIM_Try, /*On fail goto*//*Label 77*/ 2323,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 78*/ 2232, // Rule ID 1597 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (bitconvert:{ *:[i16] } VGPR_32:{ *:[f16] }:$src0)  =>  VGPR_32:{ *:[i16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VGPR_32*/11,
        // GIR_Coverage, 1597,
        GIR_Done,
      // Label 78: @2232
      GIM_Try, /*On fail goto*//*Label 79*/ 2262, // Rule ID 1598 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (bitconvert:{ *:[f16] } VGPR_32:{ *:[i16] }:$src0)  =>  VGPR_32:{ *:[f16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VGPR_32*/11,
        // GIR_Coverage, 1598,
        GIR_Done,
      // Label 79: @2262
      GIM_Try, /*On fail goto*//*Label 80*/ 2292, // Rule ID 1599 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (bitconvert:{ *:[i16] } SReg_32:{ *:[f16] }:$src0)  =>  SReg_32:{ *:[i16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
        // GIR_Coverage, 1599,
        GIR_Done,
      // Label 80: @2292
      GIM_Try, /*On fail goto*//*Label 81*/ 2322, // Rule ID 1600 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (bitconvert:{ *:[f16] } SReg_32:{ *:[i16] }:$src0)  =>  SReg_32:{ *:[f16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
        // GIR_Coverage, 1600,
        GIR_Done,
      // Label 81: @2322
      GIM_Reject,
    // Label 77: @2323
    GIM_Reject,
    // Label 64: @2324
    GIM_Try, /*On fail goto*//*Label 82*/ 2358, // Rule ID 1601 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (bitconvert:{ *:[i32] } VGPR_32:{ *:[f32] }:$src0)  =>  VGPR_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VGPR_32*/11,
      // GIR_Coverage, 1601,
      GIR_Done,
    // Label 82: @2358
    GIM_Try, /*On fail goto*//*Label 83*/ 2392, // Rule ID 1602 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (bitconvert:{ *:[f32] } VGPR_32:{ *:[i32] }:$src0)  =>  VGPR_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VGPR_32*/11,
      // GIR_Coverage, 1602,
      GIR_Done,
    // Label 83: @2392
    GIM_Try, /*On fail goto*//*Label 84*/ 2426, // Rule ID 1603 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1603,
      GIR_Done,
    // Label 84: @2426
    GIM_Try, /*On fail goto*//*Label 85*/ 2460, // Rule ID 1604 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1604,
      GIR_Done,
    // Label 85: @2460
    GIM_Try, /*On fail goto*//*Label 86*/ 2494, // Rule ID 1606 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1606,
      GIR_Done,
    // Label 86: @2494
    GIM_Try, /*On fail goto*//*Label 87*/ 2528, // Rule ID 1608 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1608,
      GIR_Done,
    // Label 87: @2528
    GIM_Try, /*On fail goto*//*Label 88*/ 2562, // Rule ID 1612 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1612,
      GIR_Done,
    // Label 88: @2562
    GIM_Try, /*On fail goto*//*Label 89*/ 2596, // Rule ID 1614 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1614,
      GIR_Done,
    // Label 89: @2596
    GIM_Reject,
    // Label 65: @2597
    GIM_Try, /*On fail goto*//*Label 90*/ 2631, // Rule ID 1615 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1615,
      GIR_Done,
    // Label 90: @2631
    GIM_Try, /*On fail goto*//*Label 91*/ 2665, // Rule ID 1616 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1616,
      GIR_Done,
    // Label 91: @2665
    GIM_Try, /*On fail goto*//*Label 92*/ 2699, // Rule ID 1619 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1619,
      GIR_Done,
    // Label 92: @2699
    GIM_Try, /*On fail goto*//*Label 93*/ 2733, // Rule ID 1621 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1621,
      GIR_Done,
    // Label 93: @2733
    GIM_Try, /*On fail goto*//*Label 94*/ 2767, // Rule ID 1623 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1623,
      GIR_Done,
    // Label 94: @2767
    GIM_Try, /*On fail goto*//*Label 95*/ 2801, // Rule ID 1625 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1625,
      GIR_Done,
    // Label 95: @2801
    GIM_Try, /*On fail goto*//*Label 96*/ 2835, // Rule ID 1640 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1640,
      GIR_Done,
    // Label 96: @2835
    GIM_Try, /*On fail goto*//*Label 97*/ 2869, // Rule ID 1641 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1641,
      GIR_Done,
    // Label 97: @2869
    GIM_Try, /*On fail goto*//*Label 98*/ 2903, // Rule ID 1644 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1644,
      GIR_Done,
    // Label 98: @2903
    GIM_Try, /*On fail goto*//*Label 99*/ 2937, // Rule ID 1645 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1645,
      GIR_Done,
    // Label 99: @2937
    GIM_Reject,
    // Label 66: @2938
    GIM_Try, /*On fail goto*//*Label 100*/ 2972, // Rule ID 1605 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1605,
      GIR_Done,
    // Label 100: @2972
    GIM_Try, /*On fail goto*//*Label 101*/ 3006, // Rule ID 1607 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1607,
      GIR_Done,
    // Label 101: @3006
    GIM_Try, /*On fail goto*//*Label 102*/ 3040, // Rule ID 1609 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1609,
      GIR_Done,
    // Label 102: @3040
    GIM_Try, /*On fail goto*//*Label 103*/ 3074, // Rule ID 1610 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1610,
      GIR_Done,
    // Label 103: @3074
    GIM_Try, /*On fail goto*//*Label 104*/ 3108, // Rule ID 1611 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1611,
      GIR_Done,
    // Label 104: @3108
    GIM_Try, /*On fail goto*//*Label 105*/ 3142, // Rule ID 1613 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 1613,
      GIR_Done,
    // Label 105: @3142
    GIM_Reject,
    // Label 67: @3143
    GIM_Try, /*On fail goto*//*Label 106*/ 3177, // Rule ID 1617 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1617,
      GIR_Done,
    // Label 106: @3177
    GIM_Try, /*On fail goto*//*Label 107*/ 3211, // Rule ID 1618 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1618,
      GIR_Done,
    // Label 107: @3211
    GIM_Try, /*On fail goto*//*Label 108*/ 3245, // Rule ID 1620 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1620,
      GIR_Done,
    // Label 108: @3245
    GIM_Try, /*On fail goto*//*Label 109*/ 3279, // Rule ID 1622 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1622,
      GIR_Done,
    // Label 109: @3279
    GIM_Try, /*On fail goto*//*Label 110*/ 3313, // Rule ID 1624 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1624,
      GIR_Done,
    // Label 110: @3313
    GIM_Try, /*On fail goto*//*Label 111*/ 3347, // Rule ID 1626 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1626,
      GIR_Done,
    // Label 111: @3347
    GIM_Try, /*On fail goto*//*Label 112*/ 3381, // Rule ID 1629 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1629,
      GIR_Done,
    // Label 112: @3381
    GIM_Try, /*On fail goto*//*Label 113*/ 3415, // Rule ID 1631 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1631,
      GIR_Done,
    // Label 113: @3415
    GIM_Try, /*On fail goto*//*Label 114*/ 3449, // Rule ID 1632 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1632,
      GIR_Done,
    // Label 114: @3449
    GIM_Try, /*On fail goto*//*Label 115*/ 3483, // Rule ID 1634 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1634,
      GIR_Done,
    // Label 115: @3483
    GIM_Try, /*On fail goto*//*Label 116*/ 3517, // Rule ID 1636 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1636,
      GIR_Done,
    // Label 116: @3517
    GIM_Reject,
    // Label 68: @3518
    GIM_Try, /*On fail goto*//*Label 117*/ 3552, // Rule ID 1650 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v4i32] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_128*/42,
      // GIR_Coverage, 1650,
      GIR_Done,
    // Label 117: @3552
    GIM_Try, /*On fail goto*//*Label 118*/ 3586, // Rule ID 1652 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 1652,
      GIR_Done,
    // Label 118: @3586
    GIM_Try, /*On fail goto*//*Label 119*/ 3620, // Rule ID 1653 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 1653,
      GIR_Done,
    // Label 119: @3620
    GIM_Try, /*On fail goto*//*Label 120*/ 3654, // Rule ID 1656 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 1656,
      GIR_Done,
    // Label 120: @3654
    GIM_Try, /*On fail goto*//*Label 121*/ 3688, // Rule ID 1657 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v2i64] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 1657,
      GIR_Done,
    // Label 121: @3688
    GIM_Reject,
    // Label 69: @3689
    GIM_Try, /*On fail goto*//*Label 122*/ 3748,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SGPR_96RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SGPR_96RegClassID,
      GIM_Try, /*On fail goto*//*Label 123*/ 3725, // Rule ID 1648 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        // (bitconvert:{ *:[v3i32] } SGPR_96:{ *:[v3f32] }:$src0)  =>  SGPR_96:{ *:[v3i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SGPR_96*/34,
        // GIR_Coverage, 1648,
        GIR_Done,
      // Label 123: @3725
      GIM_Try, /*On fail goto*//*Label 124*/ 3747, // Rule ID 1649 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        // (bitconvert:{ *:[v3f32] } SGPR_96:{ *:[v3i32] }:$src0)  =>  SGPR_96:{ *:[v3f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SGPR_96*/34,
        // GIR_Coverage, 1649,
        GIR_Done,
      // Label 124: @3747
      GIM_Reject,
    // Label 122: @3748
    GIM_Reject,
    // Label 70: @3749
    GIM_Try, /*On fail goto*//*Label 125*/ 3783, // Rule ID 1627 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1627,
      GIR_Done,
    // Label 125: @3783
    GIM_Try, /*On fail goto*//*Label 126*/ 3817, // Rule ID 1628 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1628,
      GIR_Done,
    // Label 126: @3817
    GIM_Try, /*On fail goto*//*Label 127*/ 3851, // Rule ID 1630 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1630,
      GIR_Done,
    // Label 127: @3851
    GIM_Try, /*On fail goto*//*Label 128*/ 3885, // Rule ID 1633 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1633,
      GIR_Done,
    // Label 128: @3885
    GIM_Try, /*On fail goto*//*Label 129*/ 3919, // Rule ID 1635 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1635,
      GIR_Done,
    // Label 129: @3919
    GIM_Try, /*On fail goto*//*Label 130*/ 3953, // Rule ID 1637 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1637,
      GIR_Done,
    // Label 130: @3953
    GIM_Try, /*On fail goto*//*Label 131*/ 3987, // Rule ID 1638 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1638,
      GIR_Done,
    // Label 131: @3987
    GIM_Try, /*On fail goto*//*Label 132*/ 4021, // Rule ID 1639 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1639,
      GIR_Done,
    // Label 132: @4021
    GIM_Try, /*On fail goto*//*Label 133*/ 4055, // Rule ID 1642 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1642,
      GIR_Done,
    // Label 133: @4055
    GIM_Try, /*On fail goto*//*Label 134*/ 4089, // Rule ID 1643 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 1643,
      GIR_Done,
    // Label 134: @4089
    GIM_Reject,
    // Label 71: @4090
    GIM_Try, /*On fail goto*//*Label 135*/ 4124, // Rule ID 1646 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 1646,
      GIR_Done,
    // Label 135: @4124
    GIM_Try, /*On fail goto*//*Label 136*/ 4158, // Rule ID 1647 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 1647,
      GIR_Done,
    // Label 136: @4158
    GIM_Try, /*On fail goto*//*Label 137*/ 4192, // Rule ID 1651 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_128*/42,
      // GIR_Coverage, 1651,
      GIR_Done,
    // Label 137: @4192
    GIM_Try, /*On fail goto*//*Label 138*/ 4226, // Rule ID 1654 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 1654,
      GIR_Done,
    // Label 138: @4226
    GIM_Try, /*On fail goto*//*Label 139*/ 4260, // Rule ID 1655 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 1655,
      GIR_Done,
    // Label 139: @4260
    GIM_Reject,
    // Label 72: @4261
    GIM_Try, /*On fail goto*//*Label 140*/ 4320,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v5s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SGPR_160RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SGPR_160RegClassID,
      GIM_Try, /*On fail goto*//*Label 141*/ 4297, // Rule ID 1658 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        // (bitconvert:{ *:[v5i32] } SGPR_160:{ *:[v5f32] }:$src0)  =>  SGPR_160:{ *:[v5i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SGPR_160*/52,
        // GIR_Coverage, 1658,
        GIR_Done,
      // Label 141: @4297
      GIM_Try, /*On fail goto*//*Label 142*/ 4319, // Rule ID 1659 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        // (bitconvert:{ *:[v5f32] } SGPR_160:{ *:[v5i32] }:$src0)  =>  SGPR_160:{ *:[v5f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SGPR_160*/52,
        // GIR_Coverage, 1659,
        GIR_Done,
      // Label 142: @4319
      GIM_Reject,
    // Label 140: @4320
    GIM_Reject,
    // Label 73: @4321
    GIM_Try, /*On fail goto*//*Label 143*/ 4448,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 144*/ 4357, // Rule ID 1660 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_256RegClassID,
        // (bitconvert:{ *:[v8i32] } SReg_256:{ *:[v8f32] }:$src0)  =>  SReg_256:{ *:[v8i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_256*/62,
        // GIR_Coverage, 1660,
        GIR_Done,
      // Label 144: @4357
      GIM_Try, /*On fail goto*//*Label 145*/ 4387, // Rule ID 1661 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_256RegClassID,
        // (bitconvert:{ *:[v8f32] } SReg_256:{ *:[v8i32] }:$src0)  =>  SReg_256:{ *:[v8f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_256*/62,
        // GIR_Coverage, 1661,
        GIR_Done,
      // Label 145: @4387
      GIM_Try, /*On fail goto*//*Label 146*/ 4417, // Rule ID 1662 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
        // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_256*/61,
        // GIR_Coverage, 1662,
        GIR_Done,
      // Label 146: @4417
      GIM_Try, /*On fail goto*//*Label 147*/ 4447, // Rule ID 1663 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
        // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_256*/61,
        // GIR_Coverage, 1663,
        GIR_Done,
      // Label 147: @4447
      GIM_Reject,
    // Label 143: @4448
    GIM_Reject,
    // Label 74: @4449
    GIM_Try, /*On fail goto*//*Label 148*/ 4508,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_Try, /*On fail goto*//*Label 149*/ 4485, // Rule ID 1664 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        // (bitconvert:{ *:[v16i32] } VReg_512:{ *:[v16f32] }:$src0)  =>  VReg_512:{ *:[v16i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_512*/75,
        // GIR_Coverage, 1664,
        GIR_Done,
      // Label 149: @4485
      GIM_Try, /*On fail goto*//*Label 150*/ 4507, // Rule ID 1665 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        // (bitconvert:{ *:[v16f32] } VReg_512:{ *:[v16i32] }:$src0)  =>  VReg_512:{ *:[v16f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_512*/75,
        // GIR_Coverage, 1665,
        GIR_Done,
      // Label 150: @4507
      GIM_Reject,
    // Label 148: @4508
    GIM_Reject,
    // Label 75: @4509
    GIM_Try, /*On fail goto*//*Label 151*/ 4568,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_Try, /*On fail goto*//*Label 152*/ 4545, // Rule ID 1666 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        // (bitconvert:{ *:[v32i32] } VReg_1024:{ *:[v32f32] }:$src0)  =>  VReg_1024:{ *:[v32i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_1024*/93,
        // GIR_Coverage, 1666,
        GIR_Done,
      // Label 152: @4545
      GIM_Try, /*On fail goto*//*Label 153*/ 4567, // Rule ID 1667 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        // (bitconvert:{ *:[v32f32] } VReg_1024:{ *:[v32i32] }:$src0)  =>  VReg_1024:{ *:[v32f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_1024*/93,
        // GIR_Coverage, 1667,
        GIR_Done,
      // Label 153: @4567
      GIM_Reject,
    // Label 151: @4568
    GIM_Reject,
    // Label 76: @4569
    GIM_Reject,
    // Label 7: @4570
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 13, /*)*//*default:*//*Label 159*/ 4867,
    /*GILLT_s32*//*Label 154*/ 4587, 0, 0,
    /*GILLT_v2s32*//*Label 155*/ 4643, 0, 0, 0,
    /*GILLT_v4s32*//*Label 156*/ 4699, 0,
    /*GILLT_v8s32*//*Label 157*/ 4755,
    /*GILLT_v16s32*//*Label 158*/ 4811,
    // Label 154: @4587
    GIM_Try, /*On fail goto*//*Label 160*/ 4642, // Rule ID 2358 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2358,
      GIR_Done,
    // Label 160: @4642
    GIM_Reject,
    // Label 155: @4643
    GIM_Try, /*On fail goto*//*Label 161*/ 4698, // Rule ID 2365 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[v2i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[v2i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2365,
      GIR_Done,
    // Label 161: @4698
    GIM_Reject,
    // Label 156: @4699
    GIM_Try, /*On fail goto*//*Label 162*/ 4754, // Rule ID 2369 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[v4i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX4_IMM:{ *:[v4i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX4_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2369,
      GIR_Done,
    // Label 162: @4754
    GIM_Reject,
    // Label 157: @4755
    GIM_Try, /*On fail goto*//*Label 163*/ 4810, // Rule ID 2373 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[v8i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX8_IMM:{ *:[v8i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX8_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2373,
      GIR_Done,
    // Label 163: @4810
    GIM_Reject,
    // Label 158: @4811
    GIM_Try, /*On fail goto*//*Label 164*/ 4866, // Rule ID 2377 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_512RegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[v16i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX16_IMM:{ *:[v16i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX16_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2377,
      GIR_Done,
    // Label 164: @4866
    GIM_Reject,
    // Label 159: @4867
    GIM_Reject,
    // Label 8: @4868
    GIM_Try, /*On fail goto*//*Label 165*/ 4912, // Rule ID 702 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
      // MIs[1] Operand 1
      // No operand predicates
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/1, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
      // MIs[2] Operand 1
      // No operand predicates
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/2,
      // (atomic_fence (imm:{ *:[i32] }):$ordering, (imm:{ *:[i32] }):$scope)  =>  (ATOMIC_FENCE (imm:{ *:[i32] }):$ordering, (imm:{ *:[i32] }):$scope)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::ATOMIC_FENCE,
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // ordering
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // scope
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 702,
      GIR_Done,
    // Label 165: @4912
    GIM_Reject,
    // Label 9: @4913
    GIM_Try, /*On fail goto*//*Label 166*/ 5003,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 167*/ 4946, // Rule ID 9 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_s_getpc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 1067:{ *:[iPTR] })  =>  (S_GETPC_B64:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_GETPC_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 9,
        GIR_Done,
      // Label 167: @4946
      GIM_Try, /*On fail goto*//*Label 168*/ 4974, // Rule ID 707 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_groupstaticsize,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 524:{ *:[iPTR] })  =>  (GET_GROUPSTATICSIZE:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GET_GROUPSTATICSIZE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 707,
        GIR_Done,
      // Label 168: @4974
      GIM_Try, /*On fail goto*//*Label 169*/ 5002, // Rule ID 712 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_ps_live,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_1RegClassID,
        // (intrinsic_wo_chain:{ *:[i1] } 1032:{ *:[iPTR] })  =>  (SI_PS_LIVE:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SI_PS_LIVE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 712,
        GIR_Done,
      // Label 169: @5002
      GIM_Reject,
    // Label 166: @5003
    GIM_Try, /*On fail goto*//*Label 170*/ 5042, // Rule ID 357 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_readfirstlane,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      // (intrinsic_wo_chain:{ *:[i32] } 1054:{ *:[iPTR] }, i32:{ *:[i32] }:$src0)  =>  (V_READFIRSTLANE_B32:{ *:[i32] } i32:{ *:[i32] }:$src0)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_READFIRSTLANE_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 357,
      GIR_Done,
    // Label 170: @5042
    GIM_Try, /*On fail goto*//*Label 171*/ 5262,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 172*/ 5089, // Rule ID 457 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_readlane,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1055:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_READLANE_B32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_READLANE_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 457,
        GIR_Done,
      // Label 172: @5089
      GIM_Try, /*On fail goto*//*Label 173*/ 5133, // Rule ID 703 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_set_inactive,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1083:{ *:[iPTR] }, i32:{ *:[i32] }:$src, i32:{ *:[i32] }:$inactive)  =>  (V_SET_INACTIVE_B32:{ *:[i32] } i32:{ *:[i32] }:$src, i32:{ *:[i32] }:$inactive)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SET_INACTIVE_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // inactive
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 703,
        GIR_Done,
      // Label 173: @5133
      GIM_Try, /*On fail goto*//*Label 174*/ 5177, // Rule ID 704 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_set_inactive,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 1083:{ *:[iPTR] }, i64:{ *:[i64] }:$src, i64:{ *:[i64] }:$inactive)  =>  (V_SET_INACTIVE_B64:{ *:[i64] } i64:{ *:[i64] }:$src, i64:{ *:[i64] }:$inactive)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SET_INACTIVE_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // inactive
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 704,
        GIR_Done,
      // Label 174: @5177
      GIM_Try, /*On fail goto*//*Label 175*/ 5219, // Rule ID 459 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mbcnt_lo,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1002:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MBCNT_LO_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MBCNT_LO_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 459,
        GIR_Done,
      // Label 175: @5219
      GIM_Try, /*On fail goto*//*Label 176*/ 5261, // Rule ID 460 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mbcnt_hi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1001:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MBCNT_HI_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MBCNT_HI_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 460,
        GIR_Done,
      // Label 176: @5261
      GIM_Reject,
    // Label 171: @5262
    GIM_Try, /*On fail goto*//*Label 177*/ 5853,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 178*/ 5317, // Rule ID 458 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_writelane,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1122:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$vdst_in)  =>  (V_WRITELANE_B32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$vdst_in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_WRITELANE_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vdst_in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 458,
        GIR_Done,
      // Label 178: @5317
      GIM_Try, /*On fail goto*//*Label 179*/ 5372, // Rule ID 2324 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_sad_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1078:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U8:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SAD_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2324,
        GIR_Done,
      // Label 179: @5372
      GIM_Try, /*On fail goto*//*Label 180*/ 5427, // Rule ID 2325 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_sad_hi_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1076:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_SAD_HI_U8:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SAD_HI_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2325,
        GIR_Done,
      // Label 180: @5427
      GIM_Try, /*On fail goto*//*Label 181*/ 5482, // Rule ID 2326 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_sad_u16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1077:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U16:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SAD_U16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2326,
        GIR_Done,
      // Label 181: @5482
      GIM_Try, /*On fail goto*//*Label 182*/ 5537, // Rule ID 2327 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_msad_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1027:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_MSAD_U8:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MSAD_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2327,
        GIR_Done,
      // Label 182: @5537
      GIM_Try, /*On fail goto*//*Label 183*/ 5592, // Rule ID 2328 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mqsad_pk_u16_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 1025:{ *:[iPTR] }, i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, i64:{ *:[i64] }:$src2)  =>  (V_MQSAD_PK_U16_U8:{ *:[i64] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, i64:{ *:[i64] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MQSAD_PK_U16_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2328,
        GIR_Done,
      // Label 183: @5592
      GIM_Try, /*On fail goto*//*Label 184*/ 5647, // Rule ID 2329 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_qsad_pk_u16_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 1033:{ *:[iPTR] }, i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, i64:{ *:[i64] }:$src2)  =>  (V_QSAD_PK_U16_U8:{ *:[i64] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, i64:{ *:[i64] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_QSAD_PK_U16_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2329,
        GIR_Done,
      // Label 184: @5647
      GIM_Try, /*On fail goto*//*Label 185*/ 5702, // Rule ID 2330 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mqsad_u32_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1026:{ *:[iPTR] }, i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2)  =>  (V_MQSAD_U32_U8:{ *:[v4i32] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MQSAD_U32_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2330,
        GIR_Done,
      // Label 185: @5702
      GIM_Try, /*On fail goto*//*Label 186*/ 5752, // Rule ID 479 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_lerp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 998:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_LERP_U8:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LERP_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 479,
        GIR_Done,
      // Label 186: @5752
      GIM_Try, /*On fail goto*//*Label 187*/ 5802, // Rule ID 497 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_alignbit,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 454:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_ALIGNBIT_B32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ALIGNBIT_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 497,
        GIR_Done,
      // Label 187: @5802
      GIM_Try, /*On fail goto*//*Label 188*/ 5852, // Rule ID 498 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_alignbyte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 455:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_ALIGNBYTE_B32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ALIGNBYTE_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 498,
        GIR_Done,
      // Label 188: @5852
      GIM_Reject,
    // Label 177: @5853
    GIM_Try, /*On fail goto*//*Label 189*/ 7859,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/8,
      GIM_Try, /*On fail goto*//*Label 190*/ 5958, // Rule ID 554 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_4x4x1f32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1015:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_4X4X1F32:{ *:[v4f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_4X4X1F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 554,
        GIR_Done,
      // Label 190: @5958
      GIM_Try, /*On fail goto*//*Label 191*/ 6058, // Rule ID 555 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_4x4x4f16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1017:{ *:[iPTR] }, v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_4X4X4F16:{ *:[v4f32] } v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_4X4X4F16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 555,
        GIR_Done,
      // Label 191: @6058
      GIM_Try, /*On fail goto*//*Label 192*/ 6158, // Rule ID 556 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_i32_4x4x4i8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1022:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_I32_4X4X4I8:{ *:[v4i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_I32_4X4X4I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 556,
        GIR_Done,
      // Label 192: @6158
      GIM_Try, /*On fail goto*//*Label 193*/ 6258, // Rule ID 557 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_4x4x2bf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1016:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_4X4X2BF16:{ *:[v4f32] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_4X4X2BF16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 557,
        GIR_Done,
      // Label 193: @6258
      GIM_Try, /*On fail goto*//*Label 194*/ 6358, // Rule ID 558 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x1f32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1004:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X1F32:{ *:[v16f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X1F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 558,
        GIR_Done,
      // Label 194: @6358
      GIM_Try, /*On fail goto*//*Label 195*/ 6458, // Rule ID 559 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x4f32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1007:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X4F32:{ *:[v4f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X4F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 559,
        GIR_Done,
      // Label 195: @6458
      GIM_Try, /*On fail goto*//*Label 196*/ 6558, // Rule ID 560 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x4f16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1006:{ *:[iPTR] }, v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X4F16:{ *:[v16f32] } v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X4F16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 560,
        GIR_Done,
      // Label 196: @6558
      GIM_Try, /*On fail goto*//*Label 197*/ 6658, // Rule ID 561 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x16f16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1003:{ *:[iPTR] }, v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X16F16:{ *:[v4f32] } v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X16F16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 561,
        GIR_Done,
      // Label 197: @6658
      GIM_Try, /*On fail goto*//*Label 198*/ 6758, // Rule ID 562 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_i32_16x16x4i8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v16i32] } 1019:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v16i32:{ *:[v16i32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_I32_16X16X4I8:{ *:[v16i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v16i32:{ *:[v16i32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_I32_16X16X4I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 562,
        GIR_Done,
      // Label 198: @6758
      GIM_Try, /*On fail goto*//*Label 199*/ 6858, // Rule ID 563 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_i32_16x16x16i8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1018:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_I32_16X16X16I8:{ *:[v4i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_I32_16X16X16I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 563,
        GIR_Done,
      // Label 199: @6858
      GIM_Try, /*On fail goto*//*Label 200*/ 6958, // Rule ID 564 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x2bf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1005:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X2BF16:{ *:[v16f32] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X2BF16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 564,
        GIR_Done,
      // Label 200: @6958
      GIM_Try, /*On fail goto*//*Label 201*/ 7058, // Rule ID 565 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x8bf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1008:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X8BF16:{ *:[v4f32] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X8BF16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 565,
        GIR_Done,
      // Label 201: @7058
      GIM_Try, /*On fail goto*//*Label 202*/ 7158, // Rule ID 566 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x1f32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_1024RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v32f32] } 1009:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v32f32:{ *:[v32f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X1F32:{ *:[v32f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v32f32:{ *:[v32f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X1F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 566,
        GIR_Done,
      // Label 202: @7158
      GIM_Try, /*On fail goto*//*Label 203*/ 7258, // Rule ID 567 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x2f32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1011:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X2F32:{ *:[v16f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X2F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 567,
        GIR_Done,
      // Label 203: @7258
      GIM_Try, /*On fail goto*//*Label 204*/ 7358, // Rule ID 568 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x4f16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_1024RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v32f32] } 1013:{ *:[iPTR] }, v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v32f32:{ *:[v32f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X4F16:{ *:[v32f32] } v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v32f32:{ *:[v32f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X4F16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 568,
        GIR_Done,
      // Label 204: @7358
      GIM_Try, /*On fail goto*//*Label 205*/ 7458, // Rule ID 569 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x8f16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1014:{ *:[iPTR] }, v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X8F16:{ *:[v16f32] } v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X8F16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 569,
        GIR_Done,
      // Label 205: @7458
      GIM_Try, /*On fail goto*//*Label 206*/ 7558, // Rule ID 570 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_i32_32x32x4i8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_1024RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v32i32] } 1020:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v32i32:{ *:[v32i32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_I32_32X32X4I8:{ *:[v32i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v32i32:{ *:[v32i32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_I32_32X32X4I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 570,
        GIR_Done,
      // Label 206: @7558
      GIM_Try, /*On fail goto*//*Label 207*/ 7658, // Rule ID 571 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_i32_32x32x8i8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v16i32] } 1021:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v16i32:{ *:[v16i32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_I32_32X32X8I8:{ *:[v16i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v16i32:{ *:[v16i32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_I32_32X32X8I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 571,
        GIR_Done,
      // Label 207: @7658
      GIM_Try, /*On fail goto*//*Label 208*/ 7758, // Rule ID 572 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x2bf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_1024RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v32f32] } 1010:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v32f32:{ *:[v32f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X2BF16:{ *:[v32f32] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v32f32:{ *:[v32f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X2BF16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 572,
        GIR_Done,
      // Label 208: @7758
      GIM_Try, /*On fail goto*//*Label 209*/ 7858, // Rule ID 573 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x4bf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1012:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X4BF16:{ *:[v16f32] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (imm:{ *:[i32] }):$cbsz, (imm:{ *:[i32] }):$abid, (imm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X4BF16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // cbsz
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // abid
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 573,
        GIR_Done,
      // Label 209: @7858
      GIM_Reject,
    // Label 189: @7859
    GIM_Reject,
    // Label 10: @7860
    GIM_Try, /*On fail goto*//*Label 210*/ 7880, // Rule ID 64 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_barrier,
      // (intrinsic_void 1059:{ *:[iPTR] })  =>  (S_BARRIER)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_BARRIER,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 64,
      GIR_Done,
    // Label 210: @7880
    GIM_Try, /*On fail goto*//*Label 211*/ 7900, // Rule ID 575 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_dcache_inv,
      // (intrinsic_void 1061:{ *:[iPTR] })  =>  (S_DCACHE_INV)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_DCACHE_INV,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 575,
      GIR_Done,
    // Label 211: @7900
    GIM_Try, /*On fail goto*//*Label 212*/ 7920, // Rule ID 576 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_isGFX7GFX8GFX9,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_dcache_inv_vol,
      // (intrinsic_void 1062:{ *:[iPTR] })  =>  (S_DCACHE_INV_VOL)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_DCACHE_INV_VOL,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 576,
      GIR_Done,
    // Label 212: @7920
    GIM_Try, /*On fail goto*//*Label 213*/ 7940, // Rule ID 577 //
      GIM_CheckFeatures, GIFBS_HasScalarStores_TruePredicate_TruePredicate_isGFX8Plus,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_dcache_wb,
      // (intrinsic_void 1063:{ *:[iPTR] })  =>  (S_DCACHE_WB)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_DCACHE_WB,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 577,
      GIR_Done,
    // Label 213: @7940
    GIM_Try, /*On fail goto*//*Label 214*/ 7960, // Rule ID 578 //
      GIM_CheckFeatures, GIFBS_HasScalarStores_TruePredicate_TruePredicate_isGFX8Plus,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_dcache_wb_vol,
      // (intrinsic_void 1064:{ *:[iPTR] })  =>  (S_DCACHE_WB_VOL)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_DCACHE_WB_VOL,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 578,
      GIR_Done,
    // Label 214: @7960
    GIM_Try, /*On fail goto*//*Label 215*/ 7980, // Rule ID 693 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_isGFX6,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_buffer_wbinvl1_sc,
      // (intrinsic_void 475:{ *:[iPTR] })  =>  (BUFFER_WBINVL1_SC)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_WBINVL1_SC,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 693,
      GIR_Done,
    // Label 215: @7980
    GIM_Try, /*On fail goto*//*Label 216*/ 8000, // Rule ID 694 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_buffer_wbinvl1,
      // (intrinsic_void 474:{ *:[iPTR] })  =>  (BUFFER_WBINVL1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_WBINVL1,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 694,
      GIR_Done,
    // Label 216: @8000
    GIM_Try, /*On fail goto*//*Label 217*/ 8020, // Rule ID 695 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_isGFX7Plus,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_buffer_wbinvl1_vol,
      // (intrinsic_void 476:{ *:[iPTR] })  =>  (BUFFER_WBINVL1_VOL)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_WBINVL1_VOL,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 695,
      GIR_Done,
    // Label 217: @8020
    GIM_Try, /*On fail goto*//*Label 218*/ 8040, // Rule ID 708 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_wave_barrier,
      // (intrinsic_void 1112:{ *:[iPTR] })  =>  (WAVE_BARRIER)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::WAVE_BARRIER,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 708,
      GIR_Done,
    // Label 218: @8040
    GIM_Try, /*On fail goto*//*Label 219*/ 8060, // Rule ID 713 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_unreachable,
      // (intrinsic_void 1110:{ *:[iPTR] })  =>  (SI_MASKED_UNREACHABLE)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SI_MASKED_UNREACHABLE,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 713,
      GIR_Done,
    // Label 219: @8060
    GIM_Try, /*On fail goto*//*Label 220*/ 8322,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 221*/ 8105, // Rule ID 65 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_waitcnt,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_UIMM16bit,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 1075:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_UIMM16bit>>:$simm16)  =>  (S_WAITCNT (imm:{ *:[i32] }):$simm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_WAITCNT,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // simm16
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65,
        GIR_Done,
      // Label 221: @8105
      GIM_Try, /*On fail goto*//*Label 222*/ 8145, // Rule ID 66 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_sleep,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_SIMM16bit,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 1074:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_SIMM16bit>>:$simm16)  =>  (S_SLEEP (imm:{ *:[i32] }):$simm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_SLEEP,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // simm16
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 66,
        GIR_Done,
      // Label 222: @8145
      GIM_Try, /*On fail goto*//*Label 223*/ 8185, // Rule ID 69 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_incperflevel,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_SIMM16bit,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 1069:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_SIMM16bit>>:$simm16)  =>  (S_INCPERFLEVEL (imm:{ *:[i32] }):$simm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_INCPERFLEVEL,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // simm16
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 69,
        GIR_Done,
      // Label 223: @8185
      GIM_Try, /*On fail goto*//*Label 224*/ 8225, // Rule ID 70 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_decperflevel,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_SIMM16bit,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 1065:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_SIMM16bit>>:$simm16)  =>  (S_DECPERFLEVEL (imm:{ *:[i32] }):$simm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_DECPERFLEVEL,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // simm16
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 70,
        GIR_Done,
      // Label 224: @8225
      GIM_Try, /*On fail goto*//*Label 225*/ 8257, // Rule ID 574 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_s_memtime,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 1071:{ *:[iPTR] })  =>  (S_MEMTIME:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_MEMTIME,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 574,
        GIR_Done,
      // Label 225: @8257
      GIM_Try, /*On fail goto*//*Label 226*/ 8289, // Rule ID 579 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_isGFX8Plus,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_s_memrealtime,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 1070:{ *:[iPTR] })  =>  (S_MEMREALTIME:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_MEMREALTIME,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 579,
        GIR_Done,
      // Label 226: @8289
      GIM_Try, /*On fail goto*//*Label 227*/ 8321, // Rule ID 580 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_isGFX10Plus,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_s_get_waveid_in_workgroup,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 1066:{ *:[iPTR] })  =>  (S_GET_WAVEID_IN_WORKGROUP:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_GET_WAVEID_IN_WORKGROUP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 580,
        GIR_Done,
      // Label 227: @8321
      GIM_Reject,
    // Label 220: @8322
    GIM_Reject,
    // Label 11: @8323
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 230*/ 8379,
    /*GILLT_s16*//*Label 228*/ 8331,
    /*GILLT_s32*//*Label 229*/ 8355,
    // Label 228: @8331
    GIM_Try, /*On fail goto*//*Label 231*/ 8354, // Rule ID 2025 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i16] }):$imm  =>  (S_MOV_B32:{ *:[i16] } (imm:{ *:[i16] }):$imm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_MOV_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2025,
      GIR_Done,
    // Label 231: @8354
    GIM_Reject,
    // Label 229: @8355
    GIM_Try, /*On fail goto*//*Label 232*/ 8378, // Rule ID 1692 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i32] }):$imm  =>  (S_MOV_B32:{ *:[i32] } (imm:{ *:[i32] }):$imm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_MOV_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1692,
      GIR_Done,
    // Label 232: @8378
    GIM_Reject,
    // Label 230: @8379
    GIM_Reject,
    // Label 12: @8380
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 4, /*)*//*default:*//*Label 235*/ 8516,
    /*GILLT_s32*//*Label 233*/ 8388,
    /*GILLT_s64*//*Label 234*/ 8452,
    // Label 233: @8388
    GIM_Try, /*On fail goto*//*Label 236*/ 8451,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 237*/ 8424, // Rule ID 35 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_LSHL_B32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_LSHL_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 35,
        GIR_Done,
      // Label 237: @8424
      GIM_Try, /*On fail goto*//*Label 238*/ 8450, // Rule ID 450 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (shl:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_LSHLREV_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 450,
        GIR_Done,
      // Label 238: @8450
      GIM_Reject,
    // Label 236: @8451
    GIM_Reject,
    // Label 234: @8452
    GIM_Try, /*On fail goto*//*Label 239*/ 8515,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 240*/ 8488, // Rule ID 36 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (shl:{ *:[i64] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_LSHL_B64:{ *:[i64] }:{ *:[i1] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_LSHL_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 36,
        GIR_Done,
      // Label 240: @8488
      GIM_Try, /*On fail goto*//*Label 241*/ 8514, // Rule ID 516 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (shl:{ *:[i64] } i64:{ *:[i64] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_LSHLREV_B64:{ *:[i64] } i32:{ *:[i32] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 516,
        GIR_Done,
      // Label 241: @8514
      GIM_Reject,
    // Label 239: @8515
    GIM_Reject,
    // Label 235: @8516
    GIM_Reject,
    // Label 13: @8517
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 4, /*)*//*default:*//*Label 244*/ 8653,
    /*GILLT_s32*//*Label 242*/ 8525,
    /*GILLT_s64*//*Label 243*/ 8589,
    // Label 242: @8525
    GIM_Try, /*On fail goto*//*Label 245*/ 8588,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 246*/ 8561, // Rule ID 37 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (srl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_LSHR_B32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_LSHR_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 37,
        GIR_Done,
      // Label 246: @8561
      GIM_Try, /*On fail goto*//*Label 247*/ 8587, // Rule ID 448 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_LSHRREV_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHRREV_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 448,
        GIR_Done,
      // Label 247: @8587
      GIM_Reject,
    // Label 245: @8588
    GIM_Reject,
    // Label 243: @8589
    GIM_Try, /*On fail goto*//*Label 248*/ 8652,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 249*/ 8625, // Rule ID 38 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (srl:{ *:[i64] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_LSHR_B64:{ *:[i64] }:{ *:[i1] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_LSHR_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 38,
        GIR_Done,
      // Label 249: @8625
      GIM_Try, /*On fail goto*//*Label 250*/ 8651, // Rule ID 517 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (srl:{ *:[i64] } i64:{ *:[i64] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_LSHRREV_B64:{ *:[i64] } i32:{ *:[i32] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHRREV_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 517,
        GIR_Done,
      // Label 250: @8651
      GIM_Reject,
    // Label 248: @8652
    GIM_Reject,
    // Label 244: @8653
    GIM_Reject,
    // Label 14: @8654
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 4, /*)*//*default:*//*Label 253*/ 8790,
    /*GILLT_s32*//*Label 251*/ 8662,
    /*GILLT_s64*//*Label 252*/ 8726,
    // Label 251: @8662
    GIM_Try, /*On fail goto*//*Label 254*/ 8725,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 255*/ 8698, // Rule ID 39 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (sra:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_ASHR_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_ASHR_I32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 39,
        GIR_Done,
      // Label 255: @8698
      GIM_Try, /*On fail goto*//*Label 256*/ 8724, // Rule ID 449 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_ASHRREV_I32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ASHRREV_I32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 449,
        GIR_Done,
      // Label 256: @8724
      GIM_Reject,
    // Label 254: @8725
    GIM_Reject,
    // Label 252: @8726
    GIM_Try, /*On fail goto*//*Label 257*/ 8789,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 258*/ 8762, // Rule ID 40 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (sra:{ *:[i64] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_ASHR_I64:{ *:[i64] }:{ *:[i1] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_ASHR_I64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 40,
        GIR_Done,
      // Label 258: @8762
      GIM_Try, /*On fail goto*//*Label 259*/ 8788, // Rule ID 518 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (sra:{ *:[i64] } i64:{ *:[i64] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_ASHRREV_I64:{ *:[i64] } i32:{ *:[i32] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ASHRREV_I64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 518,
        GIR_Done,
      // Label 259: @8788
      GIM_Reject,
    // Label 257: @8789
    GIM_Reject,
    // Label 253: @8790
    GIM_Reject,
    // Label 15: @8791
    GIM_Try, /*On fail goto*//*Label 260*/ 8819, // Rule ID 488 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (mulhu:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MUL_HI_U32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MUL_HI_U32,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 488,
      GIR_Done,
    // Label 260: @8819
    GIM_Reject,
    // Label 16: @8820
    GIM_Try, /*On fail goto*//*Label 261*/ 8848, // Rule ID 489 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (mulhs:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MUL_HI_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MUL_HI_I32,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 489,
      GIR_Done,
    // Label 261: @8848
    GIM_Reject,
    // Label 17: @8849
    GIM_Try, /*On fail goto*//*Label 262*/ 8921, // Rule ID 1703 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (fpow:{ *:[f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1)  =>  (V_EXP_F32_e32:{ *:[f32] } (V_MUL_LEGACY_F32_e32:{ *:[i16] } f32:{ *:[f32] }:$src1, (V_LOG_F32_e32:{ *:[i16] } f32:{ *:[f32] }:$src0)))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_LOG_F32_e32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_MUL_LEGACY_F32_e32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // src1
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_EXP_F32_e32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1703,
      GIR_Done,
    // Label 262: @8921
    GIM_Reject,
    // Label 18: @8922
    GIM_Try, /*On fail goto*//*Label 263*/ 8950, // Rule ID 441 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (smin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MIN_I32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MIN_I32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 441,
      GIR_Done,
    // Label 263: @8950
    GIM_Reject,
    // Label 19: @8951
    GIM_Try, /*On fail goto*//*Label 264*/ 8979, // Rule ID 443 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (smax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MAX_I32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MAX_I32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 443,
      GIR_Done,
    // Label 264: @8979
    GIM_Reject,
    // Label 20: @8980
    GIM_Try, /*On fail goto*//*Label 265*/ 9008, // Rule ID 445 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MIN_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MIN_U32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 445,
      GIR_Done,
    // Label 265: @9008
    GIM_Reject,
    // Label 21: @9009
    GIM_Try, /*On fail goto*//*Label 266*/ 9037, // Rule ID 447 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MAX_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MAX_U32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 447,
      GIR_Done,
    // Label 266: @9037
    GIM_Reject,
    // Label 22: @9038
    GIM_Try, /*On fail goto*//*Label 267*/ 9066,
      GIM_CheckIsMBB, /*MI*/0, /*Op*/0,
      GIM_Try, /*On fail goto*//*Label 268*/ 9054, // Rule ID 62 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        // (br (bb:{ *:[Other] }):$simm16)  =>  (S_BRANCH (bb:{ *:[Other] }):$simm16)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_BRANCH,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62,
        GIR_Done,
      // Label 268: @9054
      GIM_Try, /*On fail goto*//*Label 269*/ 9065, // Rule ID 63 //
        GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
        // (br (bb:{ *:[Other] }):$simm16)  =>  (S_BRANCH_pad_s_nop (bb:{ *:[Other] }):$simm16)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_BRANCH_pad_s_nop,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63,
        GIR_Done,
      // Label 269: @9065
      GIM_Reject,
    // Label 267: @9066
    GIM_Reject,
    // Label 23: @9067
    GIM_Try, /*On fail goto*//*Label 270*/ 9093, // Rule ID 3 //
      GIM_CheckFeatures, GIFBS_TruePredicate_TruePredicate_TruePredicate,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      // (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0)  =>  (S_BCNT1_I32_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_BCNT1_I32_B32,
      GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3,
      GIR_Done,
    // Label 270: @9093
    GIM_Reject,
    // Label 24: @9094
    GIM_Reject,
    };
  return MatchTable0;
}
#endif // ifdef GET_GLOBALISEL_IMPL
#ifdef GET_GLOBALISEL_PREDICATES_DECL
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
#endif // ifdef GET_GLOBALISEL_PREDICATES_DECL
#ifdef GET_GLOBALISEL_PREDICATES_INIT
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GLOBALISEL_PREDICATES_INIT
