/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.Lockable;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

class FileCachePendingFiles
extends Lockable {
    private final Set<Path> pendingFiles = new HashSet<Path>();

    FileCachePendingFiles(ReentrantLock reentrantLock) {
        super(reentrantLock);
    }

    void clear() {
        if (this.lock()) {
            try {
                this.pendingFiles.clear();
            }
            finally {
                this.unlock();
            }
        }
    }

    boolean add(Path path) {
        if (this.lock()) {
            try {
                boolean bl = this.pendingFiles.add(path);
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    boolean contains(Path path) {
        if (this.lock()) {
            try {
                boolean bl = this.pendingFiles.contains(path);
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    boolean remove(Path path) {
        if (this.lock()) {
            try {
                boolean bl = this.pendingFiles.remove(path);
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }
}

