"""Stub file for the 'signal' module."""

import sys
from enum import IntEnum
from typing import Any, Callable, List, Tuple, Dict, Generic, Union, Optional, Iterable, Set
from types import FrameType

class ItimerError(IOError): ...

ITIMER_PROF: int = ...
ITIMER_REAL: int = ...
ITIMER_VIRTUAL: int = ...

NSIG: int = ...

if sys.version_info >= (3, 5):
    class Signals(IntEnum):
        SIGABRT = ...
        SIGALRM = ...
        SIGBREAK = ...  # Windows
        SIGBUS = ...
        SIGCHLD = ...
        SIGCLD = ...
        SIGCONT = ...
        SIGEMT = ...
        SIGFPE = ...
        SIGHUP = ...
        SIGILL = ...
        SIGINFO = ...
        SIGINT = ...
        SIGIO = ...
        SIGIOT = ...
        SIGKILL = ...
        SIGPIPE = ...
        SIGPOLL = ...
        SIGPROF = ...
        SIGPWR = ...
        SIGQUIT = ...
        SIGRTMAX = ...
        SIGRTMIN = ...
        SIGSEGV = ...
        SIGSTOP = ...
        SIGSYS = ...
        SIGTERM = ...
        SIGTRAP = ...
        SIGTSTP = ...
        SIGTTIN = ...
        SIGTTOU = ...
        SIGURG = ...
        SIGUSR1 = ...
        SIGUSR2 = ...
        SIGVTALRM = ...
        SIGWINCH = ...
        SIGXCPU = ...
        SIGXFSZ = ...

    class Handlers(IntEnum):
        SIG_DFL = ...
        SIG_IGN = ...

    SIG_DFL = Handlers.SIG_DFL
    SIG_IGN = Handlers.SIG_IGN

    class Sigmasks(IntEnum):
        SIG_BLOCK = ...
        SIG_UNBLOCK = ...
        SIG_SETMASK = ...

    SIG_BLOCK = Sigmasks.SIG_BLOCK
    SIG_UNBLOCK = Sigmasks.SIG_UNBLOCK
    SIG_SETMASK = Sigmasks.SIG_SETMASK

    _SIG = Signals
    _SIGNUM = Union[int, Signals]
    _HANDLER = Union[Callable[[Signals, FrameType], None], int, Handlers, None]
else:
    SIG_DFL: int = ...
    SIG_IGN: int = ...

    SIG_BLOCK: int = ...
    SIG_UNBLOCK: int = ...
    SIG_SETMASK: int = ...

    _SIG = int
    _SIGNUM = int
    _HANDLER = Union[Callable[[int, FrameType], None], int, None]

SIGABRT: _SIG = ...
SIGALRM: _SIG = ...
SIGBREAK: _SIG = ...  # Windows
SIGBUS: _SIG = ...
SIGCHLD: _SIG = ...
SIGCLD: _SIG = ...
SIGCONT: _SIG = ...
SIGEMT: _SIG = ...
SIGFPE: _SIG = ...
SIGHUP: _SIG = ...
SIGILL: _SIG = ...
SIGINFO: _SIG = ...
SIGINT: _SIG = ...
SIGIO: _SIG = ...
SIGIOT: _SIG = ...
SIGKILL: _SIG = ...
SIGPIPE: _SIG = ...
SIGPOLL: _SIG = ...
SIGPROF: _SIG = ...
SIGPWR: _SIG = ...
SIGQUIT: _SIG = ...
SIGRTMAX: _SIG = ...
SIGRTMIN: _SIG = ...
SIGSEGV: _SIG = ...
SIGSTOP: _SIG = ...
SIGSYS: _SIG = ...
SIGTERM: _SIG = ...
SIGTRAP: _SIG = ...
SIGTSTP: _SIG = ...
SIGTTIN: _SIG = ...
SIGTTOU: _SIG = ...
SIGURG: _SIG = ...
SIGUSR1: _SIG = ...
SIGUSR2: _SIG = ...
SIGVTALRM: _SIG = ...
SIGWINCH: _SIG = ...
SIGXCPU: _SIG = ...
SIGXFSZ: _SIG = ...

# Windows
CTRL_C_EVENT: _SIG = ...
CTRL_BREAK_EVENT: _SIG = ...

class struct_siginfo(Tuple[int, int, int, int, int, int, int]):
    def __init__(self, sequence: Iterable[int]) -> None: ...
    @property
    def si_signo(self) -> int: ...
    @property
    def si_code(self) -> int: ...
    @property
    def si_errno(self) -> int: ...
    @property
    def si_pid(self) -> int: ...
    @property
    def si_uid(self) -> int: ...
    @property
    def si_status(self) -> int: ...
    @property
    def si_band(self) -> int: ...

def alarm(time: int) -> int: ...

def default_int_handler(signum: int, frame: FrameType) -> None:
    raise KeyboardInterrupt()

def getitimer(which: int) -> Tuple[float, float]: ...

def getsignal(signalnum: _SIGNUM) -> _HANDLER:
    raise ValueError()

def pause() -> None: ...

def pthread_kill(thread_id: int, signum: int) -> None:
    raise OSError()

def pthread_sigmask(how: int, mask: Iterable[int]) -> Set[_SIGNUM]:
    raise OSError()

def set_wakeup_fd(fd: int) -> int: ...

def setitimer(which: int, seconds: float, interval: float = ...) -> Tuple[float, float]: ...

def siginterrupt(signalnum: int, flag: bool) -> None:
    raise OSError()

def signal(signalnum: _SIGNUM, handler: _HANDLER) -> _HANDLER:
    raise OSError()

def sigpending() -> Any:
    raise OSError()

def sigtimedwait(sigset: Iterable[int], timeout: float) -> Optional[struct_siginfo]:
    raise OSError()
    raise ValueError()

def sigwait(sigset: Iterable[int]) -> _SIGNUM:
    raise OSError()

def sigwaitinfo(sigset: Iterable[int]) -> struct_siginfo:
    raise OSError()
