/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TransferableList<T>
implements Transferable {
    private static final DataFlavor LIST_DATA_FLAVOR = new DataFlavor(List.class, "Transferable List");
    private static final DataFlavor ALL_HTML_DATA_FLAVOR = DataFlavor.allHtmlFlavor;
    private static final DataFlavor PART_HTML_DATA_FLAVOR = DataFlavor.fragmentHtmlFlavor;
    private final List<T> myList;

    @SafeVarargs
    public TransferableList(T ... array) {
        if (array == null) {
            TransferableList.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(array));
    }

    public TransferableList(List<? extends T> list2) {
        this.myList = Collections.unmodifiableList(list2);
    }

    @Override
    @NotNull
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{ALL_HTML_DATA_FLAVOR, PART_HTML_DATA_FLAVOR, DataFlavor.stringFlavor, LIST_DATA_FLAVOR};
        if (dataFlavorArray == null) {
            TransferableList.$$$reportNull$$$0(1);
        }
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor supported : this.getTransferDataFlavors()) {
            if (!supported.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(ALL_HTML_DATA_FLAVOR)) {
            return this.getHTML(this.myList, true);
        }
        if (flavor.equals(PART_HTML_DATA_FLAVOR)) {
            return this.getHTML(this.myList, false);
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.getText(this.myList);
        }
        if (flavor.equals(LIST_DATA_FLAVOR)) {
            return this.myList;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected String getHTML(List<? extends T> list2, boolean all) {
        StringBuilder sb = new StringBuilder();
        if (all) {
            sb.append("<html><body>");
        }
        sb.append("<ul>\n");
        for (T object : list2) {
            sb.append("  <li>").append(this.toHTML(object)).append("</li>\n");
        }
        sb.append("</ul>");
        if (all) {
            sb.append("</body></html>");
        }
        return sb.toString();
    }

    protected String getText(List<? extends T> list2) {
        StringBuilder sb = new StringBuilder();
        for (T object : list2) {
            sb.append(this.toString(object)).append('\n');
        }
        return sb.toString();
    }

    protected String toHTML(T object) {
        return this.toString(object);
    }

    protected abstract String toString(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/TransferableList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/TransferableList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransferDataFlavors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

