/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.highlighting.BraceHighlighter;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.IntIntFunction;
import com.intellij.util.Processor;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BraceHighlightingHandler {
    private static final Key<List<RangeHighlighter>> BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY = Key.create((String)"BraceHighlighter.BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY");
    private static final Key<RangeHighlighter> LINE_MARKER_IN_EDITOR_KEY = Key.create((String)"BraceHighlighter.LINE_MARKER_IN_EDITOR_KEY");
    private static final Key<LightweightHint> HINT_IN_EDITOR_KEY = Key.create((String)"BraceHighlighter.HINT_IN_EDITOR_KEY");
    private static final Key<Boolean> PROCESSED = Key.create((String)"BraceHighlighter.PROCESSED");
    static final int LAYER = 6001;
    @NotNull
    private final Project myProject;
    @NotNull
    private final EditorEx myEditor;
    private final Alarm myAlarm;
    private final DocumentEx myDocument;
    private final PsiFile myPsiFile;
    private final CodeInsightSettings myCodeInsightSettings;

    BraceHighlightingHandler(@NotNull Project project, @NotNull EditorEx editor, @NotNull Alarm alarm, PsiFile psiFile) {
        if (project == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(1);
        }
        if (alarm == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myAlarm = alarm;
        this.myDocument = this.myEditor.getDocument();
        this.myPsiFile = psiFile;
        this.myCodeInsightSettings = CodeInsightSettings.getInstance();
    }

    static void lookForInjectedAndMatchBracesInOtherThread(@NotNull Editor editor, @NotNull Alarm alarm, @NotNull Processor<? super BraceHighlightingHandler> processor2) {
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(3);
        }
        if (alarm == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(5);
        }
        Application app = ApplicationManager.getApplication();
        app.assertIsDispatchThread();
        if (!BraceHighlightingHandler.isValidEditor(editor)) {
            return;
        }
        if (editor.getUserData(PROCESSED) != null) {
            return;
        }
        editor.putUserData(PROCESSED, (Object)Boolean.TRUE);
        ModalityState modalityState = ModalityState.stateForComponent((Component)editor.getComponent());
        int offset = editor.getCaretModel().getOffset();
        app.executeOnPooledThread(() -> {
            boolean success = ((ApplicationEx)app).tryRunReadAction(() -> {
                try {
                    ((ApplicationImpl)app).executeByImpatientReader(() -> {
                        if (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                            if (!BraceHighlightingHandler.isValidEditor(editor)) {
                                BraceHighlightingHandler.removeFromProcessedLater(editor);
                                return;
                            }
                            Project project = editor.getProject();
                            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
                            PsiFile injected = psiFile instanceof PsiBinaryFile || !BraceHighlightingHandler.isValidFile(psiFile) ? null : BraceHighlightingHandler.getInjectedFileIfAny(editor, project, offset, psiFile, alarm);
                            app.invokeLater(() -> {
                                try {
                                    if (BraceHighlightingHandler.isValidEditor(editor) && BraceHighlightingHandler.isValidFile(injected)) {
                                        EditorEx newEditor = (EditorEx)InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injected);
                                        BraceHighlightingHandler handler2 = new BraceHighlightingHandler(project, newEditor, alarm, injected);
                                        processor2.process((Object)handler2);
                                    }
                                }
                                finally {
                                    editor.putUserData(PROCESSED, null);
                                }
                            }, modalityState);
                        })) {
                            BraceHighlightingHandler.removeFromProcessedLater(editor);
                        }
                    });
                }
                catch (Exception e) {
                    BraceHighlightingHandler.removeFromProcessedLater(editor);
                    throw e;
                }
            });
            if (!success) {
                BraceHighlightingHandler.restartLater(editor, modalityState, alarm, processor2);
            }
        });
    }

    private static void restartLater(@NotNull Editor editor, @NotNull ModalityState modalityState, @NotNull Alarm alarm, @NotNull Processor<? super BraceHighlightingHandler> processor2) {
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(6);
        }
        if (modalityState == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(7);
        }
        if (alarm == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            editor.putUserData(PROCESSED, null);
            BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, alarm, processor2);
        }, modalityState);
    }

    private static void removeFromProcessedLater(@NotNull Editor editor) {
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().invokeLater(() -> editor.putUserData(PROCESSED, null));
    }

    private static boolean isValidFile(PsiFile file2) {
        return file2 != null && file2.isValid() && !file2.getProject().isDisposed();
    }

    private static boolean isValidEditor(@NotNull Editor editor) {
        Project editorProject;
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(11);
        }
        return (editorProject = editor.getProject()) != null && !editorProject.isDisposed() && !editor.isDisposed() && editor.getComponent().isShowing() && !editor.isViewer();
    }

    @NotNull
    private static PsiFile getInjectedFileIfAny(@NotNull Editor editor, @NotNull Project project, int offset, @NotNull PsiFile psiFile, @NotNull Alarm alarm) {
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(12);
        }
        if (project == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(13);
        }
        if (psiFile == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(14);
        }
        if (alarm == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(15);
        }
        Document document = editor.getDocument();
        if (PsiDocumentManager.getInstance((Project)project).isCommitted(document)) {
            PsiFile injected;
            PsiElement injectedElement = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).findInjectedElementAt(psiFile, offset);
            if (injectedElement != null && (injected = injectedElement.getContainingFile()) != null) {
                PsiFile psiFile2 = injected;
                if (psiFile2 == null) {
                    BraceHighlightingHandler.$$$reportNull$$$0(16);
                }
                return psiFile2;
            }
        } else {
            PsiDocumentManager.getInstance((Project)project).performForCommittedDocument(document, () -> {
                if (!project.isDisposed() && !editor.isDisposed()) {
                    BraceHighlighter.updateBraces(editor, alarm);
                }
            });
        }
        PsiFile psiFile3 = psiFile;
        if (psiFile3 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(17);
        }
        return psiFile3;
    }

    @NotNull
    public static EditorHighlighter getLazyParsableHighlighterIfAny(Project project, Editor editor, PsiFile psiFile) {
        if (!PsiDocumentManager.getInstance((Project)project).isCommitted(editor.getDocument())) {
            EditorHighlighter editorHighlighter = ((EditorEx)editor).getHighlighter();
            if (editorHighlighter == null) {
                BraceHighlightingHandler.$$$reportNull$$$0(18);
            }
            return editorHighlighter;
        }
        PsiElement elementAt = psiFile.findElementAt(editor.getCaretModel().getOffset());
        for (PsiElement e : SyntaxTraverser.psiApi().parents((Object)elementAt).takeWhile(Conditions.notEqualTo((Object)psiFile))) {
            Language language;
            if (!(PsiUtilCore.getElementType((PsiElement)e) instanceof ILazyParseableElementType) || (language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)e.getNode())) == null) continue;
            TextRange range2 = e.getTextRange();
            final int offset = range2.getStartOffset();
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)psiFile.getVirtualFile());
            LexerEditorHighlighter highlighter = new LexerEditorHighlighter(syntaxHighlighter, editor.getColorsScheme()){

                @Override
                @NotNull
                public HighlighterIterator createIterator(int startOffset) {
                    HighlighterIteratorWrapper highlighterIteratorWrapper = new HighlighterIteratorWrapper(super.createIterator(Math.max(startOffset - offset, 0))){

                        @Override
                        public int getStart() {
                            return super.getStart() + offset;
                        }

                        @Override
                        public int getEnd() {
                            return super.getEnd() + offset;
                        }
                    };
                    if (highlighterIteratorWrapper == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return highlighterIteratorWrapper;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler$1", "createIterator"));
                }
            };
            highlighter.setText(editor.getDocument().getText(range2));
            LexerEditorHighlighter lexerEditorHighlighter = highlighter;
            if (lexerEditorHighlighter == null) {
                BraceHighlightingHandler.$$$reportNull$$$0(19);
            }
            return lexerEditorHighlighter;
        }
        EditorHighlighter editorHighlighter = ((EditorEx)editor).getHighlighter();
        if (editorHighlighter == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(20);
        }
        return editorHighlighter;
    }

    void updateBraces() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.clearBraceHighlighters();
        if (this.myPsiFile == null || !this.myPsiFile.isValid()) {
            return;
        }
        if (!this.myCodeInsightSettings.HIGHLIGHT_BRACES) {
            return;
        }
        if (this.myEditor.getSelectionModel().hasSelection()) {
            return;
        }
        if (this.myEditor.getSoftWrapModel().isInsideOrBeforeSoftWrap(this.myEditor.getCaretModel().getVisualPosition())) {
            return;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        this.myAlarm.cancelAllRequests();
        BraceMatchingUtil.BraceHighlightingAndNavigationContext context = BraceMatchingUtil.computeHighlightingAndNavigationContext(this.myEditor, this.myPsiFile);
        if (context != null) {
            this.doHighlight(context.currentBraceOffset);
            offset = context.currentBraceOffset;
        } else if (offset > 0 && offset < chars.length()) {
            int nextNonSpaceCharOffset;
            char c2 = chars.charAt(offset);
            boolean searchForward = c2 != '\n';
            int backwardNonSpaceEndOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\t ") + 1;
            if (backwardNonSpaceEndOffset > 0 && backwardNonSpaceEndOffset < offset && (context = BraceMatchingUtil.computeHighlightingAndNavigationContext(this.myEditor, this.myPsiFile, backwardNonSpaceEndOffset)) != null) {
                this.doHighlight(context.currentBraceOffset);
                offset = context.currentBraceOffset;
                searchForward = false;
            }
            if (searchForward && (nextNonSpaceCharOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)"\t ")) > offset && (context = BraceMatchingUtil.computeHighlightingAndNavigationContext(this.myEditor, this.myPsiFile, nextNonSpaceCharOffset)) != null) {
                this.doHighlight(context.currentBraceOffset);
                offset = context.currentBraceOffset;
            }
        }
        if (this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            this.highlightScope(offset);
        }
    }

    @NotNull
    private FileType getFileTypeByOffset(int offset) {
        FileType fileType = PsiUtilBase.getPsiFileAtOffset((PsiFile)this.myPsiFile, (int)offset).getFileType();
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(21);
        }
        return fileType;
    }

    @NotNull
    private EditorHighlighter getEditorHighlighter() {
        EditorHighlighter editorHighlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny(this.myProject, this.myEditor, this.myPsiFile);
        if (editorHighlighter == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(22);
        }
        return editorHighlighter;
    }

    private void highlightScope(int offset) {
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        if (this.myEditor.getDocument().getTextLength() <= offset) {
            return;
        }
        HighlighterIterator iterator = this.getEditorHighlighter().createIterator(offset);
        CharSequence chars = this.myDocument.getCharsSequence();
        FileType fileType = this.getFileTypeByOffset(offset);
        if ((!BraceMatchingUtil.isStructuralBraceToken(fileType, iterator, chars) || !BraceMatchingUtil.isRBraceToken(iterator, chars, fileType) && !BraceMatchingUtil.isLBraceToken(iterator, chars, fileType)) && BraceMatchingUtil.findStructuralLeftBrace(fileType, iterator, chars)) {
            this.highlightLeftBrace(iterator, true, fileType);
        }
    }

    private void doHighlight(int offset) {
        FileType fileType;
        CharSequence chars;
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        HighlighterIterator iterator = this.getEditorHighlighter().createIterator(offset);
        if (BraceMatchingUtil.isLBraceToken(iterator, chars = this.myDocument.getCharsSequence(), fileType = this.getFileTypeByOffset(offset))) {
            this.highlightLeftBrace(iterator, false, fileType);
            if (offset > 0 && BraceMatchingUtil.isRBraceToken(iterator = this.getEditorHighlighter().createIterator(offset - 1), chars, fileType)) {
                this.highlightRightBrace(iterator, fileType);
            }
        } else if (BraceMatchingUtil.isRBraceToken(iterator, chars, fileType)) {
            this.highlightRightBrace(iterator, fileType);
        }
    }

    private void highlightRightBrace(@NotNull HighlighterIterator iterator, @NotNull FileType fileType) {
        if (iterator == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(23);
        }
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(24);
        }
        TextRange brace1 = TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), fileType, iterator, false);
        TextRange brace2 = iterator.atEnd() ? null : TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        this.highlightBraces(brace2, brace1, matched, false, fileType);
    }

    private void highlightLeftBrace(@NotNull HighlighterIterator iterator, boolean scopeHighlighting, @NotNull FileType fileType) {
        if (iterator == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(25);
        }
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(26);
        }
        TextRange brace1Start = TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), fileType, iterator, true);
        TextRange brace2End = iterator.atEnd() ? null : TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        this.highlightBraces(brace1Start, brace2End, matched, scopeHighlighting, fileType);
    }

    private void highlightBraces(@Nullable TextRange lBrace, @Nullable TextRange rBrace, boolean matched, boolean scopeHighlighting, @NotNull FileType fileType) {
        FileEditorManager fileEditorManager;
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(27);
        }
        if (!matched && fileType == FileTypes.PLAIN_TEXT) {
            return;
        }
        if (rBrace != null && !scopeHighlighting) {
            this.highlightBrace(rBrace, matched);
        }
        if (lBrace != null && !scopeHighlighting) {
            this.highlightBrace(lBrace, matched);
        }
        if ((fileEditorManager = FileEditorManager.getInstance((Project)this.myProject)) == null || !this.myEditor.equals(fileEditorManager.getSelectedTextEditor())) {
            return;
        }
        if (lBrace != null && rBrace != null) {
            int endLine = this.myEditor.offsetToLogicalPosition((int)rBrace.getEndOffset()).line;
            int startLine = this.myEditor.offsetToLogicalPosition((int)lBrace.getStartOffset()).line;
            if (endLine - startLine > 0) {
                BraceHighlightingHandler.lineMarkFragment(this.myEditor, this.myDocument, startLine, endLine, matched);
            }
            if (!scopeHighlighting) {
                this.showScopeHint(lBrace.getStartOffset(), lBrace.getEndOffset());
            }
        }
    }

    private void highlightBrace(@NotNull TextRange braceRange, boolean matched) {
        if (braceRange == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(28);
        }
        EditorColorsScheme scheme = this.myEditor.getColorsScheme();
        TextAttributes attributes = matched ? scheme.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES) : scheme.getAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        RangeHighlighter rbraceHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(braceRange.getStartOffset(), braceRange.getEndOffset(), 6001, attributes, HighlighterTargetArea.EXACT_RANGE);
        rbraceHighlighter.setGreedyToLeft(false);
        rbraceHighlighter.setGreedyToRight(false);
        this.registerHighlighter(rbraceHighlighter);
    }

    private void registerHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(29);
        }
        this.getHighlightersList().add(highlighter);
    }

    @NotNull
    private List<RangeHighlighter> getHighlightersList() {
        EditorEx editor = this.myEditor instanceof EditorWindow ? ((EditorWindow)((Object)this.myEditor)).getDelegate() : this.myEditor;
        ArrayList<RangeHighlighter> highlighters = (ArrayList<RangeHighlighter>)editor.getUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY);
        if (highlighters == null) {
            highlighters = new ArrayList<RangeHighlighter>();
            editor.putUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY, highlighters);
        }
        ArrayList<RangeHighlighter> arrayList = highlighters;
        if (arrayList == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    private void showScopeHint(int lbraceStart, int lbraceEnd) {
        BraceHighlightingHandler.showScopeHint(this.myEditor, this.myAlarm, lbraceStart, lbraceEnd, it -> {
            if (!(this.myPsiFile instanceof PsiPlainTextFile) && this.myPsiFile.isValid()) {
                return BraceMatchingUtil.getBraceMatcher(this.getFileTypeByOffset(it), PsiUtilCore.getLanguageAtOffset((PsiFile)this.myPsiFile, (int)it)).getCodeConstructStart(this.myPsiFile, it);
            }
            return it;
        });
    }

    public static void showScopeHint(@NotNull Editor editor, @NotNull Alarm alarm, int leftBraceStart, int leftBraceEnd, @Nullable IntIntFunction startComputation) {
        Project project;
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(31);
        }
        if (alarm == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(32);
        }
        if ((project = editor.getProject()) == null) {
            return;
        }
        LogicalPosition bracePosition = editor.offsetToLogicalPosition(leftBraceStart);
        Point braceLocation = editor.logicalPositionToXY(bracePosition);
        int y = braceLocation.y;
        alarm.addRequest(() -> ReadAction.run(() -> {
            if (project.isDisposed()) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).performLaterWhenAllCommitted(() -> {
                if (editor.isDisposed() || !editor.getComponent().isShowing()) {
                    return;
                }
                Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
                if (y >= viewRect.y) {
                    return;
                }
                TextRange range2 = new TextRange(startComputation == null ? leftBraceStart : startComputation.fun(leftBraceStart), leftBraceEnd);
                Document document = editor.getDocument();
                int line1 = document.getLineNumber(range2.getStartOffset());
                int line2 = document.getLineNumber(range2.getEndOffset());
                line1 = Math.max(line1, line2 - EditorFragmentComponent.getAvailableVisualLinesAboveEditor(editor) + 1);
                range2 = new TextRange(document.getLineStartOffset(line1), range2.getEndOffset());
                LightweightHint hint = EditorFragmentComponent.showEditorFragmentHint(editor, range2, true, true);
                editor.putUserData(HINT_IN_EDITOR_KEY, (Object)hint);
            });
        }), 300, ModalityState.stateForComponent((Component)editor.getComponent()));
    }

    void clearBraceHighlighters() {
        List<RangeHighlighter> highlighters = this.getHighlightersList();
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
        LightweightHint hint = (LightweightHint)this.myEditor.getUserData(HINT_IN_EDITOR_KEY);
        if (hint != null) {
            hint.hide();
            this.myEditor.putUserData(HINT_IN_EDITOR_KEY, null);
        }
        BraceHighlightingHandler.removeLineMarkers(this.myEditor);
    }

    public static void lineMarkFragment(@NotNull EditorEx editor, @NotNull Document document, int startLine, int endLine, boolean matched) {
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(33);
        }
        if (document == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(34);
        }
        BraceHighlightingHandler.removeLineMarkers(editor);
        if (startLine >= endLine || endLine >= document.getLineCount()) {
            return;
        }
        int startOffset = document.getLineStartOffset(startLine);
        int endOffset = document.getLineEndOffset(endLine);
        LineMarkerRenderer renderer2 = BraceHighlightingHandler.createLineMarkerRenderer(matched);
        if (renderer2 == null) {
            return;
        }
        RangeHighlighterEx highlighter = editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(startOffset, endOffset, 0, null, HighlighterTargetArea.LINES_IN_RANGE, false, (Consumer<? super RangeHighlighterEx>)((Consumer)h -> h.setLineMarkerRenderer(renderer2)));
        editor.putUserData(LINE_MARKER_IN_EDITOR_KEY, highlighter);
    }

    private static void removeLineMarkers(@NotNull EditorEx editor) {
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighter marker = (RangeHighlighter)editor.getUserData(LINE_MARKER_IN_EDITOR_KEY);
        if (marker != null && editor.getMarkupModel().containsHighlighter(marker)) {
            marker.dispose();
        }
        editor.putUserData(LINE_MARKER_IN_EDITOR_KEY, null);
    }

    @Nullable
    public static LineMarkerRenderer createLineMarkerRenderer(boolean matched) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = matched ? scheme.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES) : scheme.getAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        Color color = attributes.getBackgroundColor();
        if (color == null) {
            return null;
        }
        color = ColorUtil.isDark((Color)scheme.getDefaultBackground()) ? ColorUtil.shift((Color)color, (double)1.5) : color.darker();
        return new MyLineMarkerRenderer(color);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 15: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alarm";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/BraceHighlightingHandler";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "braceRange";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BraceHighlightingHandler";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedFileIfAny";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyParsableHighlighterIfAny";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByOffset";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorHighlighter";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightersList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lookForInjectedAndMatchBracesInOtherThread";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restartLater";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeFromProcessedLater";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidEditor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedFileIfAny";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "highlightRightBrace";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "highlightLeftBrace";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "highlightBraces";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "highlightBrace";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlighter";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "showScopeHint";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lineMarkFragment";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeLineMarkers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLineMarkerRenderer
    implements LineMarkerRenderer {
        private static final int DEEPNESS = 0;
        private static final int THICKNESS = 1;
        private final Color myColor;

        private MyLineMarkerRenderer(@NotNull Color color) {
            if (color == null) {
                MyLineMarkerRenderer.$$$reportNull$$$0(0);
            }
            this.myColor = color;
        }

        public void paint(Editor editor, Graphics g, Rectangle r) {
            g.setColor(this.myColor);
            g.fillRect(r.x, r.y, 1, r.height);
            g.fillRect(r.x + 1, r.y, 0, 1);
            g.fillRect(r.x + 1, r.y + r.height - 1, 0, 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler$MyLineMarkerRenderer", "<init>"));
        }
    }
}

