/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import javax.swing.text.Segment;
import processing.app.syntax.Token;
import processing.app.syntax.TokenMarker;

public class TokenMarkerState {
    protected TokenMarker marker;
    protected Token firstToken;
    protected Token lastToken;
    protected byte[] lineInfo;
    protected int length;
    protected int lastLine = -1;
    protected boolean nextLineRequested;

    protected TokenMarkerState(TokenMarker marker) {
        this.marker = marker;
    }

    public Token markTokens(Segment line, int lineIndex) {
        if (lineIndex >= this.length) {
            throw new IllegalArgumentException("Tokenizing invalid line: " + lineIndex);
        }
        this.marker.setTokenListener(this::addToken);
        this.lastToken = null;
        byte prev = lineIndex == 0 ? (byte)0 : this.lineInfo[lineIndex - 1];
        byte oldToken = this.lineInfo[lineIndex];
        byte token = this.marker.markTokensImpl(prev, line, lineIndex);
        this.marker.setTokenListener(null);
        this.lineInfo[lineIndex] = token;
        if (this.lastLine != lineIndex || !this.nextLineRequested) {
            this.nextLineRequested = oldToken != token;
        }
        this.lastLine = lineIndex;
        this.addToken(0, (byte)127);
        return this.firstToken;
    }

    public void insertLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        this.length += lines;
        this.ensureCapacity(this.length);
        int len = index + lines;
        System.arraycopy(this.lineInfo, index, this.lineInfo, len, this.lineInfo.length - len);
        int i = index + lines - 1;
        while (i >= index) {
            this.lineInfo[i] = 0;
            --i;
        }
    }

    public void deleteLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        int len = index + lines;
        this.length -= lines;
        System.arraycopy(this.lineInfo, len, this.lineInfo, index, this.lineInfo.length - len);
    }

    public int getLineCount() {
        return this.length;
    }

    public boolean isNextLineRequested() {
        return this.nextLineRequested;
    }

    protected void ensureCapacity(int index) {
        if (this.lineInfo == null) {
            this.lineInfo = new byte[index + 1];
        } else if (this.lineInfo.length <= index) {
            byte[] lineInfoN = new byte[(index + 1) * 2];
            System.arraycopy(this.lineInfo, 0, lineInfoN, 0, this.lineInfo.length);
            this.lineInfo = lineInfoN;
        }
    }

    protected void addToken(int length, byte id) {
        if (id >= 100 && id <= 126) {
            throw new InternalError("Invalid id: " + id);
        }
        if (length == 0 && id != 127) {
            return;
        }
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = new Token(length, id);
        } else if (this.lastToken == null) {
            this.lastToken = this.firstToken;
            this.firstToken.length = length;
            this.firstToken.id = id;
        } else if (this.lastToken.next == null) {
            this.lastToken = this.lastToken.next = new Token(length, id);
        } else {
            this.lastToken = this.lastToken.next;
            this.lastToken.length = length;
            this.lastToken.id = id;
        }
    }
}

