/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.Exception;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Exception"})
public class RubyException
extends RubyObject {
    public static final int TRACE_HEAD = 8;
    public static final int TRACE_TAIL = 4;
    public static final int TRACE_MAX = 18;
    public static final String[] FULL_MESSAGE_KEYS = new String[]{"highlight", "order"};
    private final Backtrace backtrace = new Backtrace();
    IRubyObject message;
    private IRubyObject cause = null;
    private RaiseException throwable;
    public static ObjectAllocator EXCEPTION_ALLOCATOR = (runtime2, klass) -> new RubyException(runtime2, klass);
    private static final ObjectMarshal<RubyException> EXCEPTION_MARSHAL = new ObjectMarshal<RubyException>(){

        @Override
        public void marshalTo(Ruby runtime2, RubyException exc, RubyClass type2, MarshalStream marshalStream) throws IOException {
            marshalStream.registerLinkTarget(exc);
            List<Variable<Object>> attrs = exc.getVariableList();
            attrs.add(new VariableEntry<IRubyObject>("mesg", exc.getMessage()));
            attrs.add(new VariableEntry<IRubyObject>("bt", exc.getBacktrace()));
            marshalStream.dumpVariables(attrs);
        }

        @Override
        public RubyException unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            RubyException exc = (RubyException)type2.allocate();
            unmarshalStream.registerLinkTarget(exc);
            unmarshalStream.defaultVariablesUnmarshal(exc);
            exc.setMessage((IRubyObject)exc.removeInternalVariable("mesg"));
            exc.set_backtrace((IRubyObject)exc.removeInternalVariable("bt"));
            return exc;
        }
    };

    protected RubyException(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyException(Ruby runtime2, RubyClass rubyClass, String message2) {
        super(runtime2, rubyClass);
        this.setMessage(message2 == null ? runtime2.getNil() : runtime2.newString(message2));
    }

    @JRubyMethod(name={"exception"}, optional=1, rest=true, meta=true)
    public static IRubyObject exception(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return ((RubyClass)recv2).newInstance(context, args2, block);
    }

    @JRubyMethod(name={"==="}, meta=true)
    public static IRubyObject op_eqq(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        Object object;
        Ruby runtime2 = context.runtime;
        if (other instanceof ConcreteJavaProxy && (recv2 == runtime2.getException() || recv2 == runtime2.getStandardError()) && (object = ((ConcreteJavaProxy)other).getObject()) instanceof Throwable && !(object instanceof JumpException.FlowControlException) && (recv2 == runtime2.getException() || object instanceof java.lang.Exception)) {
            return context.tru;
        }
        return ((RubyClass)recv2).op_eqq(context, other);
    }

    protected RaiseException constructThrowable(String message2) {
        return new Exception(message2, this);
    }

    public static RubyClass createExceptionClass(Ruby runtime2) {
        RubyClass exceptionClass = runtime2.defineClass("Exception", runtime2.getObject(), EXCEPTION_ALLOCATOR);
        runtime2.setException(exceptionClass);
        exceptionClass.setClassIndex(ClassIndex.EXCEPTION);
        exceptionClass.setReifiedClass(RubyException.class);
        exceptionClass.setMarshal(EXCEPTION_MARSHAL);
        exceptionClass.defineAnnotatedMethods(RubyException.class);
        return exceptionClass;
    }

    public static RubyException newException(Ruby runtime2, RubyClass excptnClass, String msg) {
        if (msg == null) {
            msg = "No message available";
        }
        return (RubyException)excptnClass.newInstance(runtime2.getCurrentContext(), RubyString.newString(runtime2, msg), Block.NULL_BLOCK);
    }

    @Deprecated
    public static IRubyObject newException(ThreadContext context, RubyClass exceptionClass, IRubyObject message2) {
        return exceptionClass.callMethod(context, "new", (IRubyObject)message2.convertToString());
    }

    @JRubyMethod
    public IRubyObject full_message(ThreadContext context) {
        return RubyString.newString(context.runtime, TraceType.Format.MRI.printBacktrace(this, false));
    }

    @JRubyMethod
    public IRubyObject full_message(ThreadContext context, IRubyObject opts) {
        Ruby runtime2 = context.runtime;
        IRubyObject optArg = ArgsUtil.getOptionsArg(runtime2, opts);
        boolean highlight = false;
        boolean reverse2 = false;
        if (!optArg.isNil()) {
            IRubyObject[] highlightOrder = ArgsUtil.extractKeywordArgs(context, (RubyHash)optArg, FULL_MESSAGE_KEYS);
            IRubyObject vHigh = highlightOrder[0];
            if (vHigh == UNDEF) {
                vHigh = context.nil;
            }
            if (vHigh != context.nil && vHigh != context.fals && vHigh != context.tru) {
                throw runtime2.newArgumentError("expected true or false as highlight: " + vHigh);
            }
            highlight = vHigh.isTrue();
            IRubyObject vOrder = highlightOrder[1];
            if (vOrder != UNDEF) {
                if ((vOrder = TypeConverter.checkID(vOrder)) == runtime2.newSymbol("bottom")) {
                    reverse2 = true;
                } else if (vOrder == runtime2.newSymbol("top")) {
                    reverse2 = false;
                } else {
                    throw runtime2.newArgumentError("expected :top or :bottom as order: " + vOrder);
                }
            }
        }
        return RubyString.newString(runtime2, TraceType.Format.MRI.printBacktrace(this, highlight));
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        if (args2.length == 1) {
            this.setMessage(args2[0]);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject backtrace() {
        return this.getBacktrace();
    }

    @JRubyMethod(required=1)
    public IRubyObject set_backtrace(IRubyObject obj) {
        this.setBacktrace(obj);
        return this.backtrace();
    }

    public void setBacktrace(IRubyObject obj) {
        if (obj.isNil() || this.isArrayOfStrings(obj)) {
            this.backtrace.backtraceObject = obj;
        } else if (obj instanceof RubyString) {
            this.backtrace.backtraceObject = RubyArray.newArray(this.getRuntime(), obj);
        } else {
            throw this.getRuntime().newTypeError("backtrace must be Array of String");
        }
    }

    @JRubyMethod(omit=true)
    public IRubyObject backtrace_locations(ThreadContext context) {
        return this.backtrace.getBacktraceLocations(context);
    }

    @JRubyMethod(optional=1)
    public RubyException exception(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this;
            }
            case 1: {
                if (args2[0] == this) {
                    return this;
                }
                RubyException ret = (RubyException)this.rbClone();
                ret.initialize(args2, Block.NULL_BLOCK);
                return ret;
            }
        }
        throw this.getRuntime().newArgumentError("Wrong argument count");
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        IRubyObject msg = this.getMessage();
        if (!msg.isNil()) {
            return msg.asString();
        }
        return context.runtime.newString(this.getMetaClass().getRealClass().getName());
    }

    @Deprecated
    public IRubyObject to_s19(ThreadContext context) {
        return this.to_s(context);
    }

    @JRubyMethod(name={"message"})
    public IRubyObject message(ThreadContext context) {
        return this.callMethod(context, "to_s");
    }

    @JRubyMethod(name={"inspect"})
    public RubyString inspect(ThreadContext context) {
        String rubyClass = this.getMetaClass().getRealClass().getName();
        RubyString exception2 = RubyString.objAsString(context, this);
        if (exception2.isEmpty()) {
            return context.runtime.newString(rubyClass);
        }
        return RubyString.newString(context.runtime, new StringBuilder(2 + rubyClass.length() + 2 + exception2.size() + 1).append("#<").append(rubyClass).append(": ").append(exception2.getByteList()).append('>'));
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        boolean equal = context.runtime.getException().isInstance(other) && this.getMetaClass().getRealClass() == other.getMetaClass().getRealClass() && this.callMethod(context, "message").equals(other.callMethod(context, "message")) && this.callMethod(context, "backtrace").equals(other.callMethod(context, "backtrace"));
        return context.runtime.newBoolean(equal);
    }

    @JRubyMethod(name={"cause"})
    public IRubyObject cause(ThreadContext context) {
        return this.cause == null ? context.nil : this.cause;
    }

    @Override
    public <T> T toJava(Class<T> target) {
        if (target != Object.class && target.isAssignableFrom(RaiseException.class)) {
            return target.cast(this.toThrowable());
        }
        return super.toJava(target);
    }

    public RaiseException toThrowable() {
        if (this.throwable == null) {
            this.throwable = this.constructThrowable(this.getMessageAsJavaString());
            return this.throwable;
        }
        return this.throwable;
    }

    public void setCause(IRubyObject cause2) {
        this.cause = cause2;
    }

    public Object getCause() {
        return this.cause;
    }

    public RubyStackTraceElement[] getBacktraceElements() {
        if (this.backtrace.backtraceData == null) {
            return RubyStackTraceElement.EMPTY_ARRAY;
        }
        return this.backtrace.backtraceData.getBacktrace(this.getRuntime());
    }

    public void captureBacktrace(ThreadContext context) {
        this.backtrace.backtraceData = context.runtime.getInstanceConfig().getTraceType().getBacktrace(context);
    }

    public IRubyObject getBacktrace() {
        IRubyObject backtraceObject = this.backtrace.backtraceObject;
        if (backtraceObject != null) {
            return this.backtrace.backtraceObject;
        }
        Ruby runtime2 = this.getRuntime();
        return this.backtrace.getBacktraceObject(runtime2);
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyException exception2 = (RubyException)clone2;
        exception2.backtrace.copy(this.backtrace);
        exception2.message = this.message;
    }

    public void printBacktrace(PrintStream errorStream) {
        this.printBacktrace(errorStream, 0);
    }

    public void printBacktrace(PrintStream errorStream, int skip2) {
        IRubyObject trace2 = this.callMethod(this.getRuntime().getCurrentContext(), "backtrace");
        if (trace2.isNil()) {
            return;
        }
        if (trace2 instanceof RubyArray) {
            IRubyObject[] elements = ((RubyArray)trace2).toJavaArrayMaybeUnsafe();
            for (int i2 = skip2; i2 < elements.length; ++i2) {
                IRubyObject stackTraceLine = elements[i2];
                if (stackTraceLine instanceof RubyString) {
                    errorStream.println("\tfrom " + stackTraceLine);
                    continue;
                }
                errorStream.println("\t" + stackTraceLine);
            }
        }
    }

    private boolean isArrayOfStrings(IRubyObject backtrace2) {
        if (!(backtrace2 instanceof RubyArray)) {
            return false;
        }
        RubyArray rTrace = (RubyArray)backtrace2;
        for (int i2 = 0; i2 < rTrace.getLength(); ++i2) {
            if (rTrace.eltInternal(i2) instanceof RubyString) continue;
            return false;
        }
        return true;
    }

    public IRubyObject getMessage() {
        return this.message == null ? this.getRuntime().getNil() : this.message;
    }

    public void setMessage(IRubyObject message2) {
        this.message = message2;
    }

    public String getMessageAsJavaString() {
        IRubyObject msg = this.getMessage();
        return msg.isNil() ? null : msg.toString();
    }

    @Override
    public List<Variable<Object>> getVariableList() {
        List<Variable<Object>> attrs = super.getVariableList();
        attrs.add(new VariableEntry<IRubyObject>("mesg", this.getMessage()));
        IRubyObject backtrace2 = this.getBacktrace();
        attrs.add(new VariableEntry<IRubyObject>("bt", backtrace2));
        return attrs;
    }

    @Override
    public List<String> getVariableNameList() {
        List<String> names2 = super.getVariableNameList();
        names2.add("mesg");
        names2.add("bt");
        return names2;
    }

    @Deprecated
    public void prepareIntegratedBacktrace(ThreadContext context, StackTraceElement[] javaTrace) {
        if (this.backtrace.backtraceData == null) {
            this.backtrace.backtraceData = context.runtime.getInstanceConfig().getTraceType().getIntegratedBacktrace(context, javaTrace);
        }
    }

    private static class Backtrace {
        private BacktraceData backtraceData;
        private IRubyObject backtraceObject;
        private IRubyObject backtraceLocations;

        private Backtrace() {
        }

        public void copy(Backtrace clone2) {
            this.backtraceData = clone2.backtraceData;
            this.backtraceObject = clone2.backtraceObject;
            this.backtraceLocations = clone2.backtraceLocations;
        }

        public final IRubyObject getBacktraceObject(Ruby runtime2) {
            IRubyObject backtraceObject = this.backtraceObject;
            if (backtraceObject != null) {
                return backtraceObject;
            }
            if (this.backtraceData == null || this.backtraceData == BacktraceData.EMPTY) {
                return runtime2.getNil();
            }
            this.backtraceObject = TraceType.generateMRIBacktrace(runtime2, this.backtraceData.getBacktrace(runtime2));
            return this.backtraceObject;
        }

        public IRubyObject getBacktraceLocations(ThreadContext context) {
            if (this.backtraceLocations != null) {
                return this.backtraceLocations;
            }
            if (this.backtraceData == null) {
                this.backtraceLocations = context.nil;
            } else {
                Ruby runtime2 = context.runtime;
                this.backtraceLocations = RubyThread.Location.newLocationArray(runtime2, this.backtraceData.getBacktrace(runtime2));
            }
            return this.backtraceLocations;
        }
    }
}

