/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import com.sun.star.awt.XDialog;
import com.sun.star.lang.XInitialization;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.openoffice.da.comp.w2lcommon.helper.DialogBase;

public class LogViewerDialog
extends DialogBase
implements XInitialization {
    public static String __serviceName = "org.openoffice.da.writer2latex.LogViewerDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer2latex.LogViewerDialog";
    private String sBaseUrl = null;
    private String sLaTeXLog = null;
    private String sLaTeXErrors = null;
    private String sBibTeXLog = null;
    private String sMakeindexLog = null;

    @Override
    public String getDialogLibraryName() {
        return "W2LDialogs2";
    }

    @Override
    public String getDialogName() {
        return "LogViewer";
    }

    @Override
    public void initialize() {
        if (this.sBaseUrl != null) {
            this.sLaTeXLog = this.readTextFile(this.sBaseUrl + ".log");
            this.sLaTeXErrors = this.errorFilter(this.sLaTeXLog);
            this.sBibTeXLog = this.readTextFile(this.sBaseUrl + ".blg");
            this.sMakeindexLog = this.readTextFile(this.sBaseUrl + ".ilg");
            this.setComboBoxText("LogContents", this.sLaTeXLog);
        }
    }

    @Override
    public void endDialog() {
    }

    public LogViewerDialog(XComponentContext xContext) {
        super(xContext);
    }

    public void initialize(Object[] object) throws Exception {
        if (object.length > 0 && object[0] instanceof String) {
            this.sBaseUrl = (String)object[0];
        }
    }

    @Override
    public boolean callHandlerMethod(XDialog xDialog, Object event, String sMethod) {
        if (sMethod.equals("ViewLaTeXLog")) {
            this.setComboBoxText("LogContents", this.getCheckBoxState("ErrorFilter") == 1 ? this.sLaTeXErrors : this.sLaTeXLog);
            this.setControlEnabled("ErrorFilter", true);
        } else if (sMethod.equals("ViewBibTeXLog")) {
            this.setComboBoxText("LogContents", this.sBibTeXLog);
            this.setControlEnabled("ErrorFilter", false);
        } else if (sMethod.equals("ViewMakeindexLog")) {
            this.setComboBoxText("LogContents", this.sMakeindexLog);
            this.setControlEnabled("ErrorFilter", false);
        } else if (sMethod.equals("ErrorFilterChange")) {
            this.setComboBoxText("LogContents", this.getCheckBoxState("ErrorFilter") == 1 ? this.sLaTeXErrors : this.sLaTeXLog);
        }
        return true;
    }

    @Override
    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"ViewLaTeXLog", "ViewBibTeXLog", "ViewMakeindexLog", "ErrorFilterChange"};
        return sNames;
    }

    private String readTextFile(String sUrl) {
        StringBuilder buf = new StringBuilder();
        try {
            File file = new File(new URI(sUrl));
            if (file.exists() && file.isFile()) {
                int n;
                InputStreamReader isr = new InputStreamReader(new FileInputStream(file));
                do {
                    if ((n = isr.read()) <= -1) continue;
                    buf.append((char)n);
                } while (n > -1);
                isr.close();
            }
        }
        catch (URISyntaxException e) {
            return "";
        }
        catch (IOException e) {
            return "";
        }
        return buf.toString();
    }

    private String errorFilter(String log) {
        StringBuilder buf = new StringBuilder();
        int nLen = log.length();
        int nIndex = 0;
        boolean bIncludeLines = false;
        while (nIndex < nLen) {
            int nNewline = log.indexOf(10, nIndex);
            if (nNewline == -1) {
                nNewline = nLen;
            }
            if (nNewline - nIndex > 1 && log.charAt(nIndex) == '!') {
                bIncludeLines = true;
            } else if (nNewline == nIndex) {
                if (bIncludeLines) {
                    buf.append('\n');
                }
                bIncludeLines = false;
            }
            if (bIncludeLines) {
                buf.append(log.substring(nIndex, nNewline)).append('\n');
            }
            nIndex = nNewline + 1;
        }
        return buf.toString();
    }
}

