import { phantom, tuple } from './function';
export const URI = 'Traced';
/**
 * @since 1.16.0
 */
export class Traced {
    constructor(run) {
        this.run = run;
    }
    map(f) {
        return new Traced((p) => f(this.run(p)));
    }
}
/**
 * Extracts a value at a relative position which depends on the current value.
 * @since 1.16.0
 */
export const tracks = (M, f) => (wa) => {
    return wa.run(f(wa.run(M.empty)));
};
/**
 * Get the current position
 * @since 1.16.0
 */
export const listen = (wa) => {
    return new Traced(e => tuple(wa.run(e), e));
};
/**
 * Get a value which depends on the current position
 * @since 1.16.0
 */
export const listens = (wa, f) => {
    return new Traced(e => tuple(wa.run(e), f(e)));
};
/**
 * Apply a function to the current position
 * @since 1.16.0
 */
export const censor = (wa, f) => {
    return new Traced(e => wa.run(f(e)));
};
/**
 * @since 1.16.0
 */
export function getComonad(monoid) {
    function extend(wa, f) {
        return new Traced((p1) => f(new Traced((p2) => wa.run(monoid.concat(p1, p2)))));
    }
    function extract(wa) {
        return wa.run(monoid.empty);
    }
    return {
        URI,
        _L: phantom,
        map,
        extend,
        extract
    };
}
function map(wa, f) {
    return wa.map(f);
}
/**
 * @since 1.16.0
 */
export const traced = {
    URI,
    map
};
