"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../store/utils");
var commons_1 = require("../../../utils/commons");
var series_1 = require("../utils/series");
function computeLegend(seriesColor, seriesColorMap, specs, defaultColor, axesSpecs, deselectedDataSeries) {
    var legendItems = new Map();
    var sortedSeriesColors = series_1.getSortedDataSeriesColorsValuesMap(seriesColor);
    sortedSeriesColors.forEach(function (series, key) {
        var spec = specs.get(series.specId);
        var color = seriesColorMap.get(key) || defaultColor;
        var hasSingleSeries = seriesColor.size === 1;
        var label = getSeriesColorLabel(series.colorValues, hasSingleSeries, spec);
        var isSeriesVisible = deselectedDataSeries ? series_1.findDataSeriesByColorValues(deselectedDataSeries, series) < 0 : true;
        if (!label || !spec) {
            return;
        }
        // Use this to get axis spec w/ tick formatter
        var yAxis = utils_1.getAxesSpecForSpecId(axesSpecs, spec.groupId).yAxis;
        var formatter = yAxis ? yAxis.tickFormat : commons_1.identity;
        var hideInLegend = spec.hideInLegend;
        legendItems.set(key, {
            key: key,
            color: color,
            label: label,
            value: series,
            isSeriesVisible: isSeriesVisible,
            isLegendItemVisible: !hideInLegend,
            displayValue: {
                raw: series.lastValue,
                formatted: isSeriesVisible ? formatter(series.lastValue) : undefined,
            },
        });
    });
    return legendItems;
}
exports.computeLegend = computeLegend;
function getSeriesColorLabel(colorValues, hasSingleSeries, spec) {
    var label = '';
    if (hasSingleSeries || colorValues.length === 0 || colorValues[0] == null) {
        if (!spec) {
            return;
        }
        label = spec.name || "" + spec.id;
    }
    else {
        label = colorValues.join(' - ');
    }
    return label;
}
exports.getSeriesColorLabel = getSeriesColorLabel;
//# sourceMappingURL=legend.js.map