/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingResourceDefinition;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.formatters.CustomFormatterResourceDefinition;
import org.jboss.as.logging.formatters.PatternFormatterResourceDefinition;
import org.jboss.as.logging.formatters.StructuredFormatterResourceDefinition;
import org.jboss.as.logging.formatters.XmlFormatterResourceDefinition;
import org.jboss.as.logging.handlers.AbstractHandlerDefinition;
import org.jboss.as.logging.handlers.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.handlers.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.handlers.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.handlers.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.handlers.SocketHandlerResourceDefinition;
import org.jboss.as.logging.handlers.SyslogHandlerResourceDefinition;
import org.jboss.as.logging.loggers.LoggerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class LoggingSubsystemWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        List profiles;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode model = context.getModelNode();
        for (SimpleAttributeDefinition attribute : LoggingResourceDefinition.ATTRIBUTES) {
            attribute.marshallAsElement(model, false, (XMLStreamWriter)writer);
        }
        this.writeContent(writer, model);
        if (model.hasDefined("logging-profile") && !(profiles = model.get("logging-profile").asPropertyList()).isEmpty()) {
            writer.writeStartElement("logging-profiles");
            for (Property profile : profiles) {
                String name = profile.getName();
                writer.writeStartElement("logging-profile");
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                this.writeContent(writer, profile.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeContent(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        ModelNode handler;
        String name;
        ModelNode handlers;
        if (model.hasDefined("async-handler")) {
            handlers = model.get("async-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeAsynchHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("console-handler")) {
            handlers = model.get("console-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeConsoleHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("file-handler")) {
            handlers = model.get("file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeFileHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("custom-handler")) {
            handlers = model.get("custom-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeCustomHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("periodic-rotating-file-handler")) {
            handlers = model.get("periodic-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writePeriodicRotatingFileHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("periodic-size-rotating-file-handler")) {
            handlers = model.get("periodic-size-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writePeriodicSizeRotatingFileHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("size-rotating-file-handler")) {
            handlers = model.get("size-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeSizeRotatingFileHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("socket-handler")) {
            handlers = model.get("socket-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeSocketHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("syslog-handler")) {
            handlers = model.get("syslog-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeSyslogHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("logger")) {
            for (String name2 : model.get("logger").keys()) {
                this.writeLogger(writer, name2, model.get(new String[]{"logger", name2}));
            }
        }
        if (model.hasDefined("root-logger")) {
            this.writeRootLogger(writer, model.get(new String[]{"root-logger", "ROOT"}));
        }
        this.writeFormatters(writer, "pattern-formatter", (AttributeDefinition)PatternFormatterResourceDefinition.PATTERN_FORMATTER, model);
        this.writeFormatters(writer, "custom-formatter", (AttributeDefinition)CustomFormatterResourceDefinition.CUSTOM_FORMATTER, model);
        this.writeStructuredFormatters(writer, "json-formatter", model, new SimpleAttributeDefinition[0]);
        this.writeStructuredFormatters(writer, "xml-formatter", model, XmlFormatterResourceDefinition.PRINT_NAMESPACE, XmlFormatterResourceDefinition.NAMESPACE_URI);
    }

    private void writeCommonLogger(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        CommonAttributes.LEVEL.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.FILTER_SPEC.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.HANDLERS.marshallAsElement(model, (XMLStreamWriter)writer);
    }

    private void writeCommonHandler(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        CommonAttributes.LEVEL.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.ENCODING.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.FILTER_SPEC.marshallAsElement(model, (XMLStreamWriter)writer);
        AbstractHandlerDefinition.FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
        AbstractHandlerDefinition.NAMED_FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
    }

    private void writeConsoleHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.CONSOLE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        ConsoleHandlerResourceDefinition.TARGET.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeFileHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.FILE_HANDLER.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        CommonAttributes.FILE.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeCustomHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.CUSTOM_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.CLASS.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.MODULE.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        CommonAttributes.PROPERTIES.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writePeriodicRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.PERIODIC_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        CommonAttributes.FILE.marshallAsElement(model, (XMLStreamWriter)writer);
        PeriodicHandlerResourceDefinition.SUFFIX.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writePeriodicSizeRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.PERIODIC_SIZE_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        CommonAttributes.FILE.marshallAsElement(model, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.marshallAsElement(model, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.marshallAsElement(model, (XMLStreamWriter)writer);
        PeriodicHandlerResourceDefinition.SUFFIX.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeSizeRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.SIZE_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        CommonAttributes.FILE.marshallAsElement(model, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.marshallAsElement(model, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(model, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.SUFFIX.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeSocketHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.SOCKET_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        SocketHandlerResourceDefinition.BLOCK_ON_RECONNECT.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        SocketHandlerResourceDefinition.OUTBOUND_SOCKET_BINDING_REF.marshallAsAttribute(model, (XMLStreamWriter)writer);
        SocketHandlerResourceDefinition.SSL_CONTEXT.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENCODING.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.FILTER_SPEC.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.LEVEL.marshallAsElement(model, (XMLStreamWriter)writer);
        SocketHandlerResourceDefinition.NAMED_FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
        SocketHandlerResourceDefinition.PROTOCOL.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeSyslogHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.SYSLOG_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        CommonAttributes.LEVEL.marshallAsElement(model, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.SERVER_ADDRESS.marshallAsElement(model, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.HOSTNAME.marshallAsElement(model, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.PORT.marshallAsElement(model, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.APP_NAME.marshallAsElement(model, (XMLStreamWriter)writer);
        if (model.hasDefined(SyslogHandlerResourceDefinition.SYSLOG_FORMATTER.getName()) || model.hasDefined(SyslogHandlerResourceDefinition.NAMED_FORMATTER.getName())) {
            writer.writeStartElement(AbstractHandlerDefinition.FORMATTER.getXmlName());
            SyslogHandlerResourceDefinition.SYSLOG_FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
            SyslogHandlerResourceDefinition.NAMED_FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        SyslogHandlerResourceDefinition.FACILITY.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeAsynchHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.ASYNC_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        CommonAttributes.LEVEL.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.FILTER_SPEC.marshallAsElement(model, (XMLStreamWriter)writer);
        AbstractHandlerDefinition.FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
        AsyncHandlerResourceDefinition.QUEUE_LENGTH.marshallAsElement(model, (XMLStreamWriter)writer);
        AsyncHandlerResourceDefinition.OVERFLOW_ACTION.marshallAsElement(model, (XMLStreamWriter)writer);
        AsyncHandlerResourceDefinition.SUBHANDLERS.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeLogger(XMLExtendedStreamWriter writer, String name, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(Element.LOGGER.getLocalName());
        writer.writeAttribute(LoggerResourceDefinition.CATEGORY.getXmlName(), name);
        LoggerResourceDefinition.USE_PARENT_HANDLERS.marshallAsAttribute(model, (XMLStreamWriter)writer);
        this.writeCommonLogger(writer, model);
        writer.writeEndElement();
    }

    private void writeRootLogger(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(Element.ROOT_LOGGER.getLocalName());
        this.writeCommonLogger(writer, model);
        writer.writeEndElement();
    }

    private void writeFormatters(XMLExtendedStreamWriter writer, String resourceName, AttributeDefinition attribute, ModelNode model) throws XMLStreamException {
        if (model.hasDefined(resourceName)) {
            for (String name : model.get(resourceName).keys()) {
                writer.writeStartElement(Element.FORMATTER.getLocalName());
                writer.writeAttribute(CommonAttributes.NAME.getXmlName(), name);
                ModelNode value = model.get(new String[]{resourceName, name});
                attribute.marshallAsElement(value, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeStructuredFormatters(XMLExtendedStreamWriter writer, String elementName, ModelNode model, SimpleAttributeDefinition ... additionalAttributes) throws XMLStreamException {
        if (model.hasDefined(elementName)) {
            for (String name : model.get(elementName).keys()) {
                writer.writeStartElement(Element.FORMATTER.getLocalName());
                writer.writeAttribute(CommonAttributes.NAME.getXmlName(), name);
                ModelNode value = model.get(new String[]{elementName, name});
                writer.writeStartElement(elementName);
                StructuredFormatterResourceDefinition.DATE_FORMAT.marshallAsAttribute(value, (XMLStreamWriter)writer);
                StructuredFormatterResourceDefinition.PRETTY_PRINT.marshallAsAttribute(value, (XMLStreamWriter)writer);
                StructuredFormatterResourceDefinition.PRINT_DETAILS.marshallAsAttribute(value, (XMLStreamWriter)writer);
                StructuredFormatterResourceDefinition.ZONE_ID.marshallAsAttribute(value, (XMLStreamWriter)writer);
                for (SimpleAttributeDefinition ad : additionalAttributes) {
                    ad.marshallAsAttribute(value, (XMLStreamWriter)writer);
                }
                StructuredFormatterResourceDefinition.EXCEPTION_OUTPUT_TYPE.marshallAsElement(value, (XMLStreamWriter)writer);
                StructuredFormatterResourceDefinition.RECORD_DELIMITER.marshallAsElement(value, (XMLStreamWriter)writer);
                StructuredFormatterResourceDefinition.KEY_OVERRIDES.marshallAsElement(value, (XMLStreamWriter)writer);
                StructuredFormatterResourceDefinition.META_DATA.marshallAsElement(value, (XMLStreamWriter)writer);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    }
}

