/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.tom;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.protocols.tom.MessageID;
import org.jgroups.util.Bits;

public class ToaHeader
extends Header {
    public static final byte DATA_MESSAGE = 1;
    public static final byte PROPOSE_MESSAGE = 2;
    public static final byte FINAL_MESSAGE = 4;
    public static final byte SINGLE_DESTINATION_MESSAGE = 8;
    private byte type = 0;
    private MessageID messageID;
    private long sequencerNumber;
    private long viewId;

    public ToaHeader() {
    }

    private ToaHeader(MessageID messageID, byte type) {
        this.messageID = messageID;
        this.type = type;
    }

    @Override
    public short getMagicId() {
        return 79;
    }

    @Override
    public Supplier<? extends Header> create() {
        return ToaHeader::new;
    }

    public MessageID getMessageID() {
        return this.messageID;
    }

    public long getSequencerNumber() {
        return this.sequencerNumber;
    }

    public ToaHeader setSequencerNumber(long sequencerNumber) {
        this.sequencerNumber = sequencerNumber;
        return this;
    }

    public byte getType() {
        return this.type;
    }

    @Override
    public int serializedSize() {
        return 1 + this.messageID.serializedSize() + Bits.size(this.sequencerNumber) + Bits.size(this.viewId);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeByte(this.type);
        this.messageID.writeTo(out);
        Bits.writeLong(this.sequencerNumber, out);
        Bits.writeLong(this.viewId, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.type = in.readByte();
        this.messageID = new MessageID();
        this.messageID.readFrom(in);
        this.sequencerNumber = Bits.readLong(in);
        this.viewId = Bits.readLong(in);
    }

    @Override
    public String toString() {
        return "ToaHeader{type=" + ToaHeader.type2String(this.type) + ", message_id=" + this.messageID + ", sequence_number=" + this.sequencerNumber + ", view_id=" + this.viewId + '}';
    }

    private static String type2String(byte type) {
        switch (type) {
            case 1: {
                return "DATA_MESSAGE";
            }
            case 2: {
                return "PROPOSE_MESSAGE";
            }
            case 4: {
                return "FINAL_MESSAGE";
            }
            case 8: {
                return "SINGLE_DESTINATION_MESSAGE";
            }
        }
        return "UNKNOWN";
    }

    public static ToaHeader newDataMessageHeader(MessageID messageID, long viewId) {
        ToaHeader.assertMessageIDNotNull(messageID);
        return new ToaHeader(messageID, 1).setViewId(viewId);
    }

    public static ToaHeader newProposeMessageHeader(MessageID messageID, long sequencerNumber) {
        ToaHeader.assertMessageIDNotNull(messageID);
        return new ToaHeader(messageID, 2).setSequencerNumber(sequencerNumber);
    }

    public static ToaHeader newFinalMessageHeader(MessageID messageID, long sequenceNumber) {
        ToaHeader.assertMessageIDNotNull(messageID);
        return new ToaHeader(messageID, 4).setSequencerNumber(sequenceNumber);
    }

    public static ToaHeader createSingleDestinationHeader(MessageID messageID) {
        return new ToaHeader(messageID, 8);
    }

    private static void assertMessageIDNotNull(MessageID messageID) {
        Objects.requireNonNull(messageID, "The message ID can't be null.");
    }

    public long getViewId() {
        return this.viewId;
    }

    private ToaHeader setViewId(long viewId) {
        this.viewId = viewId;
        return this;
    }
}

