/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.message.impl;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.Persister;

public class CoreMessagePersister
implements Persister<Message> {
    public static final byte ID = 1;
    public static CoreMessagePersister theInstance;

    public static CoreMessagePersister getInstance() {
        if (theInstance == null) {
            theInstance = new CoreMessagePersister();
        }
        return theInstance;
    }

    protected CoreMessagePersister() {
    }

    @Override
    public byte getID() {
        return 1;
    }

    @Override
    public int getEncodeSize(Message record) {
        return 1 + record.getPersistSize() + SimpleString.sizeofNullableString(record.getAddressSimpleString()) + 8;
    }

    @Override
    public void encode(ActiveMQBuffer buffer, Message record) {
        buffer.writeByte((byte)1);
        buffer.writeLong(record.getMessageID());
        buffer.writeNullableSimpleString(record.getAddressSimpleString());
        record.persist(buffer);
    }

    @Override
    public Message decode(ActiveMQBuffer buffer, Message record) {
        long id = buffer.readLong();
        SimpleString address = buffer.readNullableSimpleString();
        record = new CoreMessage();
        record.reloadPersistence(buffer);
        record.setMessageID(id);
        record.setAddress(address);
        return record;
    }
}

