/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class RoleAddedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String roleId;
    private String containerId;

    public static RoleAddedEvent create(String roleId, String containerId) {
        RoleAddedEvent event = new RoleAddedEvent();
        event.roleId = roleId;
        event.containerId = containerId;
        return event;
    }

    @Override
    public String getId() {
        return this.roleId;
    }

    public String toString() {
        return String.format("RoleAddedEvent [ roleId=%s, containerId=%s ]", this.roleId, this.containerId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.roleAdded(this.containerId, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<RoleAddedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, RoleAddedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.roleId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.containerId, (ObjectOutput)output);
        }

        public RoleAddedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public RoleAddedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            RoleAddedEvent res = new RoleAddedEvent();
            res.roleId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.containerId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

