/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo1_7_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.7.0");

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        List realms = session.realms().getRealms();
        for (RealmModel realm : realms) {
            this.migrateRealm(session, realm);
        }
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm);
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm) {
        realm.setAccessTokenLifespanForImplicitFlow(900);
        MigrationProvider migrationProvider = (MigrationProvider)session.getProvider(MigrationProvider.class);
        migrationProvider.setupAdminCli(realm);
        DefaultAuthenticationFlows.migrateFlows(realm);
        AuthenticationFlowModel firstBrokerLoginFlow = realm.getFlowByAlias("first broker login");
        List identityProviders = realm.getIdentityProviders();
        for (IdentityProviderModel identityProvider : identityProviders) {
            if (identityProvider.getFirstBrokerLoginFlowId() != null) continue;
            identityProvider.setFirstBrokerLoginFlowId(firstBrokerLoginFlow.getId());
            realm.updateIdentityProvider(identityProvider);
        }
    }
}

