/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst.at.participants;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.mw.wsas.exceptions.SystemCommunicationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wscf.exceptions.InvalidParticipantException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicCancelException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicConfirmException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicHazardException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicMixedException;
import com.arjuna.mw.wscf.model.twophase.exceptions.ParticipantCancelledException;
import com.arjuna.mw.wscf.model.twophase.participants.Participant;
import com.arjuna.mw.wscf.model.twophase.vote.VoteCancel;
import com.arjuna.mw.wscf.model.twophase.vote.VoteConfirm;
import com.arjuna.mw.wscf.model.twophase.vote.VoteReadOnly;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.mwlabs.wst.util.PersistableParticipantHelper;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.Prepared;
import com.arjuna.wst.ReadOnly;
import com.arjuna.wst.Vote;

public class DurableTwoPhaseCommitParticipant
implements Participant {
    private Durable2PCParticipant _resource;
    private String _id;
    private boolean _readonly;
    private boolean _rolledback;

    public DurableTwoPhaseCommitParticipant() {
    }

    public DurableTwoPhaseCommitParticipant(Durable2PCParticipant resource, String identifier) {
        this._resource = resource;
        this._id = identifier;
    }

    @Override
    public com.arjuna.mw.wscf.model.twophase.vote.Vote prepare() throws InvalidParticipantException, WrongStateException, HeuristicHazardException, HeuristicMixedException, SystemException {
        try {
            if (this._resource != null) {
                Vote vt = this._resource.prepare();
                if (vt instanceof ReadOnly) {
                    this._readonly = true;
                    return new VoteReadOnly();
                }
                if (vt instanceof Prepared) {
                    return new VoteConfirm();
                }
                this._rolledback = true;
                return new VoteCancel();
            }
            return new VoteCancel();
        }
        catch (com.arjuna.wst.WrongStateException ex) {
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_prepare(this._id, this._resource, ex);
            WrongStateException wse = new WrongStateException(ex.toString());
            wse.addSuppressed(ex);
            throw wse;
        }
        catch (com.arjuna.wst.SystemException ex) {
            if (ex instanceof com.arjuna.wst.stub.SystemCommunicationException) {
                wstxLogger.i18NLogger.warn_mwlabs_wst_at_participants_DurableTwoPhaseCommitParticipant_prepare_1(this._id, this._resource);
                SystemCommunicationException sce = new SystemCommunicationException(ex.toString());
                sce.addSuppressed(ex);
                throw sce;
            }
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_prepare(this._id, this._resource, ex);
            SystemException se = new SystemException(ex.toString());
            se.addSuppressed(ex);
            throw se;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void confirm() throws InvalidParticipantException, WrongStateException, HeuristicHazardException, HeuristicMixedException, HeuristicCancelException, SystemException {
        if (this._resource != null) {
            try {
                if (this._readonly) return;
                this._resource.commit();
                return;
            }
            catch (com.arjuna.wst.WrongStateException ex) {
                wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_confirm(this._id, this._resource, ex);
                WrongStateException wse = new WrongStateException(ex.toString());
                wse.addSuppressed(wse);
                throw wse;
            }
            catch (com.arjuna.wst.SystemException ex) {
                if (ex instanceof com.arjuna.wst.stub.SystemCommunicationException) {
                    wstxLogger.i18NLogger.warn_mwlabs_wst_at_participants_DurableTwoPhaseCommitParticipant_confirm_1(this._id, this._resource);
                    SystemCommunicationException sce = new SystemCommunicationException(ex.toString());
                    sce.addSuppressed(ex);
                    throw sce;
                }
                wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_confirm(this._id, this._resource, ex);
                SystemException se = new SystemException(ex.toString());
                se.addSuppressed(ex);
                throw se;
            }
        } else {
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_confirm_is_null(this._id);
            throw new InvalidParticipantException("participant " + this._id + " to confirm is null");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cancel() throws InvalidParticipantException, WrongStateException, HeuristicHazardException, HeuristicMixedException, HeuristicConfirmException, SystemException {
        if (this._resource != null) {
            try {
                if (this._rolledback) return;
                this._resource.rollback();
                return;
            }
            catch (com.arjuna.wst.WrongStateException ex) {
                WrongStateException wse = new WrongStateException(ex.toString());
                wse.addSuppressed(ex);
                throw wse;
            }
            catch (com.arjuna.wst.SystemException ex) {
                if (ex instanceof com.arjuna.wst.stub.SystemCommunicationException) {
                    wstxLogger.i18NLogger.error_mwlabs_wst_at_participants_DurableTwoPhaseCommitParticipant_cancel_1(this._id);
                    SystemCommunicationException sce = new SystemCommunicationException(ex.toString());
                    sce.addSuppressed(ex);
                    throw sce;
                }
                SystemException se = new SystemException(ex.toString());
                se.addSuppressed(ex);
                throw se;
            }
        } else {
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_cancel_is_null(this._id);
            throw new InvalidParticipantException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void confirmOnePhase() throws InvalidParticipantException, WrongStateException, HeuristicHazardException, HeuristicMixedException, HeuristicCancelException, SystemException {
        if (this._resource == null) {
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_confirm_one_phase_is_null(this._id);
            throw new InvalidParticipantException();
        }
        com.arjuna.mw.wscf.model.twophase.vote.Vote v = null;
        try {
            v = this.prepare();
        }
        catch (Exception ex) {
            wstxLogger.i18NLogger.warn_wst_at_participants_Durable2PC_commit_one_phase(this._id, this._resource, ex);
            v = new VoteCancel();
        }
        if (v instanceof VoteReadOnly) {
            this._readonly = true;
            return;
        }
        if (v instanceof VoteCancel) {
            this._rolledback = false;
            try {
                this.cancel();
            }
            catch (SystemCommunicationException ex) {
                // empty catch block
            }
            wstxLogger.i18NLogger.warn_wst_at_participants_Durable2PC_canceled(this._id, this._resource);
            throw new ParticipantCancelledException();
        }
        if (!(v instanceof VoteConfirm)) {
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_one_phase_wrong_vote(this._id, this._resource, v.toString());
            this.cancel();
            throw new HeuristicHazardException();
        }
        try {
            this.confirm();
            return;
        }
        catch (HeuristicHazardException ex) {
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_one_phase_failed(this._id, this._resource, ex);
            throw ex;
        }
        catch (HeuristicMixedException ex) {
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_one_phase_failed(this._id, this._resource, ex);
            throw ex;
        }
        catch (HeuristicCancelException ex) {
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_one_phase_failed(this._id, this._resource, ex);
            throw ex;
        }
        catch (Exception ex) {
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_one_phase_failed(this._id, this._resource, ex);
            HeuristicHazardException hhe = new HeuristicHazardException();
            hhe.addSuppressed(ex);
            throw ex;
        }
    }

    @Override
    public void forget() throws InvalidParticipantException, WrongStateException, SystemException {
    }

    public void unknown() throws SystemException {
        try {
            this.cancel();
        }
        catch (Exception ex) {
            wstxLogger.i18NLogger.error_wst_at_participants_Durable2PC_unknown(this._id, this._resource, ex);
        }
    }

    @Override
    public String id() throws SystemException {
        return this._id;
    }

    @Override
    public boolean save_state(OutputObjectState os) {
        return PersistableParticipantHelper.save_state(os, this._resource);
    }

    @Override
    public boolean restore_state(InputObjectState os) {
        this._resource = (Durable2PCParticipant)PersistableParticipantHelper.restore_state(os);
        return true;
    }
}

