/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.SerializablePermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.reflect.SerializableClass;

public final class SerializableClassRegistry {
    private static final SerializableClassRegistry INSTANCE = new SerializableClassRegistry();
    private static final SerializablePermission PERMISSION = new SerializablePermission("allowSerializationReflection");
    private static final ClassValue<SerializableClass> classValue = new ClassValue<SerializableClass>(){

        @Override
        protected SerializableClass computeValue(final Class<?> type) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return AccessController.doPrivileged(new PrivilegedAction<SerializableClass>(){

                    @Override
                    public SerializableClass run() {
                        return new SerializableClass(type);
                    }
                });
            }
            return new SerializableClass(type);
        }
    };

    private SerializableClassRegistry() {
    }

    public static SerializableClassRegistry getInstance() throws SecurityException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(PERMISSION);
        }
        return INSTANCE;
    }

    static SerializableClassRegistry getInstanceUnchecked() {
        return INSTANCE;
    }

    public SerializableClass lookup(Class<?> subject) {
        if (subject == null) {
            return null;
        }
        return classValue.get(subject);
    }

    public void release(ClassLoader classLoader) {
    }
}

