/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.CodeGenerateUtil;
import org.keycloak.sessions.CommonClientSessionModel;

public class ClientSessionCode<CLIENT_SESSION extends CommonClientSessionModel> {
    private KeycloakSession session;
    private final RealmModel realm;
    private final CLIENT_SESSION commonLoginSession;

    public ClientSessionCode(KeycloakSession session, RealmModel realm, CLIENT_SESSION commonLoginSession) {
        this.session = session;
        this.realm = realm;
        this.commonLoginSession = commonLoginSession;
    }

    public static <CLIENT_SESSION extends CommonClientSessionModel> ParseResult<CLIENT_SESSION> parseResult(String code, String tabId, KeycloakSession session, RealmModel realm, ClientModel client, EventBuilder event, Class<CLIENT_SESSION> sessionClass) {
        ParseResult result = new ParseResult();
        if (code == null) {
            result.illegalHash = true;
            return result;
        }
        try {
            CodeGenerateUtil.ClientSessionParser<CLIENT_SESSION> clientSessionParser = CodeGenerateUtil.getParser(sessionClass);
            result.clientSession = ClientSessionCode.getClientSession(code, tabId, session, realm, client, event, clientSessionParser);
            return ClientSessionCode.parseResult(code, session, realm, result, clientSessionParser);
        }
        catch (RuntimeException e) {
            result.illegalHash = true;
            return result;
        }
    }

    public static <CLIENT_SESSION extends CommonClientSessionModel> ParseResult<CLIENT_SESSION> parseResult(String code, String tabId, KeycloakSession session, RealmModel realm, ClientModel client, EventBuilder event, CLIENT_SESSION clientSession) {
        ParseResult result = new ParseResult();
        result.clientSession = clientSession;
        if (code == null) {
            result.illegalHash = true;
            return result;
        }
        try {
            CodeGenerateUtil.ClientSessionParser<?> clientSessionParser = CodeGenerateUtil.getParser(clientSession.getClass());
            return ClientSessionCode.parseResult(code, session, realm, result, clientSessionParser);
        }
        catch (RuntimeException e) {
            result.illegalHash = true;
            return result;
        }
    }

    private static <CLIENT_SESSION extends CommonClientSessionModel> ParseResult<CLIENT_SESSION> parseResult(String code, KeycloakSession session, RealmModel realm, ParseResult<CLIENT_SESSION> result, CodeGenerateUtil.ClientSessionParser<CLIENT_SESSION> clientSessionParser) {
        if (result.clientSession == null) {
            result.authSessionNotFound = true;
            return result;
        }
        if (!clientSessionParser.verifyCode(session, code, result.clientSession)) {
            result.illegalHash = true;
            return result;
        }
        if (clientSessionParser.isExpired(session, code, result.clientSession)) {
            result.expiredToken = true;
            return result;
        }
        result.code = new ClientSessionCode(session, realm, result.clientSession);
        return result;
    }

    public static <CLIENT_SESSION extends CommonClientSessionModel> CLIENT_SESSION getClientSession(String code, String tabId, KeycloakSession session, RealmModel realm, ClientModel client, EventBuilder event, Class<CLIENT_SESSION> sessionClass) {
        CodeGenerateUtil.ClientSessionParser<CLIENT_SESSION> clientSessionParser = CodeGenerateUtil.getParser(sessionClass);
        return ClientSessionCode.getClientSession(code, tabId, session, realm, client, event, clientSessionParser);
    }

    private static <CLIENT_SESSION extends CommonClientSessionModel> CLIENT_SESSION getClientSession(String code, String tabId, KeycloakSession session, RealmModel realm, ClientModel client, EventBuilder event, CodeGenerateUtil.ClientSessionParser<CLIENT_SESSION> clientSessionParser) {
        return clientSessionParser.parseSession(code, tabId, session, realm, client, event);
    }

    public CLIENT_SESSION getClientSession() {
        return this.commonLoginSession;
    }

    public boolean isValid(String requestedAction, ActionType actionType) {
        if (!this.isValidAction(requestedAction)) {
            return false;
        }
        return this.isActionActive(actionType);
    }

    public boolean isActionActive(ActionType actionType) {
        int lifespan;
        CodeGenerateUtil.ClientSessionParser<?> clientSessionParser = CodeGenerateUtil.getParser(this.commonLoginSession.getClass());
        int timestamp = clientSessionParser.getTimestamp(this.commonLoginSession);
        switch (actionType) {
            case CLIENT: {
                lifespan = this.realm.getAccessCodeLifespan();
                break;
            }
            case LOGIN: {
                lifespan = this.realm.getAccessCodeLifespanLogin() > 0 ? this.realm.getAccessCodeLifespanLogin() : this.realm.getAccessCodeLifespanUserAction();
                break;
            }
            case USER: {
                lifespan = this.realm.getAccessCodeLifespanUserAction();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return timestamp + lifespan > Time.currentTime();
    }

    public boolean isValidAction(String requestedAction) {
        String action = this.commonLoginSession.getAction();
        if (action == null) {
            return false;
        }
        return action.equals(requestedAction);
    }

    public void removeExpiredClientSession() {
        CodeGenerateUtil.ClientSessionParser<?> parser = CodeGenerateUtil.getParser(this.commonLoginSession.getClass());
        parser.removeExpiredSession(this.session, this.commonLoginSession);
    }

    public void setAction(String action) {
        this.commonLoginSession.setAction(action);
        CodeGenerateUtil.ClientSessionParser<?> clientSessionParser = CodeGenerateUtil.getParser(this.commonLoginSession.getClass());
        clientSessionParser.setTimestamp(this.commonLoginSession, Time.currentTime());
    }

    public String getOrGenerateCode() {
        CodeGenerateUtil.ClientSessionParser<?> parser = CodeGenerateUtil.getParser(this.commonLoginSession.getClass());
        return parser.retrieveCode(this.session, this.commonLoginSession);
    }

    public static class ParseResult<CLIENT_SESSION extends CommonClientSessionModel> {
        ClientSessionCode<CLIENT_SESSION> code;
        boolean authSessionNotFound;
        boolean illegalHash;
        boolean expiredToken;
        CLIENT_SESSION clientSession;

        public ClientSessionCode<CLIENT_SESSION> getCode() {
            return this.code;
        }

        public boolean isAuthSessionNotFound() {
            return this.authSessionNotFound;
        }

        public boolean isIllegalHash() {
            return this.illegalHash;
        }

        public boolean isExpiredToken() {
            return this.expiredToken;
        }

        public CLIENT_SESSION getClientSession() {
            return this.clientSession;
        }
    }

    public static enum ActionType {
        CLIENT,
        LOGIN,
        USER;

    }
}

