/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.cache.UserCache;
import org.keycloak.policy.PasswordPolicyManagerProvider;
import org.keycloak.policy.PolicyError;

public class PasswordCredentialProvider
implements CredentialProvider,
CredentialInputValidator,
CredentialInputUpdater,
OnUserCache {
    public static final String PASSWORD_CACHE_KEY = PasswordCredentialProvider.class.getName() + "." + "password";
    private static final Logger logger = Logger.getLogger(PasswordCredentialProvider.class);
    protected KeycloakSession session;

    public PasswordCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    protected UserCredentialStore getCredentialStore() {
        return this.session.userCredentialManager();
    }

    public CredentialModel getPassword(RealmModel realm, UserModel user) {
        List passwords = null;
        if (user instanceof CachedUserModel && !((CachedUserModel)user).isMarkedForEviction()) {
            CachedUserModel cached = (CachedUserModel)user;
            passwords = (List)cached.getCachedWith().get(PASSWORD_CACHE_KEY);
        }
        if (!(user instanceof CachedUserModel) || ((CachedUserModel)user).isMarkedForEviction()) {
            passwords = this.getCredentialStore().getStoredCredentialsByType(realm, user, "password");
        }
        if (passwords == null || passwords.isEmpty()) {
            return null;
        }
        return (CredentialModel)passwords.get(0);
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!this.supportsCredentialType(input.getType())) {
            return false;
        }
        if (!(input instanceof UserCredentialModel)) {
            logger.debug((Object)"Expected instance of UserCredentialModel for CredentialInput");
            return false;
        }
        UserCredentialModel cred = (UserCredentialModel)input;
        PasswordPolicy policy = realm.getPasswordPolicy();
        PolicyError error = ((PasswordPolicyManagerProvider)this.session.getProvider(PasswordPolicyManagerProvider.class)).validate(realm, user, cred.getValue());
        if (error != null) {
            throw new ModelException(error.getMessage(), error.getParameters());
        }
        PasswordHashProvider hash = this.getHashProvider(policy);
        if (hash == null) {
            return false;
        }
        CredentialModel oldPassword = this.getPassword(realm, user);
        this.expirePassword(realm, user, policy);
        CredentialModel newPassword = new CredentialModel();
        newPassword.setType("password");
        long createdDate = Time.currentTimeMillis();
        newPassword.setCreatedDate(Long.valueOf(createdDate));
        hash.encode(cred.getValue(), policy.getHashIterations(), newPassword);
        this.getCredentialStore().createCredential(realm, user, newPassword);
        UserCache userCache = this.session.userCache();
        if (userCache != null) {
            userCache.evict(realm, user);
        }
        return true;
    }

    protected void expirePassword(RealmModel realm, UserModel user, PasswordPolicy policy) {
        CredentialModel oldPassword = this.getPassword(realm, user);
        if (oldPassword == null) {
            return;
        }
        int expiredPasswordsPolicyValue = policy.getExpiredPasswords();
        List list = this.getCredentialStore().getStoredCredentialsByType(realm, user, "password-history");
        if (expiredPasswordsPolicyValue > 1) {
            int passwordsToLeave = expiredPasswordsPolicyValue - 2;
            if (list.size() > passwordsToLeave) {
                list.stream().sorted((o1, o2) -> {
                    Long o1Date = o1.getCreatedDate() == null ? Long.MIN_VALUE : o1.getCreatedDate();
                    Long o2Date = o2.getCreatedDate() == null ? Long.MIN_VALUE : o2.getCreatedDate();
                    return -o1Date.compareTo(o2Date);
                }).skip(passwordsToLeave).forEach(p -> this.getCredentialStore().removeStoredCredential(realm, user, p.getId()));
            }
            oldPassword.setType("password-history");
            this.getCredentialStore().updateCredential(realm, user, oldPassword);
        } else {
            list.stream().forEach(p -> this.getCredentialStore().removeStoredCredential(realm, user, p.getId()));
            this.getCredentialStore().removeStoredCredential(realm, user, oldPassword.getId());
        }
    }

    protected PasswordHashProvider getHashProvider(PasswordPolicy policy) {
        PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, policy.getHashAlgorithm());
        if (hash == null) {
            logger.warnv("Realm PasswordPolicy PasswordHashProvider {0} not found", (Object)policy.getHashAlgorithm());
            return (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, "pbkdf2-sha256");
        }
        return hash;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return;
        }
        PasswordPolicy policy = realm.getPasswordPolicy();
        this.expirePassword(realm, user, policy);
    }

    public Set<String> getDisableableCredentialTypes(RealmModel realm, UserModel user) {
        if (!this.getCredentialStore().getStoredCredentialsByType(realm, user, "password").isEmpty()) {
            HashSet<String> set = new HashSet<String>();
            set.add("password");
            return set;
        }
        return Collections.EMPTY_SET;
    }

    public boolean supportsCredentialType(String credentialType) {
        return credentialType.equals("password");
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.getPassword(realm, user) != null;
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            logger.debug((Object)"Expected instance of UserCredentialModel for CredentialInput");
            return false;
        }
        UserCredentialModel cred = (UserCredentialModel)input;
        if (cred.getValue() == null) {
            logger.debugv("Input password was null for user {0} ", (Object)user.getUsername());
            return false;
        }
        CredentialModel password = this.getPassword(realm, user);
        if (password == null) {
            logger.debugv("No password cached or stored for user {0} ", (Object)user.getUsername());
            return false;
        }
        PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, password.getAlgorithm());
        if (hash == null) {
            logger.debugv("PasswordHashProvider {0} not found for user {1} ", (Object)password.getAlgorithm(), (Object)user.getUsername());
            return false;
        }
        if (!hash.verify(cred.getValue(), password)) {
            logger.debugv("Failed password validation for user {0} ", (Object)user.getUsername());
            return false;
        }
        PasswordPolicy policy = realm.getPasswordPolicy();
        if (policy == null) {
            return true;
        }
        hash = this.getHashProvider(policy);
        if (hash == null) {
            return true;
        }
        if (hash.policyCheck(policy, password)) {
            return true;
        }
        CredentialModel newPassword = password.shallowClone();
        hash.encode(cred.getValue(), policy.getHashIterations(), newPassword);
        this.getCredentialStore().updateCredential(realm, user, newPassword);
        UserCache userCache = this.session.userCache();
        if (userCache != null) {
            userCache.evict(realm, user);
        }
        return true;
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        List passwords = this.getCredentialStore().getStoredCredentialsByType(realm, (UserModel)user, "password");
        if (passwords != null) {
            user.getCachedWith().put(PASSWORD_CACHE_KEY, passwords);
        }
    }
}

