/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.permission;

import java.util.HashMap;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.services.ErrorResponseException;

public class PermissionTicketService {
    private final AuthorizationProvider authorization;
    private final KeycloakIdentity identity;
    private final ResourceServer resourceServer;

    public PermissionTicketService(KeycloakIdentity identity, ResourceServer resourceServer, AuthorizationProvider authorization) {
        this.identity = identity;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(PermissionTicketRepresentation representation) {
        PermissionTicketStore ticketStore = this.authorization.getStoreFactory().getPermissionTicketStore();
        if (representation == null) {
            throw new ErrorResponseException("invalid_request", "invalid_permission", Response.Status.BAD_REQUEST);
        }
        if (representation.getId() != null) {
            throw new ErrorResponseException("invalid_permission", "created permissions should not have id", Response.Status.BAD_REQUEST);
        }
        if (representation.getResource() == null) {
            throw new ErrorResponseException("invalid_permission", "created permissions should have resource", Response.Status.BAD_REQUEST);
        }
        if (representation.getScope() == null && representation.getScopeName() == null) {
            throw new ErrorResponseException("invalid_permission", "created permissions should have scope or scopeName", Response.Status.BAD_REQUEST);
        }
        if (representation.getRequester() == null && representation.getRequesterName() == null) {
            throw new ErrorResponseException("invalid_permission", "created permissions should have requester or requesterName", Response.Status.BAD_REQUEST);
        }
        ResourceStore rstore = this.authorization.getStoreFactory().getResourceStore();
        Resource resource = rstore.findById(representation.getResource(), this.resourceServer.getId());
        if (resource == null) {
            throw new ErrorResponseException("invalid_resource_id", "Resource set with id [" + representation.getResource() + "] does not exists in this server.", Response.Status.BAD_REQUEST);
        }
        if (!resource.getOwner().equals(this.identity.getId())) {
            throw new ErrorResponseException("not_authorised", "permissions for [" + representation.getResource() + "] can be only created by the owner", Response.Status.FORBIDDEN);
        }
        UserModel user = null;
        user = representation.getRequester() != null ? this.authorization.getKeycloakSession().userStorageManager().getUserById(representation.getRequester(), this.authorization.getRealm()) : this.authorization.getKeycloakSession().userStorageManager().getUserByUsername(representation.getRequesterName(), this.authorization.getRealm());
        if (user == null) {
            throw new ErrorResponseException("invalid_permission", "Requester does not exists in this server as user.", Response.Status.BAD_REQUEST);
        }
        Scope scope = null;
        ScopeStore sstore = this.authorization.getStoreFactory().getScopeStore();
        scope = representation.getScopeName() != null ? sstore.findByName(representation.getScopeName(), this.resourceServer.getId()) : sstore.findById(representation.getScope(), this.resourceServer.getId());
        if (scope == null && representation.getScope() != null) {
            throw new ErrorResponseException("invalid_scope", "Scope [" + representation.getScope() + "] is invalid", Response.Status.BAD_REQUEST);
        }
        if (scope == null && representation.getScopeName() != null) {
            throw new ErrorResponseException("invalid_scope", "Scope [" + representation.getScopeName() + "] is invalid", Response.Status.BAD_REQUEST);
        }
        boolean match = resource.getScopes().contains(scope);
        if (!match) {
            throw new ErrorResponseException("invalid_resource_id", "Resource set with id [" + representation.getResource() + "] does not have Scope [" + scope.getName() + "]", Response.Status.BAD_REQUEST);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("resource.id", resource.getId());
        attributes.put("scope.id", scope.getId());
        attributes.put("requester", user.getId());
        if (!ticketStore.find(attributes, this.resourceServer.getId(), -1, -1).isEmpty()) {
            throw new ErrorResponseException("invalid_permission", "Permission already exists", Response.Status.BAD_REQUEST);
        }
        PermissionTicket ticket = ticketStore.create(resource.getId(), scope.getId(), user.getId(), this.resourceServer);
        if (representation.isGranted()) {
            ticket.setGrantedTimestamp(Long.valueOf(System.currentTimeMillis()));
        }
        representation = ModelToRepresentation.toRepresentation((PermissionTicket)ticket, (AuthorizationProvider)this.authorization);
        return Response.ok((Object)representation).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(PermissionTicketRepresentation representation) {
        if (representation == null || representation.getId() == null) {
            throw new ErrorResponseException("invalid_request", "invalid_ticket", Response.Status.BAD_REQUEST);
        }
        PermissionTicketStore ticketStore = this.authorization.getStoreFactory().getPermissionTicketStore();
        PermissionTicket ticket = ticketStore.findById(representation.getId(), this.resourceServer.getId());
        if (ticket == null) {
            throw new ErrorResponseException("invalid_request", "invalid_ticket", Response.Status.BAD_REQUEST);
        }
        if (!ticket.getOwner().equals(this.identity.getId()) && !this.identity.isResourceServer()) {
            throw new ErrorResponseException("not_authorised", "permissions for [" + representation.getResource() + "] can be updated only by the owner or by the resource server", Response.Status.FORBIDDEN);
        }
        RepresentationToModel.toModel((PermissionTicketRepresentation)representation, (String)this.resourceServer.getId(), (AuthorizationProvider)this.authorization);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @DELETE
    @Consumes(value={"application/json"})
    public Response delete(@PathParam(value="id") String id) {
        if (id == null) {
            throw new ErrorResponseException("invalid_request", "invalid_ticket", Response.Status.BAD_REQUEST);
        }
        PermissionTicketStore ticketStore = this.authorization.getStoreFactory().getPermissionTicketStore();
        PermissionTicket ticket = ticketStore.findById(id, this.resourceServer.getId());
        if (ticket == null) {
            throw new ErrorResponseException("invalid_request", "invalid_ticket", Response.Status.BAD_REQUEST);
        }
        if (!(ticket.getOwner().equals(this.identity.getId()) || this.identity.isResourceServer() || ticket.getRequester().equals(this.identity.getId()))) {
            throw new ErrorResponseException("not_authorised", "permissions for [" + ticket.getResource() + "] can be deleted only by the owner, the requester, or the resource server", Response.Status.FORBIDDEN);
        }
        ticketStore.delete(id);
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response find(@QueryParam(value="scopeId") String scopeId, @QueryParam(value="resourceId") String resourceId, @QueryParam(value="owner") String owner, @QueryParam(value="requester") String requester, @QueryParam(value="granted") Boolean granted, @QueryParam(value="returnNames") Boolean returnNames, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        PermissionTicketStore permissionTicketStore = storeFactory.getPermissionTicketStore();
        HashMap<String, String> filters = new HashMap<String, String>();
        if (resourceId != null) {
            filters.put("resource.id", resourceId);
        }
        if (scopeId != null) {
            ScopeStore scopeStore = storeFactory.getScopeStore();
            Scope scope = scopeStore.findById(scopeId, this.resourceServer.getId());
            if (scope == null) {
                scope = scopeStore.findByName(scopeId, this.resourceServer.getId());
            }
            filters.put("scope.id", scope != null ? scope.getId() : scopeId);
        }
        if (owner != null) {
            filters.put("owner", this.getUserId(owner));
        }
        if (requester != null) {
            filters.put("requester", this.getUserId(requester));
        }
        if (granted != null) {
            filters.put("granted", granted.toString());
        }
        return Response.ok().entity(permissionTicketStore.find(filters, this.resourceServer.getId(), firstResult != null ? firstResult : -1, maxResult != null ? maxResult : 100).stream().map(permissionTicket -> ModelToRepresentation.toRepresentation((PermissionTicket)permissionTicket, (AuthorizationProvider)this.authorization, (boolean)(returnNames == null ? false : returnNames))).collect(Collectors.toList())).build();
    }

    private String getUserId(String userIdOrName) {
        RealmModel realm;
        UserProvider userProvider = this.authorization.getKeycloakSession().users();
        UserModel userModel = userProvider.getUserById(userIdOrName, realm = this.authorization.getRealm());
        if (userModel != null) {
            return userModel.getId();
        }
        userModel = userProvider.getUserByUsername(userIdOrName, realm);
        if (userModel != null) {
            return userModel.getId();
        }
        return userIdOrName;
    }
}

