/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.extension.mod_cluster.ModClusterLogger;

public class ModClusterLogger_$logger
extends DelegatingBasicLogger
implements ModClusterLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ModClusterLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ModClusterLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void errorAddingMetrics(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorAddingMetrics$str(), new Object[0]);
    }

    protected String errorAddingMetrics$str() {
        return "WFLYMODCLS0001: Error adding metrics.";
    }

    @Override
    public final void multicastInterfaceNotAvailable() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.multicastInterfaceNotAvailable$str(), new Object[0]);
    }

    protected String multicastInterfaceNotAvailable$str() {
        return "WFLYMODCLS0004: Mod_cluster requires Advertise but Multicast interface is not available";
    }

    @Override
    public final void usingSimpleLoadProvider(String proxyName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingSimpleLoadProvider$str(), (Object)proxyName);
    }

    protected String usingSimpleLoadProvider$str() {
        return "WFLYMODCLS0005: No mod_cluster load balance factor provider specified for proxy '%s'! Using load balance factor provider with constant factor of '1'.";
    }

    @Override
    public final void errorApplyingMetricProperties(Throwable cause, String metricClass) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorApplyingMetricProperties$str(), (Object)metricClass);
    }

    protected String errorApplyingMetricProperties$str() {
        return "WFLYMODCLS0006: Error applying properties to load metric class '%s'. Metric will not be loaded.";
    }

    @Override
    public final void unsupportedMetric(String metricType) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsupportedMetric$str(), (Object)metricType);
    }

    protected String unsupportedMetric$str() {
        return "WFLYMODCLS0007: Metric of type '%s' is no longer supported and will be ignored.";
    }

    protected String contextOrHostNotFound$str() {
        return "WFLYMODCLS0011: Virtual host '%s' or context '%s' not found.";
    }

    @Override
    public final String contextOrHostNotFound(String host, String context) {
        return String.format(this.getLoggingLocale(), this.contextOrHostNotFound$str(), host, context);
    }

    protected String needHostAndPort$str() {
        return "WFLYMODCLS0014: Need valid host and port in the form host:port, %s is not valid";
    }

    @Override
    public final String needHostAndPort(String value) {
        return String.format(this.getLoggingLocale(), this.needHostAndPort$str(), value);
    }

    protected String couldNotResolveProxyIpAddress$str() {
        return "WFLYMODCLS0016: No IP address could be resolved for the specified host of the proxy.";
    }

    @Override
    public final String couldNotResolveProxyIpAddress() {
        return String.format(this.getLoggingLocale(), this.couldNotResolveProxyIpAddress$str(), new Object[0]);
    }

    protected String excludedContextsWrongFormat$str() {
        return "WFLYMODCLS0019: '%s' is not a valid value for excluded-contexts.";
    }

    @Override
    public final IllegalArgumentException excludedContextsWrongFormat(String trimmedContexts) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.excludedContextsWrongFormat$str(), trimmedContexts));
        ModClusterLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String bothElytronAndLegacySslContextDefined$str() {
        return "WFLYMODCLS0020: Only one of 'ssl-context' attribute or 'ssl' resource can be defined!";
    }

    @Override
    public final IllegalStateException bothElytronAndLegacySslContextDefined() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.bothElytronAndLegacySslContextDefined$str(), new Object[0]));
        ModClusterLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void excludedContextsUseSlashInsteadROOT() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.excludedContextsUseSlashInsteadROOT$str(), new Object[0]);
    }

    protected String excludedContextsUseSlashInsteadROOT$str() {
        return "WFLYMODCLS0021: Value 'ROOT' for excluded-contexts is deprecated, to exclude the root context use '/' instead.";
    }

    protected String legacyOperationsWithMultipleProxies$str() {
        return "WFLYMODCLS0022: Legacy operations cannot be used with multiple proxy configurations. Use non-deprecated operations at the correct proxy address.";
    }

    @Override
    public final String legacyOperationsWithMultipleProxies() {
        return String.format(this.getLoggingLocale(), this.legacyOperationsWithMultipleProxies$str(), new Object[0]);
    }

    @Override
    public final void errorLoadingModuleForCustomMetric(String moduleName, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorLoadingModuleForCustomMetric$str(), (Object)moduleName);
    }

    protected String errorLoadingModuleForCustomMetric$str() {
        return "WFLYMODCLS0023: Error loading module '%s' to load custom metric from.";
    }
}

