/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPContentTypeSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSBytesMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMapMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSObjectMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSStreamMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSTextMessage;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInvalidContentTypeException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.message.Message;
import org.jboss.logging.Logger;

public final class AMQPMessageSupport {
    private static final Logger logger = Logger.getLogger(AMQPMessageSupport.class);
    public static final String JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL_NAME = "x-opt-jms-reply-to";
    public static final Symbol JMS_MSG_TYPE = Symbol.getSymbol((String)"x-opt-jms-msg-type");
    @Deprecated
    public static final Symbol JMS_DELIVERY_TIME = Symbol.getSymbol((String)"x-opt-delivery-time");
    public static final Symbol SCHEDULED_DELIVERY_TIME = Symbol.getSymbol((String)"x-opt-delivery-time");
    public static final Symbol SCHEDULED_DELIVERY_DELAY = Symbol.getSymbol((String)"x-opt-delivery-delay");
    public static final Symbol ROUTING_TYPE = Symbol.getSymbol((String)"x-opt-routing-type");
    public static final byte JMS_MESSAGE = 0;
    public static final byte JMS_OBJECT_MESSAGE = 1;
    public static final byte JMS_MAP_MESSAGE = 2;
    public static final byte JMS_BYTES_MESSAGE = 3;
    public static final byte JMS_STREAM_MESSAGE = 4;
    public static final byte JMS_TEXT_MESSAGE = 5;
    public static final Symbol SERIALIZED_JAVA_OBJECT_CONTENT_TYPE = Symbol.getSymbol((String)"application/x-java-serialized-object");
    public static final String JMS_AMQP_PREFIX = "JMS_AMQP_";
    public static final int JMS_AMQP_PREFIX_LENGTH = "JMS_AMQP_".length();
    public static final String ORIGINAL_ENCODING = "ORIGINAL_ENCODING";
    public static final String NATIVE = "NATIVE";
    public static final String HEADER = "HEADER";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String FIRST_ACQUIRER = "FirstAcquirer";
    public static final String CONTENT_TYPE = "ContentType";
    public static final String CONTENT_ENCODING = "ContentEncoding";
    public static final String REPLYTO_GROUP_ID = "ReplyToGroupID";
    public static final String DURABLE = "DURABLE";
    public static final String PRIORITY = "PRIORITY";
    public static final String DELIVERY_ANNOTATION_PREFIX = "DA_";
    public static final String MESSAGE_ANNOTATION_PREFIX = "MA_";
    public static final String FOOTER_PREFIX = "FT_";
    public static final String JMS_AMQP_HEADER = "JMS_AMQP_HEADER";
    public static final String JMS_AMQP_HEADER_DURABLE = "JMS_AMQP_HEADERDURABLE";
    public static final String JMS_AMQP_HEADER_PRIORITY = "JMS_AMQP_HEADERPRIORITY";
    public static final String JMS_AMQP_PROPERTIES = "JMS_AMQP_PROPERTIES";
    public static final String JMS_AMQP_NATIVE = "JMS_AMQP_NATIVE";
    public static final String JMS_AMQP_FIRST_ACQUIRER = "JMS_AMQP_FirstAcquirer";
    public static final String JMS_AMQP_CONTENT_TYPE = "JMS_AMQP_ContentType";
    public static final String JMS_AMQP_CONTENT_ENCODING = "JMS_AMQP_ContentEncoding";
    public static final String JMS_AMQP_REPLYTO_GROUP_ID = "JMS_AMQP_ReplyToGroupID";
    public static final String JMS_AMQP_DELIVERY_ANNOTATION_PREFIX = "JMS_AMQP_DA_";
    public static final String JMS_AMQP_MESSAGE_ANNOTATION_PREFIX = "JMS_AMQP_MA_";
    public static final String JMS_AMQP_FOOTER_PREFIX = "JMS_AMQP_FT_";
    public static final String JMS_AMQP_ORIGINAL_ENCODING = "JMS_AMQP_ORIGINAL_ENCODING";
    public static final Binary EMPTY_BINARY = new Binary(new byte[0]);
    public static final Data EMPTY_BODY = new Data(EMPTY_BINARY);
    public static final short AMQP_UNKNOWN = 0;
    public static final short AMQP_NULL = 1;
    public static final short AMQP_DATA = 2;
    public static final short AMQP_SEQUENCE = 3;
    public static final short AMQP_VALUE_NULL = 4;
    public static final short AMQP_VALUE_STRING = 5;
    public static final short AMQP_VALUE_BINARY = 6;
    public static final short AMQP_VALUE_MAP = 7;
    public static final short AMQP_VALUE_LIST = 8;
    public static final Symbol JMS_DEST_TYPE_MSG_ANNOTATION = AMQPMessageSupport.getSymbol("x-opt-jms-dest");
    public static final Symbol JMS_REPLY_TO_TYPE_MSG_ANNOTATION = AMQPMessageSupport.getSymbol("x-opt-jms-reply-to");
    public static final byte QUEUE_TYPE = 0;
    public static final byte TOPIC_TYPE = 1;
    public static final byte TEMP_QUEUE_TYPE = 2;
    public static final byte TEMP_TOPIC_TYPE = 3;
    public static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";

    public static Symbol getSymbol(String key) {
        return Symbol.valueOf((String)key);
    }

    public static Object getMessageAnnotation(String key, Message message) {
        if (message != null && message.getMessageAnnotations() != null) {
            Map annotations = message.getMessageAnnotations().getValue();
            return annotations.get(AMQPMessageSupport.getSymbol(key));
        }
        return null;
    }

    public static boolean isContentType(String contentType, Message message) {
        if (contentType == null) {
            return message.getContentType() == null;
        }
        return contentType.equals(message.getContentType());
    }

    public static boolean isContentType(String expected, Symbol actual) {
        if (expected == null) {
            return actual == null;
        }
        return expected.equals(actual != null ? actual.toString() : actual);
    }

    public static Charset getCharsetForTextualContent(String contentType) {
        try {
            return AMQPContentTypeSupport.parseContentTypeForTextualCharset(contentType);
        }
        catch (ActiveMQAMQPInvalidContentTypeException e) {
            return null;
        }
    }

    public static String toAddress(Destination destination) {
        try {
            if (destination instanceof ActiveMQDestination) {
                return ((ActiveMQDestination)destination).getAddress();
            }
            if (destination instanceof Queue) {
                return ((Queue)destination).getQueueName();
            }
            if (destination instanceof Topic) {
                return ((Topic)destination).getTopicName();
            }
        }
        catch (JMSException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static ServerJMSBytesMessage createBytesMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new ServerJMSBytesMessage((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)4, coreMessageObjectPools));
    }

    public static ServerJMSBytesMessage createBytesMessage(long id, byte[] array, int arrayOffset, int length, CoreMessageObjectPools coreMessageObjectPools) throws JMSException {
        ServerJMSBytesMessage message = AMQPMessageSupport.createBytesMessage(id, coreMessageObjectPools);
        message.writeBytes(array, arrayOffset, length);
        return message;
    }

    public static ServerJMSStreamMessage createStreamMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new ServerJMSStreamMessage((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)6, coreMessageObjectPools));
    }

    public static ServerJMSMessage createMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new ServerJMSMessage((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)0, coreMessageObjectPools));
    }

    public static ServerJMSTextMessage createTextMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new ServerJMSTextMessage((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)3, coreMessageObjectPools));
    }

    public static ServerJMSTextMessage createTextMessage(long id, String text, CoreMessageObjectPools coreMessageObjectPools) throws JMSException {
        ServerJMSTextMessage message = AMQPMessageSupport.createTextMessage(id, coreMessageObjectPools);
        message.setText(text);
        return message;
    }

    public static ServerJMSObjectMessage createObjectMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new ServerJMSObjectMessage((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)2, coreMessageObjectPools));
    }

    public static ServerJMSMessage createObjectMessage(long id, Binary serializedForm, CoreMessageObjectPools coreMessageObjectPools) throws JMSException {
        ServerJMSObjectMessage message = AMQPMessageSupport.createObjectMessage(id, coreMessageObjectPools);
        message.setSerializedForm(serializedForm);
        return message;
    }

    public static ServerJMSMessage createObjectMessage(long id, byte[] array, int offset, int length, CoreMessageObjectPools coreMessageObjectPools) throws JMSException {
        ServerJMSObjectMessage message = AMQPMessageSupport.createObjectMessage(id, coreMessageObjectPools);
        message.setSerializedForm(new Binary(array, offset, length));
        return message;
    }

    public static ServerJMSMapMessage createMapMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new ServerJMSMapMessage((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)5, coreMessageObjectPools));
    }

    public static ServerJMSMapMessage createMapMessage(long id, Map<String, Object> content, CoreMessageObjectPools coreMessageObjectPools) throws JMSException {
        ServerJMSMapMessage message = AMQPMessageSupport.createMapMessage(id, coreMessageObjectPools);
        Set<Map.Entry<String, Object>> set = content.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            Object value = entry.getValue();
            if (value instanceof Binary) {
                Binary binary = (Binary)value;
                value = Arrays.copyOfRange(binary.getArray(), binary.getArrayOffset(), binary.getLength());
            }
            message.setObject(entry.getKey(), value);
        }
        return message;
    }

    private static CoreMessage newMessage(long id, byte messageType, CoreMessageObjectPools coreMessageObjectPools) {
        CoreMessage message = new CoreMessage(id, 512, coreMessageObjectPools);
        message.setType(messageType);
        return message;
    }

    public static byte destinationType(Destination destination) {
        if (destination instanceof Queue) {
            if (destination instanceof TemporaryQueue) {
                return 2;
            }
            return 0;
        }
        if (destination instanceof Topic) {
            if (destination instanceof TemporaryTopic) {
                return 3;
            }
            return 1;
        }
        return 0;
    }

    public static Destination destination(byte destinationType, String address) {
        switch (destinationType) {
            case 2: {
                return new ActiveMQTemporaryQueue(address, null);
            }
            case 3: {
                return new ActiveMQTemporaryTopic(address, null);
            }
            case 1: {
                return new ActiveMQTopic(address);
            }
            case 0: {
                return new ActiveMQQueue(address);
            }
        }
        return new ActiveMQQueue(address);
    }
}

