/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.toolchain;

import java.io.File;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.BaseForkOptionsConverter;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.spec.PlayCompileSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.HierarchicalClassLoaderStructure;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerFactory;

public class DaemonPlayCompiler<T extends PlayCompileSpec>
extends AbstractDaemonCompiler<T> {
    private final Class<? extends Compiler<T>> compilerClass;
    private final Object[] compilerConstructorArguments;
    private final Iterable<File> compilerClasspath;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final File daemonWorkingDir;

    public DaemonPlayCompiler(File daemonWorkingDir, Class<? extends Compiler<T>> compilerClass, Object[] compilerConstructorArguments, WorkerDaemonFactory workerDaemonFactory, Iterable<File> compilerClasspath, JavaForkOptionsFactory forkOptionsFactory, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        super((WorkerFactory)workerDaemonFactory, actionExecutionSpecFactory);
        this.compilerClass = compilerClass;
        this.compilerConstructorArguments = compilerConstructorArguments;
        this.compilerClasspath = compilerClasspath;
        this.forkOptionsFactory = forkOptionsFactory;
        this.daemonWorkingDir = daemonWorkingDir;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    protected AbstractDaemonCompiler.CompilerParameters getCompilerParameters(T spec) {
        return new PlayCompilerParameters<T>(this.compilerClass.getName(), this.compilerConstructorArguments, spec);
    }

    protected DaemonForkOptions toDaemonForkOptions(PlayCompileSpec spec) {
        BaseForkOptions forkOptions = spec.getForkOptions();
        JavaForkOptions javaForkOptions = new BaseForkOptionsConverter(this.forkOptionsFactory).transform(forkOptions);
        javaForkOptions.setWorkingDir(this.daemonWorkingDir);
        ClassPath playCompilerClasspath = this.classPathRegistry.getClassPath("PLAY-COMPILER").plus(DefaultClassPath.of(this.compilerClasspath));
        HierarchicalClassLoaderStructure classLoaderStructure = new HierarchicalClassLoaderStructure((ClassLoaderSpec)this.classLoaderRegistry.getGradleWorkerExtensionSpec()).withChild((ClassLoaderSpec)this.getPlayFilterSpec()).withChild((ClassLoaderSpec)new VisitableURLClassLoader.Spec("compiler", playCompilerClasspath.getAsURLs()));
        return new DaemonForkOptionsBuilder(this.forkOptionsFactory).javaForkOptions(javaForkOptions).withClassLoaderStructure((ClassLoaderStructure)classLoaderStructure).keepAliveMode(KeepAliveMode.SESSION).build();
    }

    private FilteringClassLoader.Spec getPlayFilterSpec() {
        FilteringClassLoader.Spec gradleApiAndPlaySpec = this.classLoaderRegistry.getGradleApiFilterSpec();
        gradleApiAndPlaySpec.disallowPackage("org.gradle.play");
        gradleApiAndPlaySpec.allowPackage("com.google");
        gradleApiAndPlaySpec.allowPackage("org.apache.commons.lang");
        return gradleApiAndPlaySpec;
    }

    public static class PlayCompilerParameters<T extends PlayCompileSpec>
    extends AbstractDaemonCompiler.CompilerParameters {
        private final T compileSpec;

        public PlayCompilerParameters(String compilerClassName, Object[] compilerInstanceParameters, T compileSpec) {
            super(compilerClassName, compilerInstanceParameters);
            this.compileSpec = compileSpec;
        }

        public T getCompileSpec() {
            return this.compileSpec;
        }
    }
}

