/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultArtifactIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

public class UrlBackedArtifactMetadata
implements ModuleComponentArtifactMetadata {
    private final ModuleComponentIdentifier componentIdentifier;
    private final String relativeUrl;
    private final ModuleComponentFileArtifactIdentifier id;

    public UrlBackedArtifactMetadata(ModuleComponentIdentifier componentIdentifier, String fileName, String relativeUrl) {
        this.componentIdentifier = componentIdentifier;
        this.relativeUrl = relativeUrl;
        this.id = new ModuleComponentFileArtifactIdentifier(componentIdentifier, fileName);
    }

    public ModuleComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    @Override
    public ModuleComponentArtifactIdentifier getId() {
        return this.id;
    }

    public String getRelativeUrl() {
        return this.relativeUrl;
    }

    @Override
    public ArtifactIdentifier toArtifactIdentifier() {
        ArtifactFile names = new ArtifactFile(this.relativeUrl, this.componentIdentifier.getVersion());
        return new DefaultArtifactIdentifier(DefaultModuleVersionIdentifier.newId(this.componentIdentifier), names.getName(), names.getExtension(), names.getExtension(), names.getClassifier());
    }

    @Override
    public IvyArtifactName getName() {
        ArtifactFile names = new ArtifactFile(this.relativeUrl, this.componentIdentifier.getVersion());
        return new DefaultIvyArtifactName(names.getName(), names.getExtension(), names.getExtension(), names.getClassifier());
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return TaskDependencyInternal.EMPTY;
    }
}

