/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotData;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.MinimalPersistentCache;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemSnapshotter;

public class DefaultClasspathEntrySnapshotCache
implements ClasspathEntrySnapshotCache {
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final MinimalPersistentCache<HashCode, ClasspathEntrySnapshotData> cache;

    public DefaultClasspathEntrySnapshotCache(FileSystemSnapshotter fileSystemSnapshotter, PersistentIndexedCache<HashCode, ClasspathEntrySnapshotData> persistentCache) {
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.cache = new MinimalPersistentCache(persistentCache);
    }

    @Override
    public ClasspathEntrySnapshot get(File file, HashCode hash) {
        ClasspathEntrySnapshotData data = (ClasspathEntrySnapshotData)this.cache.get((Object)hash);
        return data != null ? new ClasspathEntrySnapshot(data) : null;
    }

    public ClasspathEntrySnapshot get(File key, final Factory<ClasspathEntrySnapshot> factory) {
        HashCode fileContentHash = this.fileSystemSnapshotter.snapshot(key).getHash();
        return new ClasspathEntrySnapshot((ClasspathEntrySnapshotData)this.cache.get((Object)fileContentHash, (Factory)new Factory<ClasspathEntrySnapshotData>(){

            public ClasspathEntrySnapshotData create() {
                return ((ClasspathEntrySnapshot)factory.create()).getData();
            }
        }));
    }
}

