/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.Scrollable;

class ImagePreview
extends JComponent
implements Scrollable {
    private int maxUnitIncrement = 1;
    private ImageIcon pic;

    public ImagePreview(ImageIcon pic) {
        this.setImage(pic);
    }

    public ImagePreview() {
        this(null);
    }

    public int getOriginalWidth() {
        if (this.pic != null) {
            return this.pic.getIconWidth();
        }
        return -1;
    }

    public int getOriginalHeight() {
        if (this.pic != null) {
            return this.pic.getIconHeight();
        }
        return -1;
    }

    public void setImage(ImageIcon pic) {
        this.pic = pic;
        if (pic != null) {
            this.getGraphics().clearRect(0, 0, this.getWidth(), this.getHeight());
            this.paint(this.getGraphics());
        }
    }

    public void paint(Graphics g) {
        if (this.pic != null) {
            int dWidth = this.pic.getIconWidth();
            int dHeight = this.pic.getIconHeight();
            int scale = this.getScale();
            dWidth = dWidth * scale / 100;
            dHeight = dHeight * scale / 100;
            g.drawImage(this.pic.getImage(), 0, 0, dWidth, dHeight, this);
        }
    }

    public int getScale() {
        int scale = 100;
        if (this.pic != null) {
            int vPct = 100;
            int hPct = 100;
            Dimension ps = this.getPreferredSize();
            hPct = (int)(ps.getWidth() / ((double)this.pic.getIconWidth() / 100.0));
            scale = hPct < (vPct = (int)(ps.getHeight() / ((double)this.pic.getIconHeight() / 100.0))) ? hPct : vPct;
        }
        return scale;
    }

    public void setPreviewWidth(int newWidth) {
        if (this.pic != null) {
            try {
                int hPct = (int)((double)newWidth / ((double)this.getOriginalWidth() / 100.0));
                int newHeight = this.getOriginalHeight() * hPct / 100;
                this.setPreferredSize(new Dimension(newWidth, newHeight));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setPreferredSize(new Dimension(20, 20));
            }
            this.revalidate();
        }
    }

    public void setPreviewHeight(int newHeight) {
        if (this.pic != null) {
            try {
                int vPct = (int)((double)newHeight / ((double)this.getOriginalHeight() / 100.0));
                int newWidth = this.getOriginalWidth() * vPct / 100;
                this.setPreferredSize(new Dimension(newWidth, newHeight));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setPreferredSize(new Dimension(20, 20));
            }
            this.revalidate();
        }
    }

    public void setScale(int newScale) {
        int newWidth = this.getOriginalWidth() * newScale / 100;
        int newHeight = this.getOriginalHeight() * newScale / 100;
        this.setPreferredSize(new Dimension(newWidth, newHeight));
        this.revalidate();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int pixels) {
        this.maxUnitIncrement = pixels;
    }
}

