/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.base14.Symbol;
import org.apache.fop.fonts.base14.ZapfDingbats;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFXObject;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public class PDFResources
extends PDFDictionary {
    protected Map<String, PDFDictionary> fonts = new LinkedHashMap<String, PDFDictionary>();
    protected Set<PDFXObject> xObjects = new LinkedHashSet<PDFXObject>();
    protected Map<LazyName, PDFColorSpace> colorSpaces = new LinkedHashMap<LazyName, PDFColorSpace>();
    protected Map<String, PDFICCBasedColorSpace> iccColorSpaces = new LinkedHashMap<String, PDFICCBasedColorSpace>();
    private PDFResources parent;
    private PDFDictionary fontsObj;
    private Map<String, PDFDictionary> fontsObjDict = new LinkedHashMap<String, PDFDictionary>();
    protected Map<String, PDFReference> properties = new LinkedHashMap<String, PDFReference>();
    protected Set<PDFResourceContext> contexts = new LinkedHashSet<PDFResourceContext>();

    public PDFResources(PDFDocument doc) {
        this.setObjectNumber(doc);
    }

    public void addContext(PDFResourceContext c) {
        this.contexts.add(c);
    }

    public void setParentResources(PDFResources p) {
        this.parent = p;
    }

    public PDFResources getParentResources() {
        return this.parent;
    }

    public void addFont(PDFFont font) {
        this.addFont(font.getName(), font);
    }

    public void addFont(String name, PDFDictionary font) {
        if (this.fontsObj != null) {
            this.fontsObj.put(name, font);
            this.fontsObjDict.put(name, font);
        } else {
            this.fonts.put(name, font);
        }
    }

    public void createFontsAsObj() {
        this.fontsObj = new PDFDictionary();
        this.getDocument().registerTrailerObject(this.fontsObj);
        this.put("Font", this.fontsObj);
    }

    public void addFonts(PDFDocument doc, FontInfo fontInfo) {
        Map<String, Typeface> usedFonts = fontInfo.getUsedFonts();
        for (Map.Entry<String, Typeface> e : usedFonts.entrySet()) {
            String f = e.getKey();
            Typeface font = e.getValue();
            if (!font.hadMappingOperations()) continue;
            FontDescriptor desc = null;
            if (font instanceof FontDescriptor) {
                desc = (FontDescriptor)((Object)font);
            }
            String encoding = font.getEncodingName();
            if (font instanceof Symbol || font instanceof ZapfDingbats) {
                encoding = null;
            }
            this.addFont(doc.getFactory().makeFont(f, font.getEmbedFontName(), encoding, font, desc));
        }
    }

    public void addXObject(PDFXObject xObject) {
        this.xObjects.add(xObject);
    }

    public void addColorSpace(PDFColorSpace colorSpace) {
        this.colorSpaces.put(new LazyName(colorSpace), colorSpace);
        if (colorSpace instanceof PDFICCBasedColorSpace) {
            PDFICCBasedColorSpace icc = (PDFICCBasedColorSpace)colorSpace;
            String desc = ColorProfileUtil.getICCProfileDescription((ICC_Profile)icc.getICCStream().getICCProfile());
            this.iccColorSpaces.put(desc, icc);
        }
    }

    public PDFICCBasedColorSpace getICCColorSpaceByProfileName(String desc) {
        PDFICCBasedColorSpace cs = this.iccColorSpaces.get(desc);
        return cs;
    }

    public PDFColorSpace getColorSpace(PDFName name) {
        for (Map.Entry<LazyName, PDFColorSpace> x : this.colorSpaces.entrySet()) {
            if (!x.getKey().getName().equals(name)) continue;
            return x.getValue();
        }
        return null;
    }

    public void addProperty(String name, PDFReference property) {
        this.properties.put(name, property);
    }

    public PDFReference getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public int output(OutputStream stream) throws IOException {
        this.populateDictionary();
        return super.output(stream);
    }

    /*
     * WARNING - void declaration
     */
    private void populateDictionary() {
        if (this.parent != null && this.parent.fontsObj != null) {
            this.put("Font", this.parent.fontsObj);
        }
        if (!this.fonts.isEmpty() || this.parent != null && !this.parent.fonts.isEmpty()) {
            PDFDictionary dict3 = new PDFDictionary(this);
            for (Map.Entry<String, PDFDictionary> entry : this.fonts.entrySet()) {
                dict3.put(entry.getKey(), entry.getValue());
            }
            if (this.parent != null) {
                for (Map.Entry<String, PDFDictionary> entry : this.parent.fonts.entrySet()) {
                    dict3.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, PDFDictionary> entry : this.parent.fontsObjDict.entrySet()) {
                    dict3.put(entry.getKey(), entry.getValue());
                }
            }
            this.put("Font", dict3);
        }
        LinkedHashSet<PDFPattern> patterns = new LinkedHashSet<PDFPattern>();
        LinkedHashSet<PDFShading> shadings = new LinkedHashSet<PDFShading>();
        LinkedHashSet<PDFGState> gstates = new LinkedHashSet<PDFGState>();
        for (PDFResourceContext pDFResourceContext : this.contexts) {
            this.xObjects.addAll(pDFResourceContext.getXObjects());
            patterns.addAll(pDFResourceContext.getPatterns());
            shadings.addAll(pDFResourceContext.getShadings());
            gstates.addAll(pDFResourceContext.getGStates());
        }
        if (this.parent != null) {
            this.xObjects.addAll(this.parent.xObjects);
        }
        if (!shadings.isEmpty()) {
            PDFDictionary dict2 = new PDFDictionary(this);
            for (PDFShading shading : shadings) {
                dict2.put(shading.getName(), shading);
            }
            this.put("Shading", dict2);
        }
        if (!patterns.isEmpty()) {
            PDFDictionary dict = new PDFDictionary(this);
            for (PDFPattern pattern : patterns) {
                dict.put(pattern.getName(), pattern);
            }
            this.put("Pattern", dict);
        }
        PDFArray procset = new PDFArray(this);
        procset.add(new PDFName("PDF"));
        procset.add(new PDFName("ImageB"));
        procset.add(new PDFName("ImageC"));
        procset.add(new PDFName("Text"));
        this.put("ProcSet", procset);
        if (!this.xObjects.isEmpty()) {
            void var5_12;
            PDFDictionary pDFDictionary = (PDFDictionary)this.get("XObject");
            if (pDFDictionary == null) {
                PDFDictionary pDFDictionary2 = new PDFDictionary(this);
            }
            for (PDFXObject pDFXObject : this.xObjects) {
                var5_12.put(pDFXObject.getName().toString(), pDFXObject);
            }
            this.put("XObject", var5_12);
        }
        if (!gstates.isEmpty()) {
            PDFDictionary pDFDictionary = new PDFDictionary(this);
            for (PDFGState pDFGState : gstates) {
                pDFDictionary.put(pDFGState.getName(), pDFGState);
            }
            this.put("ExtGState", pDFDictionary);
        }
        if (!this.colorSpaces.isEmpty()) {
            PDFDictionary pDFDictionary = new PDFDictionary(this);
            for (PDFColorSpace pDFColorSpace : this.colorSpaces.values()) {
                pDFDictionary.put(pDFColorSpace.getName(), pDFColorSpace);
            }
            this.put("ColorSpace", pDFDictionary);
        }
        if (!this.properties.isEmpty()) {
            PDFDictionary pDFDictionary = new PDFDictionary(this);
            for (Map.Entry entry : this.properties.entrySet()) {
                pDFDictionary.put((String)entry.getKey(), entry.getValue());
            }
            this.put("Properties", pDFDictionary);
        }
    }

    @Override
    public void getChildren(Set<PDFObject> children) {
        this.getChildren(children, false);
    }

    private void getChildren(Set<PDFObject> children, boolean isParent) {
        super.getChildren(children);
        for (PDFDictionary f : this.fonts.values()) {
            children.add(f);
            f.getChildren(children);
        }
        for (PDFResourceContext c : this.contexts) {
            for (PDFXObject pDFXObject : c.getXObjects()) {
                children.add(pDFXObject);
                pDFXObject.getChildren(children);
            }
            for (PDFPattern pDFPattern : c.getPatterns()) {
                children.add(pDFPattern);
                pDFPattern.getChildren(children);
            }
            for (PDFShading pDFShading : c.getShadings()) {
                children.add(pDFShading);
                pDFShading.getChildren(children);
            }
            for (PDFGState pDFGState : c.getGStates()) {
                children.add(pDFGState);
                pDFGState.getChildren(children);
            }
        }
        if (!isParent) {
            for (PDFColorSpace x : this.colorSpaces.values()) {
                children.add((PDFObject)((Object)x));
                ((PDFObject)((Object)x)).getChildren(children);
            }
        }
        if (this.parent != null) {
            this.parent.getChildren(children, true);
        }
    }

    static class LazyName {
        private PDFColorSpace colorSpace;

        public LazyName(PDFColorSpace colorSpace) {
            this.colorSpace = colorSpace;
        }

        public PDFName getName() {
            return new PDFName(this.colorSpace.getName());
        }
    }
}

