/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.server.core.builtin.DefaultPHPServerRunner;
import org.eclipse.php.internal.server.core.builtin.PHPServerRunnerConfiguration;
import org.eclipse.php.internal.server.core.builtin.debugger.HttpReverseProxyServer;
import org.eclipse.php.internal.server.core.builtin.debugger.PHPServerDebugTarget;

public class DefaultPHPServerDebugger
extends DefaultPHPServerRunner {
    private HttpReverseProxyServer proxyServer;

    @Override
    public void run(PHPServerRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        super.run(configuration, launch, monitor);
        PHPServerDebugTarget target = new PHPServerDebugTarget(launch, launch.getProcesses()[0]);
        launch.addDebugTarget((IDebugTarget)target);
        IDebugParametersInitializer parametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer((ILaunch)launch);
        String query = PHPLaunchUtilities.generateQuery((ILaunch)launch, (IDebugParametersInitializer)parametersInitializer);
        this.proxyServer = new HttpReverseProxyServer(new HttpRequestHandler(this.getServerPort(), query));
        try {
            this.proxyServer.start(configuration.getPort());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (this.proxyServer != null) {
            this.proxyServer.stop();
        }
    }

    class HttpRequestHandler
    implements HttpReverseProxyServer.IHttpRequestHandler {
        private int fPort;
        private String fDebugQuery;

        HttpRequestHandler(int port, String debugQuery) {
            this.fPort = port;
            this.fDebugQuery = debugQuery;
        }

        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpResponse response1 = client.execute(new HttpHost("localhost", this.fPort), this.createHttpRequest(request));
            response.setEntity(response1.getEntity());
            response.setStatusCode(response1.getStatusLine().getStatusCode());
        }

        private HttpRequest createHttpRequest(HttpRequest request) throws UnsupportedEncodingException {
            String uri = request.getRequestLine().getUri();
            uri = uri.indexOf(63) == -1 ? String.valueOf(uri) + '?' + this.fDebugQuery : String.valueOf(uri) + '&' + this.fDebugQuery;
            BasicHttpRequest newRequest = new BasicHttpRequest(request.getRequestLine().getMethod(), uri, request.getProtocolVersion());
            newRequest.setHeaders(request.getAllHeaders());
            newRequest.setParams(request.getParams());
            return newRequest;
        }

        @Override
        public void close(HttpServerConnection connection) throws IOException {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

