/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.notifications;

import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.builds.ui.spi.BuildServerWizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.notifications.core.AbstractNotification;
import org.eclipse.mylyn.commons.notifications.core.NotificationSinkEvent;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.commons.notifications.ui.NotificationControl;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.internal.builds.ui.notifications.Messages;
import org.eclipse.mylyn.internal.builds.ui.view.NewBuildServerAction;
import org.eclipse.mylyn.internal.commons.repositories.ui.wizards.NewRepositoryWizardRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class BuildsServiceMessageControl
extends NotificationControl {
    private final CopyOnWriteArrayList<AbstractNotification> messages = new CopyOnWriteArrayList();

    public BuildsServiceMessageControl(Composite parent) {
        super(parent);
    }

    protected void closeMessage() {
        if (this.messages.isEmpty()) {
            this.close();
        } else {
            this.nextMessage();
        }
    }

    private void nextMessage() {
        if (!this.messages.isEmpty()) {
            AbstractNotification message = this.messages.remove(0);
            if (this.ensureControl()) {
                this.setTitle(message.getLabel());
                this.setDescription(message.getDescription());
                if (message instanceof AbstractUiNotification) {
                    this.setTitleImage(((AbstractUiNotification)message).getNotificationKindImage());
                }
                this.setEventId(message.getEventId());
            }
        }
    }

    private void openRepositoryWizard(String data) {
        block8: {
            String connectorKind = data;
            if (data.indexOf(63) > -1) {
                connectorKind = data.substring(0, data.indexOf(63));
            }
            IWizardDescriptor descriptor = NewRepositoryWizardRegistry.getInstance().findWizard(connectorKind);
            try {
                if (descriptor == null) break block8;
                IWorkbenchWizard wizard = descriptor.createWizard();
                if (wizard instanceof BuildServerWizard) {
                    try {
                        HashMap<String, String> properties = new HashMap<String, String>();
                        int i = data.indexOf(63);
                        if (i > -1) {
                            String[] props;
                            String[] stringArray = props = data.substring(i + 1).split("&");
                            int n = props.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String set = stringArray[n2];
                                String[] kv = set.split("=");
                                properties.put(kv[0], kv[1]);
                                ++n2;
                            }
                        }
                        IBuildServer bs = BuildsUi.createServer(connectorKind);
                        RepositoryLocation rl = new RepositoryLocation(properties);
                        bs.getLocation().apply(rl);
                        ((BuildServerWizard)wizard).setBuildServer(bs);
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", Messages.BuildsServiceMessageControl_ErrorStartingWizard, (Throwable)e));
                    }
                }
                WizardDialog wd = new WizardDialog(this.getShell(), (IWizard)wizard);
                wd.setTitle(wizard.getWindowTitle());
                wd.open();
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", Messages.BuildsServiceMessageControl_ErrorStartingWizard, (Throwable)e));
            }
        }
    }

    protected SelectionListener getLinkListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.text != null) {
                    String cmd = null;
                    String args = null;
                    if (e.text.contains(":")) {
                        cmd = e.text.substring(0, e.text.indexOf(58)).toLowerCase();
                        args = e.text.substring(e.text.indexOf(58) + 1);
                    } else {
                        cmd = e.text.toLowerCase();
                    }
                    if (cmd.equals("create")) {
                        BuildsServiceMessageControl.this.closeMessage();
                        new NewBuildServerAction().run();
                    } else if (cmd.equals("discover")) {
                        BuildsServiceMessageControl.this.closeMessage();
                        if (args != null) {
                            BuildsServiceMessageControl.this.openRepositoryWizard(args);
                        }
                    }
                }
            }
        };
    }

    public void notify(NotificationSinkEvent event) {
        for (AbstractNotification message : event.getNotifications()) {
            this.messages.add(message);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildsServiceMessageControl.this.isClosed()) {
                    BuildsServiceMessageControl.this.nextMessage();
                }
            }
        });
    }
}

