/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenMappingGroup
implements IDataDrivenRuntimeObject {
    private final Collection<DataDrivenMappingEntry> fEntries;
    private final String fId;

    public DataDrivenMappingGroup(String id, Collection<DataDrivenMappingEntry> entries) {
        this.fEntries = ImmutableSet.copyOf(entries);
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public @Nullable Object map(@Nullable ITmfEvent event, int baseQuark, @Nullable DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container, @Nullable Object resolvedValue) {
        for (DataDrivenMappingEntry entry : this.fEntries) {
            Object value = entry.getKey().getValue(event, baseQuark, scenarioInfo, container);
            if (resolvedValue != value && (resolvedValue == null || !resolvedValue.equals(value))) continue;
            return entry.getValue().getValue(event, baseQuark, scenarioInfo, container);
        }
        return null;
    }

    public static class DataDrivenMappingEntry {
        private final DataDrivenValue fKey;
        private final DataDrivenValue fValue;

        public DataDrivenMappingEntry(DataDrivenValue key, DataDrivenValue value) {
            this.fKey = key;
            this.fValue = value;
        }

        public DataDrivenValue getKey() {
            return this.fKey;
        }

        public DataDrivenValue getValue() {
            return this.fValue;
        }
    }
}

