/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class ExasolTableColumnManager
extends SQLTableColumnManager<ExasolTableColumn, ExasolTableBase>
implements DBEObjectRenamer<ExasolTableColumn> {
    private static final String SQL_ALTER = "ALTER TABLE %s MODIFY COLUMN %s ";
    private static final String SQL_COMMENT = "COMMENT ON COLUMN %s.%s IS '%s'";
    private static final Log log = Log.getLog(ExasolTableColumnManager.class);
    private static final String CMD_ALTER = "Alter Column";
    private static final String CMD_COMMENT = "Comment on Column";
    private static final String DROP_DIST_KEY = "ALTER TABLE %s DROP DISTRIBUTION KEYS";
    private static final String CREATE_DIST_KEY = "ALTER TABLE %s DISTRIBUTE BY %s";

    @Nullable
    public DBSObjectCache<? extends DBSObject, ExasolTableColumn> getObjectsCache(ExasolTableColumn object) {
        return ((ExasolSchema)((ExasolTableBase)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((ExasolTable)object.getParentObject());
    }

    public boolean canEditObject(ExasolTableColumn object) {
        ExasolTableBase exasolTableBase = (ExasolTableBase)object.getParentObject();
        return exasolTableBase != null & exasolTableBase.getClass().equals(ExasolTable.class);
    }

    protected ExasolTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        ExasolTableColumn column = new ExasolTableColumn((ExasolTableBase)container);
        column.setName(this.getNewColumnName(monitor, context, (DBSEntity)((ExasolTableBase)container)));
        return column;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        DBEPersistAction commentAction;
        ExasolTableColumn exasolColumn = (ExasolTableColumn)command.getObject();
        Map props = command.getProperties();
        if (props.containsKey("defaultValue") || props.containsKey("dataType") || props.containsKey("scale") || props.containsKey("maxLength") || props.containsKey("autoGenerated") || props.containsKey("identityValue") || props.containsKey("required")) {
            String deltaSQL;
            String nullability = "";
            if (exasolColumn.isOriRequired() != null && exasolColumn.isOriRequired().booleanValue() != exasolColumn.isRequired()) {
                nullability = exasolColumn.isRequired() ? "NOT NULL" : "NULL";
            }
            if (!(deltaSQL = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)exasolColumn)) + " " + exasolColumn.getFormatType() + " " + (exasolColumn.getDefaultValue() == null ? "" : " DEFAULT " + exasolColumn.getDefaultValue()) + " " + this.formatIdentiy(exasolColumn.isAutoGenerated(), exasolColumn.getIdentityValue()) + " " + nullability).isEmpty()) {
                String sqlAlterColumn = String.format(SQL_ALTER, ((ExasolTableBase)exasolColumn.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL), deltaSQL);
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction(CMD_ALTER, sqlAlterColumn));
            }
        }
        if ((commentAction = this.buildCommentAction(exasolColumn)) != null) {
            actionList.add(commentAction);
        }
        if (command.getProperties().containsKey("distKey")) {
            try {
                actionList.addAll(this.modifyDistKey(exasolColumn));
            }
            catch (DBException e) {
                log.error((Object)"Failed to modify distkey settings", (Throwable)e);
            }
        }
    }

    private String formatIdentiy(Boolean isAutoGenerated, BigDecimal identityValue) {
        String ret = "";
        if (isAutoGenerated.booleanValue()) {
            ret = "IDENTITY ";
            if (identityValue != null) {
                ret = String.valueOf(ret) + identityValue.toString() + " ";
            }
        }
        return ret;
    }

    private DBEPersistAction buildCommentAction(ExasolTableColumn exasolColumn) {
        if (CommonUtils.isNotEmpty((String)exasolColumn.getDescription())) {
            String tableName = ((ExasolTableBase)exasolColumn.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
            String columnName = DBUtils.getObjectFullName((DBPNamedObject)exasolColumn, (DBPEvaluationContext)DBPEvaluationContext.DDL);
            String comment = exasolColumn.getDescription();
            String commentSQL = String.format(SQL_COMMENT, tableName, columnName, ExasolUtils.quoteString(comment));
            return new SQLDatabasePersistAction(CMD_COMMENT, commentSQL);
        }
        return null;
    }

    public void renameObject(DBECommandContext commandContext, ExasolTableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolTableColumn column = (ExasolTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + ((ExasolTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        ExasolTableColumn exasolColumn = (ExasolTableColumn)command.getObject();
        String nullability = exasolColumn.isRequired() ? "NOT NULL" : "NULL";
        String addSQL = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)exasolColumn)) + " " + exasolColumn.getFormatType() + " " + (exasolColumn.getDefaultValue() == null ? "" : " DEFAULT " + exasolColumn.getDefaultValue()) + " " + this.formatIdentiy(exasolColumn.isAutoGenerated(), exasolColumn.getIdentityValue()) + " " + nullability;
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Add column", "ALTER TABLE " + ((ExasolTableBase)exasolColumn.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD COLUMN " + addSQL + " "));
        if (exasolColumn.isDistKey().booleanValue()) {
            try {
                this.modifyDistKey(exasolColumn);
            }
            catch (DBException e) {
                log.error((Object)"Failed to generate distribution key", (Throwable)e);
            }
        }
    }

    private SQLDatabasePersistAction generateDropDist(ExasolTableColumn exasolColumn) {
        return new SQLDatabasePersistAction("Drop Distribution Key", String.format(DROP_DIST_KEY, ((ExasolTableBase)exasolColumn.getParentObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    private SQLDatabasePersistAction generateCreateDist(Collection<ExasolTableColumn> distKey) {
        ExasolTable table = null;
        ArrayList<String> names = new ArrayList<String>();
        for (ExasolTableColumn c : distKey) {
            if (table == null) {
                table = (ExasolTable)c.getParentObject();
            }
            names.add(c.getName());
        }
        return new SQLDatabasePersistAction("Create Distribution Key", String.format(CREATE_DIST_KEY, table.getFullyQualifiedName(DBPEvaluationContext.DDL), CommonUtils.joinStrings((String)",", names)));
    }

    private Collection<SQLDatabasePersistAction> modifyDistKey(ExasolTableColumn exasolColumn) throws DBException {
        ExasolTable table = (ExasolTable)exasolColumn.getParentObject();
        Collection<ExasolTableColumn> distKey = table.getDistributionKey((DBRProgressMonitor)new VoidProgressMonitor());
        ArrayList<SQLDatabasePersistAction> commands = new ArrayList<SQLDatabasePersistAction>();
        if (table.getHasDistKey((DBRProgressMonitor)new VoidProgressMonitor()).booleanValue()) {
            commands.add(this.generateDropDist(exasolColumn));
        }
        if (!distKey.isEmpty()) {
            commands.add(this.generateCreateDist(distKey));
        }
        return commands;
    }
}

