/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.EditorPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.binary.BinaryContent;
import org.jkiss.dbeaver.ui.editors.binary.HexEditControl;
import org.jkiss.dbeaver.ui.editors.binary.HexManager;
import org.jkiss.dbeaver.ui.editors.binary.internal.BinaryEditorMessages;
import org.jkiss.dbeaver.ui.editors.binary.pref.HexPreferencesPage;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class BinaryEditor
extends EditorPart
implements ISelectionProvider,
IMenuListener,
IResourceChangeListener {
    private static final Log log = Log.getLog(HexEditControl.class);
    private HexManager manager;
    private DBPPreferenceListener preferencesChangeListener = null;
    private Set<ISelectionChangedListener> selectionListeners = null;

    protected HexManager getManager() {
        return this.manager;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IPath localPath = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IPathEditorInput) {
            localPath = ((IPathEditorInput)input).getPath();
        }
        if (localPath == null) {
            return;
        }
        if ((localPath = ContentUtils.convertPathToWorkspacePath((IPath)localPath)) == null) {
            return;
        }
        if ((delta = delta.findMember(localPath)) == null) {
            return;
        }
        if (delta.getKind() == 4) {
            UIUtils.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (BinaryEditor.this.manager != null) {
                        BinaryEditor.this.loadBinaryContent();
                    }
                }
            });
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener == null) {
            return;
        }
        if (this.selectionListeners == null) {
            this.selectionListeners = new HashSet<ISelectionChangedListener>();
        }
        this.selectionListeners.add(listener);
    }

    public void createPartControl(Composite parent) {
        IStorage storage = EditorUtils.getStorageFromInput((Object)this.getEditorInput());
        this.manager = new HexManager();
        this.manager.setTextFont(HexPreferencesPage.getPrefFontData());
        this.manager.setDefWidth(HexPreferencesPage.getDefaultWidth());
        this.manager.setMenuListener(this);
        int editorStyle = 0;
        if (storage != null && storage.isReadOnly()) {
            editorStyle = 8;
        }
        this.manager.createEditorPart(parent, editorStyle);
        FillLayout fillLayout = new FillLayout();
        parent.setLayout((Layout)fillLayout);
        this.loadBinaryContent();
        IActionBars bars = this.getEditorSite().getActionBars();
        this.createEditorAction(bars, "org.eclipse.ui.edit.undo");
        this.createEditorAction(bars, "org.eclipse.ui.edit.redo");
        this.createEditorAction(bars, "org.eclipse.ui.edit.cut");
        this.createEditorAction(bars, "org.eclipse.ui.edit.copy");
        this.createEditorAction(bars, "org.eclipse.ui.edit.paste");
        this.createEditorAction(bars, "org.eclipse.ui.edit.delete");
        this.createEditorAction(bars, "org.eclipse.ui.edit.selectAll");
        this.createEditorAction(bars, "org.eclipse.ui.edit.findReplace");
        this.createEditorAction(bars, "GotoLine");
        this.manager.addListener(new Listener(){

            public void handleEvent(Event event) {
                BinaryEditor.this.firePropertyChange(257);
                BinaryEditor.this.updateActionsStatus();
            }
        });
        bars.updateActionBars();
        this.preferencesChangeListener = new DBPPreferenceListener(){

            public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
                if ("prop.hex.font.data".equals(event.getProperty())) {
                    BinaryEditor.this.manager.setTextFont((FontData)event.getNewValue());
                }
                if ("default.hex.width".equals(event.getProperty())) {
                    BinaryEditor.this.manager.setDefWidth((String)event.getNewValue());
                }
            }
        };
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.addPropertyChangeListener(this.preferencesChangeListener);
        this.manager.addLongSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BinaryEditor.this.selectionListeners == null) {
                    return;
                }
                long[] longSelection = HexEditControl.getLongSelection(e);
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)BinaryEditor.this, (ISelection)new StructuredSelection(new Object[]{longSelection[0], longSelection[1]}));
                for (ISelectionChangedListener selectionListener : BinaryEditor.this.selectionListeners) {
                    selectionListener.selectionChanged(event);
                }
            }
        });
    }

    private void createEditorAction(IActionBars bars, String id) {
        bars.setGlobalActionHandler(id, (IAction)new EditorAction(id));
    }

    private void loadBinaryContent() {
        String charset = GeneralUtils.UTF8_ENCODING;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IEncodingSupport) {
            charset = ((IEncodingSupport)editorInput).getEncoding();
        }
        File systemFile = null;
        if (editorInput instanceof IPathEditorInput) {
            systemFile = ((IPathEditorInput)editorInput).getPath().toFile();
        }
        if (systemFile != null) {
            try {
                this.manager.openFile(systemFile, charset);
            }
            catch (IOException e) {
                log.error((Object)"Can't open binary content", (Throwable)e);
            }
            this.setPartName(systemFile.getName());
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.removePropertyChangeListener(this.preferencesChangeListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput editorInput = this.getEditorInput();
        IFile file = EditorUtils.getFileFromInput((IEditorInput)editorInput);
        if (file != null) {
            IPath absolutePath = file.getLocation();
            File systemFile = absolutePath.toFile();
            try {
                this.manager.getContent().get(systemFile);
            }
            catch (IOException e) {
                log.error((Object)"Can't save binary content", (Throwable)e);
            }
            ContentUtils.syncFile((DBRProgressMonitor)RuntimeUtils.makeMonitor((IProgressMonitor)monitor), (IResource)file);
        }
    }

    public void doSaveAs() {
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (BinaryContent.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.manager.getContent());
        }
        if (HexManager.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.manager);
        }
        return (T)super.getAdapter(adapter);
    }

    public ISelection getSelection() {
        long[] longSelection = this.manager.getSelection();
        return new StructuredSelection(new Object[]{longSelection[0], longSelection[1]});
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        boolean reset = this.getEditorInput() != null;
        this.setSite((IWorkbenchPartSite)site);
        if (!(input instanceof IPathEditorInput)) {
            throw new PartInitException("Editor Input is not a file");
        }
        this.setInput(input);
        if (reset) {
            this.loadBinaryContent();
        } else {
            site.setSelectionProvider((ISelectionProvider)this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public boolean isDirty() {
        return this.manager.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove(listener);
        }
    }

    public void setFocus() {
    }

    public void setSelection(ISelection selection) {
        long start;
        if (selection.isEmpty()) {
            return;
        }
        StructuredSelection aSelection = (StructuredSelection)selection;
        long[] startEnd = (long[])aSelection.getFirstElement();
        long end = start = startEnd[0];
        if (startEnd.length > 1) {
            end = startEnd[1];
        }
        if (aSelection.size() > 1) {
            startEnd = (long[])aSelection.toArray()[1];
            end = startEnd[0];
            if (startEnd.length > 1) {
                end = startEnd[1];
            }
        }
        this.manager.setSelection(start, end);
    }

    public void updateActionsStatus() {
        boolean textSelected = this.manager.isTextSelected();
        boolean lengthModifiable = textSelected && !this.manager.isOverwriteMode();
        IActionBars bars = this.getEditorSite().getActionBars();
        IAction action = bars.getGlobalActionHandler("org.eclipse.ui.edit.undo");
        if (action != null) {
            action.setEnabled(this.manager.canUndo());
        }
        if ((action = bars.getGlobalActionHandler("org.eclipse.ui.edit.redo")) != null) {
            action.setEnabled(this.manager.canRedo());
        }
        if ((action = bars.getGlobalActionHandler("org.eclipse.ui.edit.cut")) != null) {
            action.setEnabled(lengthModifiable);
        }
        if ((action = bars.getGlobalActionHandler("org.eclipse.ui.edit.copy")) != null) {
            action.setEnabled(textSelected);
        }
        if ((action = bars.getGlobalActionHandler("org.eclipse.ui.edit.delete")) != null) {
            action.setEnabled(lengthModifiable);
        }
        bars.updateActionBars();
    }

    public void menuAboutToShow(IMenuManager manager) {
        manager.add((IAction)new EditorAction("org.eclipse.ui.edit.copy", BinaryEditorMessages.dialog_find_replace_copy));
        manager.add((IAction)new EditorAction("org.eclipse.ui.edit.paste", BinaryEditorMessages.dialog_find_replace_paste));
        manager.add((IAction)new EditorAction("org.eclipse.ui.edit.selectAll", WorkbenchMessages.Workbench_selectAll));
        manager.add((IAction)new EditorAction("org.eclipse.ui.edit.findReplace", BinaryEditorMessages.dialog_find_replace_find_replace));
        manager.add((IAction)new EditorAction("org.eclipse.ui.edit.text.goto.line", BinaryEditorMessages.dialog_find_replace_goto_line));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new EditorAction("org.eclipse.ui.edit.undo", BinaryEditorMessages.dialog_find_replace_undo));
        manager.add((IAction)new EditorAction("org.eclipse.ui.edit.redo", BinaryEditorMessages.dialog_find_replace_redo));
    }

    class EditorAction
    extends Action {
        String actionId;

        EditorAction(String actionId, String text) {
            super(text);
            this.actionId = null;
            this.actionId = actionId;
            this.setActionDefinitionId(actionId);
        }

        EditorAction(String id) {
            this.actionId = null;
            this.actionId = id;
            this.setActionDefinitionId(this.actionId);
        }

        public void run() {
            switch (this.actionId) {
                case "org.eclipse.ui.edit.undo": {
                    BinaryEditor.this.manager.doUndo();
                    break;
                }
                case "org.eclipse.ui.edit.redo": {
                    BinaryEditor.this.manager.doRedo();
                    break;
                }
                case "org.eclipse.ui.edit.cut": {
                    BinaryEditor.this.manager.doCut();
                    break;
                }
                case "org.eclipse.ui.edit.copy": {
                    BinaryEditor.this.manager.doCopy();
                    break;
                }
                case "org.eclipse.ui.edit.paste": {
                    BinaryEditor.this.manager.doPaste();
                    break;
                }
                case "org.eclipse.ui.edit.delete": {
                    BinaryEditor.this.manager.doDelete();
                    break;
                }
                case "org.eclipse.ui.edit.selectAll": {
                    BinaryEditor.this.manager.doSelectAll();
                    break;
                }
                case "org.eclipse.ui.edit.findReplace": {
                    BinaryEditor.this.manager.doFind();
                    break;
                }
                case "org.eclipse.ui.edit.text.goto.line": {
                    BinaryEditor.this.manager.doGoTo();
                }
            }
        }
    }
}

