/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.gis.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;

public class GeometryConverter {
    public static final InvertCoordinateFilter INVERT_COORDINATE_FILTER = new InvertCoordinateFilter();
    private int byteOrder = 2;
    private static PrecisionModel precisionModel = new PrecisionModel();
    private static CoordinateSequenceFactory coordinateSequenceFactory = CoordinateArraySequenceFactory.instance();
    private static int outputDimension = 2;
    private static final GeometryConverter INSTANCE = new GeometryConverter();

    public static GeometryConverter getInstance() {
        return INSTANCE;
    }

    public Geometry fromWKT(String str) {
        try {
            return new WKTReader().read(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Geometry fromWKB(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                byte[] sridBytes = new byte[4];
                inputStream.read(sridBytes);
                int srid = ByteOrderValues.getInt((byte[])sridBytes, (int)this.byteOrder);
                GeometryFactory geometryFactory = new GeometryFactory(precisionModel, srid, coordinateSequenceFactory);
                WKBReader wkbReader = new WKBReader(geometryFactory);
                Geometry geometry = wkbReader.read((InStream)new InputStreamInStream((InputStream)inputStream));
                return geometry;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] toWKB(Geometry userObject) {
        if (userObject == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                byte[] sridBytes = new byte[4];
                ByteOrderValues.putInt((int)userObject.getSRID(), (byte[])sridBytes, (int)this.byteOrder);
                outputStream.write(sridBytes);
                WKBWriter wkbWriter = new WKBWriter(outputDimension, this.byteOrder);
                wkbWriter.write(userObject, (OutStream)new OutputStreamOutStream((OutputStream)outputStream));
                return outputStream.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    private static class InvertCoordinateFilter
    implements CoordinateFilter {
        private InvertCoordinateFilter() {
        }

        public void filter(Coordinate coord) {
            double oldX = coord.x;
            coord.x = coord.y;
            coord.y = oldX;
        }
    }
}

