/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.CommonUtils;

public final class DBStructUtils {
    private static final Log log = Log.getLog(DBStructUtils.class);

    public static String generateTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBSTable table, Map<String, Object> options, boolean addComments) throws DBException {
        DBERegistry editorsRegistry = table.getDataSource().getContainer().getPlatform().getEditorsRegistry();
        SQLObjectEditor entityEditor = editorsRegistry.getObjectManager(table.getClass(), SQLObjectEditor.class);
        if (entityEditor instanceof SQLTableManager) {
            DBEPersistAction[] ddlActions = ((SQLTableManager)entityEditor).getTableDDL(monitor, table, options);
            return SQLUtils.generateScript(table.getDataSource(), ddlActions, addComments);
        }
        log.debug("Table editor not found for " + table.getClass().getName());
        return SQLUtils.generateCommentLine(table.getDataSource(), "Can't generate DDL: table editor not found for " + table.getClass().getName());
    }

    public static String generateObjectDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, Map<String, Object> options, boolean addComments) throws DBException {
        DBERegistry editorsRegistry = object.getDataSource().getContainer().getPlatform().getEditorsRegistry();
        SQLObjectEditor entityEditor = editorsRegistry.getObjectManager(object.getClass(), SQLObjectEditor.class);
        if (entityEditor != null) {
            SQLObjectEditor.ObjectCreateCommand createCommand = entityEditor.makeCreateCommand(object, options);
            DBEPersistAction[] ddlActions = createCommand.getPersistActions(monitor, options);
            return SQLUtils.generateScript(object.getDataSource(), ddlActions, addComments);
        }
        log.debug("Object editor not found for " + object.getClass().getName());
        return SQLUtils.generateCommentLine(object.getDataSource(), "Can't generate DDL: object editor not found for " + object.getClass().getName());
    }

    public static String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBSTable table, Map<String, Object> options, boolean addComments) throws DBException {
        String definitionText;
        if (table instanceof DBPScriptObject && !CommonUtils.isEmpty((String)(definitionText = ((DBPScriptObject)((Object)table)).getObjectDefinitionText(monitor, options)))) {
            return definitionText;
        }
        return DBStructUtils.generateTableDDL(monitor, table, options, addComments);
    }

    public static <T extends DBSTable> void generateTableListDDL(@NotNull DBRProgressMonitor monitor, @NotNull StringBuilder sql, @NotNull Collection<T> tablesOrViews, Map<String, Object> options, boolean addComments) throws DBException {
        ArrayList goodTableList = new ArrayList();
        ArrayList cycleTableList = new ArrayList();
        ArrayList viewList = new ArrayList();
        DBStructUtils.sortTableList(monitor, tablesOrViews, goodTableList, cycleTableList, viewList);
        for (DBSTable table : goodTableList) {
            DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, options, addComments));
        }
        ArrayList<DBSTable> goodCycleTableList = new ArrayList<DBSTable>();
        for (DBSTable table : cycleTableList) {
            if (!(table instanceof DBPScriptObjectExt2) || !((DBPScriptObjectExt2)((Object)table)).supportsObjectDefinitionOption("ddl.skipForeignKeys") || !((DBPScriptObjectExt2)((Object)table)).supportsObjectDefinitionOption("ddl.onlyForeignKeys")) continue;
            goodCycleTableList.add(table);
        }
        cycleTableList.removeAll(goodCycleTableList);
        HashMap<String, Object> optionsNoFK = new HashMap<String, Object>(options);
        optionsNoFK.put("ddl.skipForeignKeys", true);
        for (DBSTable table : goodCycleTableList) {
            DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, optionsNoFK, addComments));
        }
        HashMap<String, Object> optionsOnlyFK = new HashMap<String, Object>(options);
        optionsOnlyFK.put("ddl.onlyForeignKeys", true);
        for (DBSTable table : goodCycleTableList) {
            DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, optionsOnlyFK, addComments));
        }
        for (DBSTable table : cycleTableList) {
            DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, options, addComments));
        }
        for (DBSTable table : viewList) {
            DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, options, addComments));
        }
        monitor.done();
    }

    private static void addDDLLine(StringBuilder sql, String ddl) {
        if (!CommonUtils.isEmpty((String)ddl)) {
            sql.append("\n").append(ddl);
        }
    }

    public static <T extends DBSEntity> void sortTableList(DBRProgressMonitor monitor, Collection<T> input, List<T> simpleTables, List<T> cyclicTables, List<T> views) throws DBException {
        ArrayList<DBSEntity> realTables = new ArrayList<DBSEntity>();
        for (DBSEntity entity : input) {
            if (entity instanceof DBSView || entity instanceof DBSTable && ((DBSTable)entity).isView()) {
                views.add(entity);
                continue;
            }
            realTables.add(entity);
        }
        Iterator iterator = realTables.iterator();
        while (iterator.hasNext()) {
            DBSEntity table = (DBSEntity)iterator.next();
            try {
                if (!CommonUtils.isEmpty(table.getAssociations(monitor))) continue;
                simpleTables.add(table);
                iterator.remove();
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        boolean refsFound = true;
        while (refsFound) {
            refsFound = false;
            Iterator iterator2 = realTables.iterator();
            while (iterator2.hasNext()) {
                DBSEntity table = (DBSEntity)iterator2.next();
                try {
                    boolean allGood = true;
                    for (DBSEntityAssociation ref : CommonUtils.safeCollection(table.getAssociations(monitor))) {
                        DBSEntity refEntity = ref.getAssociatedEntity();
                        if (refEntity != null && (simpleTables.contains(refEntity) || refEntity == table)) continue;
                        allGood = false;
                        break;
                    }
                    if (!allGood) continue;
                    simpleTables.add(table);
                    iterator2.remove();
                    refsFound = true;
                }
                catch (DBException e) {
                    log.error(e);
                }
            }
        }
        cyclicTables.addAll(realTables);
    }
}

