/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.ui.ProgramInfo;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;

public class DefaultResourceHandlerImpl
extends AbstractResourceHandler {
    public static final DefaultResourceHandlerImpl INSTANCE = new DefaultResourceHandlerImpl();

    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        if (resource instanceof IFolder) {
            return 30;
        }
        return super.getFeatures(resource);
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        ProgramInfo program = ProgramInfo.getProgram((IResource)resource);
        if (program != null) {
            return program.getProgram().getName();
        }
        return "resource";
    }

    public String getResourceDescription(@NotNull IResource resource) {
        return "";
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        DBNResource node = super.makeNavigatorNode(parentNode, resource);
        this.updateNavigatorNode(node, resource);
        return node;
    }

    public void updateNavigatorNode(@NotNull DBNResource node, @NotNull IResource resource) {
        super.updateNavigatorNode(node, resource);
        ProgramInfo program = ProgramInfo.getProgram((IResource)resource);
        if (program != null && program.getImage() != null) {
            node.setResourceImage(program.getImage());
        }
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        if (resource instanceof IFile) {
            IDE.openEditor((IWorkbenchPage)UIUtils.getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)resource));
        }
    }
}

